/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ir.IrField;
import sedonac.ir.IrType;
import sedonac.namespace.Field;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public class FieldLayout
extends CompilerStep {
    Location loc;
    IrType[] types;
    HashMap processing;
    HashMap todo;
    int refSize;

    public FieldLayout(Compiler compiler) {
        super(compiler);
        this.refSize = compiler.image == null ? 4 : compiler.image.refSize;
    }

    @Override
    public void run() {
        this.log.debug("  FieldLayout");
        this.findIrTypes();
        this.layoutInstanceFields();
        this.layoutStaticFields();
        if (this.compiler.dumpLayout) {
            this.dump();
        }
        this.quitIfErrors();
    }

    private void findIrTypes() {
        IrType irType;
        int n;
        this.todo = new HashMap();
        for (n = 0; n < this.flat.types.length; ++n) {
            irType = this.flat.types[n];
            this.todo.put(irType.qname, irType);
        }
        if (this.compiler.ir != null) {
            for (n = 0; n < this.compiler.ir.types.length; ++n) {
                irType = this.compiler.ir.types[n];
                this.todo.put(irType.qname, irType);
            }
        }
        this.types = this.todo.values().toArray(new IrType[this.todo.size()]);
    }

    private void layoutInstanceFields() {
        int n;
        this.processing = new HashMap();
        for (n = 0; n < this.types.length; ++n) {
            this.layoutInstanceFields(this.types[n]);
        }
        this.quitIfErrors();
        for (n = 0; n < this.types.length; ++n) {
            if (this.types[n].sizeof >= 0) continue;
            throw new IllegalStateException();
        }
    }

    private void layoutInstanceFields(IrType irType) {
        String string = irType.qname;
        if (!this.todo.containsKey(string)) {
            return;
        }
        if (this.processing.containsKey(string)) {
            this.err("Cyclic inline field in '" + string + "'", this.loc);
            return;
        }
        this.processing.put(string, irType);
        this.loc = new Location(irType.qname);
        int n = 0;
        if (irType.base != null) {
            if (irType.base.sizeof() < 0) {
                this.layoutInstanceFields(TypeUtil.ir(irType.base));
            }
            n = irType.base.isVirtual() ? (n += this.compiler.image != null ? this.compiler.image.blockIndexSize : 2) : irType.base.sizeof();
        }
        if (n < 0) {
            throw new IllegalStateException(irType.qname);
        }
        irType.sizeof = this.layoutFields(n, irType.instanceFields());
        this.processing.remove(string);
        this.todo.remove(string);
    }

    private void layoutStaticFields() {
        int n = this.layoutFields(0, this.flat.staticFields);
        if (n < 0) {
            throw this.err("Data size could not be computed");
        }
        this.compiler.dataSize = n;
    }

    private int layoutFields(int n, IrField[] irFieldArray) {
        n = this.layoutFields(irFieldArray, n, 1);
        while (n % 2 != 0) {
            ++n;
        }
        n = this.layoutFields(irFieldArray, n, 2);
        while (n % 4 != 0) {
            ++n;
        }
        n = this.layoutFields(irFieldArray, n, 4);
        IrField irField = null;
        for (int i = 0; i < irFieldArray.length; ++i) {
            int n2;
            Type type;
            IrField irField2 = irFieldArray[i];
            if (irFieldArray[i].offset != -1) continue;
            this.loc = new Location(irField2.qname);
            if (!irField2.isInline()) {
                throw new IllegalStateException(irField2.qname);
            }
            if (irField2.isConst()) {
                irField2.offset = n;
                continue;
            }
            if (irField2.ctorLengthParam >= 0) {
                if (irField != null) {
                    throw new IllegalStateException("More than one unsized array? " + irField2.qname);
                }
                irField = irField2;
                continue;
            }
            Type type2 = type = irField2.type;
            if (type.isArray() && type.arrayOf().isRef()) {
                type2 = irField2.arrayInit ? type.arrayOf() : null;
            }
            if (type2 != null && type2.sizeof() < 0) {
                this.layoutInstanceFields(TypeUtil.ir(type2));
                if (type2.sizeof() < 0) {
                    return -1;
                }
            }
            if (type.isArray() && type.arrayOf().isRef()) {
                Type type3 = type.arrayOf();
                int n3 = type.arrayLength().val();
                n2 = n3 * this.refSize;
                if (irField2.arrayInit) {
                    n2 += n3 * type3.sizeof();
                }
            } else {
                n2 = irField2.ctorLengthArg != null ? this.calcDynamicSize(irField2) : type.sizeof();
            }
            if (n2 < 0) {
                throw new IllegalStateException();
            }
            if (n % 4 != 0) {
                throw new IllegalStateException();
            }
            irField2.offset = n;
            n += n2;
            while (n % 4 != 0) {
                ++n;
            }
        }
        if (irField != null) {
            irField.offset = n;
        }
        if (n % 4 != 0) {
            throw new IllegalStateException();
        }
        return n;
    }

    private int layoutFields(IrField[] irFieldArray, int n, int n2) {
        if (n % n2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < irFieldArray.length; ++i) {
            boolean bl;
            IrField irField = irFieldArray[i];
            Type type = irField.type;
            int n3 = n2;
            if (type.isPrimitive()) {
                if (type.sizeof() == 8) {
                    bl = n2 == 4;
                    n3 = 8;
                } else {
                    bl = type.sizeof() == n2;
                }
            } else if (irField.isConst() && !irField.isInline()) {
                bl = this.compiler.image != null ? n2 == this.compiler.image.blockIndexSize : n2 == 2;
            } else {
                boolean bl2 = bl = n2 == this.refSize && !irField.isInline();
            }
            if (!bl) continue;
            irField.offset = n;
            n += n3;
        }
        return n;
    }

    private int calcDynamicSize(IrField irField) {
        int n = irField.ctorLengthArg instanceof Expr.Literal ? ((Expr.Literal)irField.ctorLengthArg).asInt() : ((Expr.Field)irField.ctorLengthArg).field.define().asInt();
        int n2 = irField.type.sizeof();
        Field field = TypeUtil.getUnsizedArrayField(irField.type);
        Type type = field.type().arrayOf();
        int n3 = type.isRef() ? this.refSize : type.sizeof();
        return n2 + n3 * n;
    }

    private void dump() {
        System.out.println("==== FieldLayout =====");
        IrType[] irTypeArray = (IrType[])this.types.clone();
        Arrays.sort(irTypeArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        for (int i = 0; i < irTypeArray.length; ++i) {
            IrType irType = irTypeArray[i];
            IrField[] irFieldArray = irType.instanceFields();
            if (irFieldArray.length == 0) continue;
            System.out.println("  --- " + irType.qname + " [sizeof " + irType.sizeof + "] ---");
            this.dumpFields(irFieldArray);
        }
        System.out.println("  --- static fields [dataSize " + this.compiler.dataSize + "] ---");
        this.dumpFields(this.flat.staticFields);
        System.out.println("  ---------------------");
    }

    private void dumpFields(IrField[] irFieldArray) {
        Arrays.sort(irFieldArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((IrField)object).offset > ((IrField)object2).offset ? 1 : -1;
            }
        });
        for (int i = 0; i < irFieldArray.length; ++i) {
            System.out.println("    " + TextUtil.pad((String)(irFieldArray[i].offset + ": "), (int)5) + irFieldArray[i].qname);
        }
    }
}

