/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ir;

import java.util.ArrayList;
import java.util.HashMap;
import sedona.kit.KitFile;
import sedona.manifest.KitManifest;
import sedona.util.Version;
import sedonac.Location;
import sedonac.ir.IrAddressable;
import sedonac.ir.IrType;
import sedonac.namespace.Kit;
import sedonac.namespace.Type;

public class IrKit
implements Kit,
IrAddressable {
    public Location loc;
    public KitFile file;
    public int id;
    public String name;
    public Version version;
    public boolean test;
    public IrType[] types;
    public HashMap typesByName;
    public int blockIndex;
    public KitManifest manifest;

    public IrKit(Location location, String string) {
        this.loc = location;
        this.name = string;
    }

    public IrKit(Location location, KitFile kitFile) {
        this.loc = location;
        this.name = kitFile.name;
        this.file = kitFile;
    }

    public IrKit() {
    }

    public void dump() {
        System.out.println("Kit " + this.name + " [" + this.id + "]");
        for (int i = 0; this.types != null && i < this.types.length; ++i) {
            this.types[i].dump();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type[] types() {
        return this.types;
    }

    @Override
    public Type type(String string) {
        if (this.typesByName != null) {
            return (Type)this.typesByName.get(string);
        }
        System.out.println("WARNING: IrKit.typesByName not set yet");
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].name.equals(string)) continue;
            return this.types[i];
        }
        return null;
    }

    public IrType[] reflectiveTypes() {
        ArrayList<IrType> arrayList = new ArrayList<IrType>();
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isReflective()) continue;
            arrayList.add(this.types[i]);
        }
        return arrayList.toArray(new IrType[arrayList.size()]);
    }

    public IrType[] compTypes() {
        ArrayList<IrType> arrayList = new ArrayList<IrType>();
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isaComponent()) continue;
            arrayList.add(this.types[i]);
        }
        return arrayList.toArray(new IrType[arrayList.size()]);
    }

    @Override
    public int getBlockIndex() {
        return this.blockIndex;
    }

    @Override
    public void setBlockIndex(int n) {
        this.blockIndex = n;
    }

    @Override
    public boolean alignBlockIndex() {
        return true;
    }
}

