/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ir;

import java.util.ArrayList;
import sedonac.ir.IrField;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.ir.IrPrimitive;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.Namespace;

public class IrFlat {
    public IrKit[] kits;
    public IrPrimitive[] primitives;
    public IrType[] types;
    public IrType[] reflectiveTypes;
    public IrType[] virtTypes;
    public IrType[] compTypes;
    public IrSlot[] reflectiveSlots;
    public IrField[] fields;
    public IrField[] staticFields;
    public IrField[] logDefines;
    public IrMethod[] methods;
    public IrMethod[] staticInits;

    public IrFlat(Namespace namespace, IrKit[] irKitArray) {
        int n;
        ArrayList<IrType> arrayList = new ArrayList<IrType>();
        this.primitives = new IrPrimitive[namespace.primitiveTypes.length];
        for (n = 0; n < this.primitives.length; ++n) {
            this.primitives[n] = new IrPrimitive(namespace.primitiveTypes[n]);
        }
        for (n = 0; n < this.primitives.length; ++n) {
            if (this.primitives[n].type.id == n) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < irKitArray.length; ++n) {
            for (int i = 0; i < irKitArray[n].types.length; ++i) {
                IrType irType = irKitArray[n].types[i];
                arrayList.add(irType);
            }
        }
        this.kits = irKitArray;
        this.types = arrayList.toArray(new IrType[arrayList.size()]);
    }

    public void preResolve() {
        ArrayList<IrSlot> arrayList = new ArrayList<IrSlot>();
        ArrayList<IrSlot> arrayList2 = new ArrayList<IrSlot>();
        ArrayList<IrSlot> arrayList3 = new ArrayList<IrSlot>();
        ArrayList<IrSlot> arrayList4 = new ArrayList<IrSlot>();
        ArrayList<IrSlot> arrayList5 = new ArrayList<IrSlot>();
        for (int i = 0; i < this.types.length; ++i) {
            IrType irType = this.types[i];
            IrSlot[] irSlotArray = irType.declared;
            for (int j = 0; j < irSlotArray.length; ++j) {
                IrSlot irSlot;
                IrSlot irSlot2 = irSlotArray[j];
                if (irSlot2.isProperty() || irSlot2.isAction()) {
                    arrayList5.add(irSlot2);
                }
                if (irSlot2 instanceof IrMethod) {
                    irSlot = (IrMethod)irSlot2;
                    arrayList3.add(irSlot);
                    if (!((IrMethod)irSlot).isStaticInit()) continue;
                    arrayList4.add(irSlot);
                    continue;
                }
                irSlot = (IrField)irSlot2;
                arrayList.add(irSlot);
                if (!irSlot.isStatic() || irSlot.isDefine() || irSlot.isConst()) continue;
                arrayList2.add(irSlot);
            }
        }
        this.fields = arrayList.toArray(new IrField[arrayList.size()]);
        this.staticFields = arrayList2.toArray(new IrField[arrayList2.size()]);
        this.methods = arrayList3.toArray(new IrMethod[arrayList3.size()]);
        this.staticInits = arrayList4.toArray(new IrMethod[arrayList4.size()]);
        this.reflectiveSlots = arrayList5.toArray(new IrSlot[arrayList5.size()]);
    }

    public void postResolve() {
        ArrayList<IrType> arrayList = new ArrayList<IrType>();
        ArrayList<IrType> arrayList2 = new ArrayList<IrType>();
        ArrayList<IrType> arrayList3 = new ArrayList<IrType>();
        ArrayList<IrField> arrayList4 = new ArrayList<IrField>();
        for (int i = 0; i < this.types.length; ++i) {
            IrType irType = this.types[i];
            if (irType.isaComponent()) {
                arrayList.add(irType);
            }
            if (irType.isaVirtual()) {
                arrayList2.add(irType);
            }
            if (irType.isReflective()) {
                arrayList3.add(irType);
            }
            IrSlot[] irSlotArray = irType.declared;
            for (int j = 0; j < irSlotArray.length; ++j) {
                IrField irField;
                IrSlot irSlot = irSlotArray[j];
                if (!irSlot.isField() || !(irField = (IrField)irSlot).isDefine() || !irField.type.isLog()) continue;
                arrayList4.add(irField);
            }
        }
        this.compTypes = arrayList.toArray(new IrType[arrayList.size()]);
        this.virtTypes = arrayList2.toArray(new IrType[arrayList2.size()]);
        this.reflectiveTypes = arrayList3.toArray(new IrType[arrayList3.size()]);
        this.logDefines = arrayList4.toArray(new IrField[arrayList4.size()]);
    }

    public void dumpTypes() {
        System.out.println("-- IrFlat.dumpTypes ---");
        for (int i = 0; i < this.types.length; ++i) {
            System.out.println("  " + i + ":  " + this.types[i].qname);
        }
    }
}

