/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import sedonac.Location;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.Expr;
import sedonac.ast.FacetDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Field;
import sedonac.namespace.Type;

public class FieldDef
extends SlotDef
implements Field {
    public Type type;
    public Expr init;
    public Expr[] ctorArgs;
    public int ctorLengthParam = -1;

    public FieldDef(Location location, TypeDef typeDef, int n, String string, FacetDef[] facetDefArray, Type type, Expr expr, Expr[] exprArray) {
        super(location, typeDef, n, string, facetDefArray);
        this.type = type;
        this.init = expr;
        this.ctorArgs = exprArray;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isMethod() {
        return false;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public Expr.Literal define() {
        return (Expr.Literal)this.init;
    }

    @Override
    public int ctorLengthParam() {
        return this.ctorLengthParam;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isStatic()) {
            stringBuffer.append("static ");
        }
        if (this.isInline()) {
            stringBuffer.append("inline ");
        }
        stringBuffer.append(this.type);
        if (this.ctorArgs != null) {
            stringBuffer.append("(");
            for (int i = 0; i < this.ctorArgs.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.ctorArgs[i]);
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(" ").append(this.name);
        if (this.init != null) {
            stringBuffer.append(" = ").append(this.init);
        }
        if (this.ctorLengthParam > 0) {
            stringBuffer.append(" // ctorLengthParam=").append(this.ctorLengthParam);
        }
        return stringBuffer.toString();
    }

    @Override
    public void walk(AstVisitor astVisitor, int n) {
        astVisitor.enterField(this);
        this.walkFacets(astVisitor, n);
        this.type = astVisitor.type(this.type);
        if (n >= 3 && this.init != null) {
            this.init = this.init.walk(astVisitor);
        }
        astVisitor.exitField(this);
    }

    @Override
    public void write(AstWriter astWriter) {
        astWriter.indent().w(this).nl();
    }
}

