/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import sun.security.mscapi.Key;
import sun.security.mscapi.RSAPrivateKey;
import sun.security.mscapi.RSAPublicKey;
import sun.security.rsa.RSAKeyFactory;

abstract class RSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private boolean needsReset;
    private Key privateKey = null;
    private Key publicKey = null;

    RSASignature(String string) {
        try {
            this.messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.needsReset = false;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) {
            throw new InvalidKeyException("Key type not supported");
        }
        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
        if (!(publicKey instanceof RSAPublicKey)) {
            try {
                BigInteger bigInteger = rSAPublicKey.getModulus();
                BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
                RSAKeyFactory.checkKeyLengths(bigInteger.bitLength() + 7 & 0xFFFFFFF8, bigInteger2, -1, 16384);
                byte[] byArray = bigInteger.toByteArray();
                byte[] byArray2 = bigInteger2.toByteArray();
                int n = byArray[0] == 0 ? (byArray.length - 1) * 8 : byArray.length * 8;
                byte[] byArray3 = this.generatePublicKeyBlob(n, byArray, byArray2);
                this.publicKey = this.importPublicKey(byArray3, n);
            }
            catch (KeyException keyException) {
                throw new InvalidKeyException(keyException);
            }
            catch (KeyStoreException keyStoreException) {
                throw new InvalidKeyException(keyStoreException);
            }
        } else {
            this.publicKey = (RSAPublicKey)publicKey;
        }
        if (this.needsReset) {
            this.messageDigest.reset();
            this.needsReset = false;
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key type not supported");
        }
        this.privateKey = (RSAPrivateKey)privateKey;
        RSAKeyFactory.checkKeyLengths(this.privateKey.bitLength() + 7 & 0xFFFFFFF8, null, 512, 16384);
        if (this.needsReset) {
            this.messageDigest.reset();
            this.needsReset = false;
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.messageDigest.update(by);
        this.needsReset = true;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.messageDigest.update(byArray, n, n2);
        this.needsReset = true;
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.messageDigest.digest();
        this.needsReset = false;
        byte[] byArray2 = RSASignature.signHash(byArray, byArray.length, this.messageDigest.getAlgorithm(), this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
        return this.convertEndianArray(byArray2);
    }

    private byte[] convertEndianArray(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return byArray2;
    }

    private static native byte[] signHash(byte[] var0, int var1, String var2, long var3, long var5) throws SignatureException;

    private static native boolean verifySignedHash(byte[] var0, int var1, String var2, byte[] var3, int var4, long var5, long var7) throws SignatureException;

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = this.messageDigest.digest();
        this.needsReset = false;
        return RSASignature.verifySignedHash(byArray2, byArray2.length, this.messageDigest.getAlgorithm(), this.convertEndianArray(byArray), byArray.length, this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    private native byte[] generatePublicKeyBlob(int var1, byte[] var2, byte[] var3) throws KeyException;

    private native RSAPublicKey importPublicKey(byte[] var1, int var2) throws KeyException, KeyStoreException;

    public static final class MD2
    extends RSASignature {
        public MD2() {
            super("MD2");
        }
    }

    public static final class MD5
    extends RSASignature {
        public MD5() {
            super("MD5");
        }
    }

    public static final class SHA512
    extends RSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384
    extends RSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256
    extends RSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA1
    extends RSASignature {
        public SHA1() {
            super("SHA1");
        }
    }
}

