/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sedona.Env;
import sedona.util.TextUtil;
import sedonac.test.TestException;
import sedonac.test.Verifies;

public class Test
extends Verifies {
    int verified;
    int failed;

    public static int run(String string) {
        try {
            long l = Env.ticks();
            int n = 0;
            int n2 = 0;
            String[] stringArray = new String[]{"sedonac.test.TokenizerTest", "sedonac.test.ParserTest", "sedonac.test.DefiniteAssignmentTest", "sedonac.test.DeadCodeTest", "sedonac.test.ManifestTest", "sedonac.test.KitDbTest", "sedonac.test.AppTest", "sedonac.test.DocParserTest", "sedonac.test.DaspTest", "sedonac.test.SoxTest", "sedonac.test.SecurityTest", "sedonac.test.PrimitiveDecodeTest", "sedonac.test.PstoreTest"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (string != null && !TextUtil.getClassName((String)stringArray[i]).equals(string)) continue;
                Class<?> clazz = Class.forName(stringArray[i]);
                Test test = (Test)clazz.newInstance();
                test.run();
                n += test.verified;
                n2 += test.failed;
            }
            long l2 = Env.ticks();
            System.out.println();
            if (n2 == 0) {
                System.out.println("ALL TESTS PASSED " + n + " total verifies [" + (l2 - l) + "ms]");
            } else {
                System.out.println("SOME TESTS FAILED " + n2 + " total failures [" + (l2 - l) + "ms]");
            }
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    public void run() throws Exception {
        Method[] methodArray = this.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getDeclaringClass() == Test.class || !method.getName().startsWith("test")) continue;
            this.run(method);
        }
    }

    public void run(Method method) throws Exception {
        System.out.print("-- " + this.getClass().getName() + "." + method.getName());
        System.out.flush();
        int n = this.verified;
        try {
            method.invoke((Object)this, new Object[0]);
            System.out.println(" [" + (this.verified - n) + " verifies]");
        }
        catch (InvocationTargetException invocationTargetException) {
            ++this.failed;
            System.out.println("\nFAILED");
            invocationTargetException.getTargetException().printStackTrace();
        }
    }

    @Override
    public void verify(boolean bl, String string) {
        if (bl) {
            ++this.verified;
        } else {
            throw new TestException(string);
        }
    }

    public File testDir() {
        File file = new File(Env.home, "test");
        file.mkdirs();
        this.verify(file.exists());
        return file;
    }

    public String getSvmName() {
        if (this.isWindows()) {
            return "svm.exe";
        }
        if (this.isLinux()) {
            return "svm";
        }
        throw new IllegalStateException("Unsupported OS: " + System.getProperty("os.name"));
    }

    public boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") > -1;
    }

    public boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().indexOf("linux") > -1;
    }
}

