/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import sedonac.test.Test;
import sedonac.util.DocParser;

public class DocParserTest
extends Test {
    public void testParser() throws Exception {
        this.verify("Foo", new DocParser.DocNode[]{this.p("Foo")});
        this.verify("Foo\nBar", new DocParser.DocNode[]{this.p("Foo\nBar")});
        this.verify("Foo\n\nBar", new DocParser.DocNode[]{this.p("Foo"), this.p("Bar")});
        this.verify("\nFoo\n\nBar\n", new DocParser.DocNode[]{this.p("Foo"), this.p("Bar")});
        this.verify("\n\n\nFoo\n\n\n\nBar\n\n\n", new DocParser.DocNode[]{this.p("Foo"), this.p("Bar")});
        this.verify("Foo\n Bar", new DocParser.DocNode[]{this.p("Foo"), this.pre(" Bar")});
        this.verify("Foo\n Bar\n Cool", new DocParser.DocNode[]{this.p("Foo"), this.pre(" Bar\n Cool")});
        this.verify("Foo\n Bar\n Cool\nFoo", new DocParser.DocNode[]{this.p("Foo"), this.pre(" Bar\n Cool"), this.p("Foo")});
    }

    private DocParser.ParaNode p(String string) {
        return new DocParser.ParaNode(string);
    }

    private DocParser.PreNode pre(String string) {
        return new DocParser.PreNode(string);
    }

    private void verify(String string, DocParser.DocNode[] docNodeArray) throws Exception {
        DocParser.DocNode[] docNodeArray2 = new DocParser(string).parse();
        try {
            this.verify(docNodeArray2.length == docNodeArray.length);
            for (int i = 0; i < docNodeArray2.length; ++i) {
                this.verify(docNodeArray2[i].id() == docNodeArray[i].id());
                this.verify(docNodeArray2[i].text.equals(docNodeArray[i].text));
            }
        }
        catch (Exception exception) {
            System.out.println("\nOriginal Text:");
            System.out.println(string);
            System.out.println("");
            for (int i = 0; i < docNodeArray2.length; ++i) {
                System.out.println("--- " + docNodeArray2[i] + "----");
                System.out.println(docNodeArray2[i].text);
            }
            throw exception;
        }
    }
}

