/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import sedona.Env;
import sedona.util.FileUtil;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.Location;
import sedonac.steps.InitImageCompile;

public class StageNatives
extends InitImageCompile {
    File stageDir;

    public StageNatives(Compiler compiler) {
        super(compiler);
        this.xmlFile = compiler.input;
        this.xmlDir = this.xmlFile.getParentFile();
        this.xml = compiler.xml;
        this.stageDir = compiler.outDir;
    }

    @Override
    public void run() {
        try {
            this.log.info("  StageVM [" + this.stageDir + "]");
            this.copySourceDirs();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
        catch (CompilerException compilerException) {
            throw compilerException;
        }
        catch (Exception exception) {
            throw this.err("Cannot stage VM", new Location(this.stageDir), (Throwable)exception);
        }
    }

    public void copySourceDirs() {
        String[] stringArray = this.compiler.platform.nativePaths;
        if (stringArray.length == 0) {
            throw this.err("Must have at least one <nativeSource> element", new Location(this.xml));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.copySourceDir(stringArray[i]);
        }
    }

    public void copySourceDir(String string) {
        Location location = new Location(this.xml);
        if (!string.startsWith("/")) {
            throw this.err("Paths must start with / and be relative to sedona home: " + string, location);
        }
        File file = new File(Env.home, string.substring(1));
        if (!file.exists() || !file.isDirectory()) {
            this.warn("Source path not found '" + file + "'");
            return;
        }
        File[] fileArray = file.listFiles();
        this.log.debug("    Copy '" + file + "' [" + fileArray.length + " files]");
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) continue;
            try {
                FileUtil.copyFile((File)file2, (File)new File(this.stageDir, file2.getName()));
                continue;
            }
            catch (IOException iOException) {
                throw this.err("Cannot copy file", new Location(file2), (Throwable)iOException);
            }
        }
    }
}

