/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.TypeDef;
import sedonac.namespace.Type;

public abstract class OrderTypes
extends CompilerStep {
    HashMap processing;
    HashMap todo;
    ArrayList ordered;

    public OrderTypes(Compiler compiler) {
        super(compiler);
    }

    public void order(Type[] typeArray) {
        int n;
        this.log.debug("  OrderTypes");
        this.ordered = new ArrayList();
        this.processing = new HashMap();
        Arrays.sort(typeArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Type)object).qname().compareTo(((Type)object2).qname());
            }
        });
        this.todo = new HashMap();
        for (n = 0; n < typeArray.length; ++n) {
            Type type = typeArray[n];
            String string = type.qname();
            if (this.todo.get(string) != null) {
                this.err("Duplicate type name: " + string, this.toLoc(type));
                continue;
            }
            this.todo.put(string, type);
        }
        this.quitIfErrors();
        for (n = 0; n < typeArray.length; ++n) {
            this.process(typeArray[n]);
        }
        this.quitIfErrors();
        if (this.ordered.size() != typeArray.length) {
            throw new IllegalStateException();
        }
        this.ordered.toArray(typeArray);
        if (this.log.isDebug()) {
            for (n = 0; n < typeArray.length; ++n) {
                this.log.debug("    " + typeArray[n]);
            }
        }
    }

    private void process(Type type) {
        if ((type = (Type)this.todo.get(type.qname())) == null) {
            return;
        }
        String string = type.qname();
        if (this.processing.containsKey(string)) {
            Location location = new Location(string);
            this.err("Cyclic inheritance: " + string, this.toLoc(type));
            return;
        }
        this.processing.put(string, type);
        if (type.base() != null) {
            this.process(type.base());
        }
        this.processing.remove(string);
        this.todo.remove(string);
        this.ordered.add(type);
    }

    public Location toLoc(Type type) {
        if (type instanceof TypeDef) {
            return ((TypeDef)type).loc;
        }
        return new Location(type.qname());
    }
}

