/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sedona.Env;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.KitDef;
import sedonac.ast.TypeDef;
import sedonac.parser.Parser;
import sedonac.translate.Translation;

public class InitTranslate
extends CompilerStep {
    File xmlDir;
    File xmlFile;
    XElem xml;

    public InitTranslate(Compiler compiler) {
        super(compiler);
        this.xmlFile = compiler.input;
        this.xmlDir = this.xmlFile.getParentFile();
        this.xml = compiler.xml;
    }

    @Override
    public void run() {
        try {
            this.log.debug("  InitTranslate");
            this.parseTranslation();
            this.parseKits();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    private void parseTranslation() {
        Translation translation = new Translation();
        translation.main = this.xml.get("main");
        translation.target = this.xml.get("target");
        translation.outDir = new File(this.xmlDir, this.xml.get("outDir", translation.target));
        this.compiler.translation = translation;
    }

    private void parseKits() {
        ArrayList<KitDef> arrayList = new ArrayList<KitDef>();
        XElem[] xElemArray = this.xml.elems("kit");
        if (xElemArray.length == 0) {
            throw this.err("Must specify at least one <kit> element", new Location(this.xml));
        }
        for (int i = 0; i < xElemArray.length; ++i) {
            String string = xElemArray[i].get("name");
            try {
                arrayList.add(this.parseKit(string));
                continue;
            }
            catch (IOException iOException) {
                throw this.err("Cannot parse kit: " + string, (Location)null, (Throwable)iOException);
            }
        }
        this.compiler.translation.kits = arrayList.toArray(new KitDef[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KitDef parseKit(String string) throws IOException {
        File file = new File(Env.home, "kits" + File.separator + string + ".kit");
        if (!file.exists() || file.isDirectory()) {
            throw this.err("Cannot find kit '" + string + "'", new Location(file));
        }
        KitDef kitDef = new KitDef(new Location(file));
        kitDef.name = string;
        this.compiler.ast = kitDef;
        ArrayList arrayList = new ArrayList();
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (!string2.startsWith("source/") || !string2.endsWith(".sedona")) continue;
                this.parse(file, zipFile, zipEntry, arrayList);
            }
        }
        finally {
            zipFile.close();
        }
        this.compiler.ast.types = arrayList.toArray(new TypeDef[arrayList.size()]);
        return kitDef;
    }

    private void parse(File file, ZipFile zipFile, ZipEntry zipEntry, ArrayList arrayList) throws IOException {
        Location location = new Location(file + "|" + zipEntry.getName());
        this.log.debug("    Parse [" + location + "]");
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        TypeDef[] typeDefArray = new Parser(this.compiler, location, inputStream).parse();
        for (int i = 0; i < typeDefArray.length; ++i) {
            arrayList.add(typeDefArray[i]);
        }
    }
}

