/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import sedona.Depend;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.scode.SCodeImage;

public class InitImageCompile
extends CompilerStep {
    File xmlFile;
    File xmlDir;
    XElem xml;

    public InitImageCompile(Compiler compiler) {
        super(compiler);
        this.xmlFile = compiler.input;
        this.xmlDir = this.xmlFile.getParentFile();
        this.xml = compiler.xml;
    }

    @Override
    public void run() {
        try {
            this.log.debug("  InitImageCompile");
            this.initImage();
            this.initKits();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    private void initImage() {
        SCodeImage sCodeImage = new SCodeImage();
        sCodeImage.name = this.xml.get("name");
        sCodeImage.endian = this.toEndian(this.xml);
        sCodeImage.blockSize = this.xml.geti("blockSize");
        sCodeImage.blockIndexSize = this.xml.geti("blockIndexSize", 2);
        sCodeImage.refSize = this.xml.geti("refSize");
        sCodeImage.main = this.xml.get("main", "sys::Sys.main");
        sCodeImage.unhibernate = this.xml.get("unhibernate", "sys::Sys.unhibernate");
        sCodeImage.debug = this.xml.getb("debug", false);
        sCodeImage.test = this.xml.getb("test", false);
        sCodeImage.armDouble = this.xml.getb("armDouble", false);
        this.compiler.image = sCodeImage;
    }

    private int toEndian(XElem xElem) {
        String string = xElem.get("endian");
        if (string.equals("big")) {
            return 66;
        }
        if (string.equals("little")) {
            return 76;
        }
        throw new XException("Endian attribute must be 'big' or 'little'", xElem);
    }

    protected void initKits() {
        XElem[] xElemArray = this.xml.elems("depend");
        if (xElemArray.length == 0) {
            throw this.err("Must specify at least one <depend> element", new Location(this.xml));
        }
        boolean bl = this.compiler.image != null ? this.compiler.image.test : false;
        IrKit[] irKitArray = new IrKit[xElemArray.length];
        for (int i = 0; i < irKitArray.length; ++i) {
            XElem xElem = xElemArray[i];
            Location location = new Location(xElem);
            Depend depend = xElem.getDepend("on");
            KitFile kitFile = KitDb.matchBest((Depend)depend);
            if (kitFile == null) {
                this.err("Missing kit dependency '" + depend + "'", location);
                continue;
            }
            this.log.debug("    " + kitFile.toString());
            IrKit irKit = irKitArray[i] = new IrKit(location, kitFile);
            String string = xElem.get("test", null);
            irKit.test = string != null ? string.equals("true") : bl;
        }
        this.compiler.kits = irKitArray;
        this.quitIfErrors();
    }
}

