/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import java.util.ArrayList;
import java.util.HashMap;
import sedonac.Location;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.Block;
import sedonac.ast.FacetDef;
import sedonac.ast.FacetsNode;
import sedonac.ast.FieldDef;
import sedonac.ast.KitDef;
import sedonac.ast.MethodDef;
import sedonac.ast.ParamDef;
import sedonac.ast.SlotDef;
import sedonac.ir.IrType;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Kit;
import sedonac.namespace.Namespace;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public class TypeDef
extends FacetsNode
implements Type {
    public KitDef kit;
    public int flags;
    public String name;
    public String qname;
    public Type base;
    public String doc;
    public FacetDef[] facets;
    public int id = -1;
    public SlotDef[] reflectiveSlots;
    public IrType ir;
    private ArrayList slots = new ArrayList();
    private HashMap slotsByName = new HashMap();

    public TypeDef(Location location, KitDef kitDef, int n, String string, FacetDef[] facetDefArray) {
        super(location, facetDefArray);
        this.kit = kitDef;
        this.flags = n;
        this.name = string;
        this.qname = kitDef.name + "::" + string;
        this.id = TypeUtil.predefinedId(this.qname);
    }

    @Override
    public Kit kit() {
        return this.kit;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String qname() {
        return this.qname;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isRef() {
        return true;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public Type arrayOf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrayType.Len arrayLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String signature() {
        return this.qname;
    }

    @Override
    public int sizeof() {
        return TypeUtil.ir(this).sizeof();
    }

    @Override
    public Type base() {
        return this.base;
    }

    @Override
    public boolean is(Type type) {
        return TypeUtil.is(this, type);
    }

    @Override
    public boolean equals(Object object) {
        return TypeUtil.equals(this, object);
    }

    @Override
    public String toString() {
        return this.signature();
    }

    @Override
    public boolean isObj() {
        return this.qname.equals("sys::Obj");
    }

    @Override
    public boolean isComponent() {
        return this.qname.equals("sys::Component");
    }

    @Override
    public boolean isaComponent() {
        return TypeUtil.isaComponent(this);
    }

    @Override
    public boolean isVirtual() {
        return this.qname.equals("sys::Virtual");
    }

    @Override
    public boolean isaVirtual() {
        return TypeUtil.isaVirtual(this);
    }

    @Override
    public boolean isBuf() {
        return this.qname.equals("sys::Buf");
    }

    @Override
    public boolean isLog() {
        return this.qname.equals("sys::Log");
    }

    @Override
    public boolean isStr() {
        return this.qname.equals("sys::Str");
    }

    @Override
    public boolean isType() {
        return this.qname.equals("sys::Type");
    }

    @Override
    public boolean isBool() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isWide() {
        return false;
    }

    @Override
    public boolean isReflective() {
        return TypeUtil.isReflective(this);
    }

    @Override
    public int id() {
        if (this.id < 0) {
            throw new IllegalStateException(this.qname);
        }
        return this.id;
    }

    @Override
    public Slot[] slots() {
        return this.slots.toArray(new Slot[this.slots.size()]);
    }

    @Override
    public Slot[] declared() {
        return this.slotDefs();
    }

    @Override
    public Slot slot(String string) {
        return (Slot)this.slotsByName.get(string);
    }

    @Override
    public void addSlot(Slot slot) {
        String string = slot.name();
        if (this.slotsByName.containsKey(string)) {
            throw new IllegalStateException(slot.qname());
        }
        this.slots.add(slot);
        this.slotsByName.put(string, slot);
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isConst() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.flags & 0x10) != 0;
    }

    public SlotDef[] slotDefs() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = (Slot)this.slots.get(i);
            if (slot.parent() != this) continue;
            arrayList.add(this.slots.get(i));
        }
        return arrayList.toArray(new SlotDef[arrayList.size()]);
    }

    public MethodDef[] methodDefs() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!(this.slots.get(i) instanceof MethodDef)) continue;
            arrayList.add(this.slots.get(i));
        }
        return arrayList.toArray(new MethodDef[arrayList.size()]);
    }

    public FieldDef[] fieldDefs() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!(this.slots.get(i) instanceof FieldDef)) continue;
            arrayList.add(this.slots.get(i));
        }
        return arrayList.toArray(new FieldDef[arrayList.size()]);
    }

    public MethodDef makeInstanceInit(Namespace namespace) {
        String string = "_iInit";
        MethodDef methodDef = (MethodDef)this.slotsByName.get(string);
        if (methodDef == null) {
            int n = 0;
            methodDef = new MethodDef(this.loc, this, n, string, FacetDef.empty, namespace.voidType, new ParamDef[0], new Block(this.loc));
            methodDef.synthetic = true;
            this.addSlot(methodDef);
        }
        return methodDef;
    }

    public MethodDef makeStaticInit(Namespace namespace) {
        String string = "_sInit";
        MethodDef methodDef = (MethodDef)this.slotsByName.get(string);
        if (methodDef == null) {
            int n = 4096;
            methodDef = new MethodDef(this.loc, this, n, string, FacetDef.empty, namespace.voidType, new ParamDef[0], new Block(this.loc));
            methodDef.synthetic = true;
            this.addSlot(methodDef);
        }
        return methodDef;
    }

    public void walk(AstVisitor astVisitor, int n) {
        astVisitor.enterType(this);
        if (this.base != null) {
            this.base = astVisitor.type(this.base);
        }
        this.walkFacets(astVisitor, n);
        if (n >= 2) {
            for (int i = 0; i < this.slots.size(); ++i) {
                Slot slot = (Slot)this.slots.get(i);
                if (slot.parent() != this) continue;
                ((SlotDef)this.slots.get(i)).walk(astVisitor, n);
            }
        }
        astVisitor.exitType(this);
    }

    @Override
    public void write(AstWriter astWriter) {
        astWriter.w("class ").w(this.qname).nl();
        astWriter.w("{").nl();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!(this.slots.get(i) instanceof SlotDef)) continue;
            if (i > 0) {
                astWriter.nl();
            }
            ++astWriter.indent;
            ((SlotDef)this.slots.get(i)).write(astWriter);
            --astWriter.indent;
        }
        astWriter.w("}").nl();
    }
}

