/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import java.util.ArrayList;
import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.LocalScope;
import sedonac.ast.Stmt;

public class Block
extends AstNode
implements LocalScope {
    public ArrayList stmts = new ArrayList();

    public Block(Location location) {
        super(location);
    }

    public boolean isEmpty() {
        return this.stmts.size() == 0;
    }

    public Stmt[] stmts() {
        return this.stmts.toArray(new Stmt[this.stmts.size()]);
    }

    @Override
    public Stmt.LocalDef[] getLocals() {
        ArrayList<Stmt> arrayList = new ArrayList<Stmt>();
        for (int i = 0; i < this.stmts.size(); ++i) {
            Stmt stmt = (Stmt)this.stmts.get(i);
            if (!(stmt instanceof Stmt.LocalDef)) continue;
            arrayList.add(stmt);
        }
        return arrayList.toArray(new Stmt.LocalDef[arrayList.size()]);
    }

    @Override
    public Stmt.LocalDef resolveLocal(String string) {
        for (int i = 0; i < this.stmts.size(); ++i) {
            Stmt stmt = (Stmt)this.stmts.get(i);
            Stmt.LocalDef localDef = Stmt.LocalDef.isLocal(stmt, string);
            if (localDef == null) continue;
            return localDef;
        }
        return null;
    }

    public int maxStack() {
        int n = 0;
        for (int i = 0; i < this.stmts.size(); ++i) {
            Stmt stmt = (Stmt)this.stmts.get(i);
            n = Math.max(n, stmt.maxStack());
        }
        return n;
    }

    public boolean isExit() {
        if (this.stmts.size() == 0) {
            return false;
        }
        return ((Stmt)this.stmts.get(this.stmts.size() - 1)).isExit();
    }

    public void add(Stmt stmt) {
        this.stmts.add(stmt);
    }

    public void add(int n, Stmt stmt) {
        this.stmts.add(n, stmt);
    }

    public void walk(AstVisitor astVisitor) {
        astVisitor.enterBlock(this);
        for (int i = 0; i < this.stmts.size(); ++i) {
            ((Stmt)this.stmts.get(i)).walk(astVisitor);
        }
        astVisitor.exitBlock(this);
    }

    @Override
    public void write(AstWriter astWriter) {
        this.write(astWriter, true);
    }

    public void write(AstWriter astWriter, boolean bl) {
        if (bl) {
            astWriter.indent().w("{").nl();
        }
        ++astWriter.indent;
        Stmt[] stmtArray = this.stmts();
        for (int i = 0; i < stmtArray.length; ++i) {
            Stmt stmt = stmtArray[i];
            if (stmt.label != null) {
                astWriter.indent().w(stmt.label).w(": ").nl();
            }
            stmt.write(astWriter);
        }
        --astWriter.indent;
        if (bl) {
            astWriter.indent().w("}").nl();
        }
    }
}

