/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.util.Properties;
import sedona.Env;

public class VarResolver {
    private static final String OS = "os.env.";
    private static final String SEDONA = "sedona.env.";
    protected Properties vars;

    public VarResolver() {
        this(new Properties());
    }

    public VarResolver(Properties properties) {
        this.vars = properties;
    }

    public String resolve(String string) throws Exception {
        return this.resolve(string, new Properties());
    }

    public String resolve(String string, Properties properties) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        try {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c != '$') {
                    stringBuffer.append(c);
                    continue;
                }
                if ((c = string.charAt(++i)) == '$') {
                    stringBuffer.append(c);
                    continue;
                }
                if (c != '{') {
                    throw new Exception("Expected '{' after '" + string.substring(0, i) + "'");
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                if ((c = string.charAt(++i)) == '}') {
                    throw new Exception("Empty patterns not allowed '" + string.substring(0, i + 1) + "'");
                }
                while (c != '}') {
                    stringBuffer2.append(c);
                    c = string.charAt(++i);
                }
                String string2 = this.getValue(stringBuffer2.toString(), properties);
                if (string2 == null) {
                    throw new Exception("Could not resolve variable: ${" + stringBuffer2.toString() + "}");
                }
                stringBuffer.append(string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Exception("Unexpected end of pattern: '" + string + "'");
        }
        return stringBuffer.toString();
    }

    protected String getValue(String string, Properties properties) {
        if (string.startsWith(OS)) {
            return System.getenv(string.substring(OS.length()));
        }
        if (string.startsWith(SEDONA)) {
            if (string.equals("sedona.env.version")) {
                return Env.version;
            }
            return Env.getProperty((String)string.substring(SEDONA.length()));
        }
        if (properties.containsKey(string)) {
            return properties.getProperty(string);
        }
        return this.vars.getProperty(string);
    }
}

