/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.util.ArrayList;

public class DocParser {
    private ArrayList nodes = new ArrayList();
    private int off = -1;
    private char[] text;

    public DocParser(String string) {
        this.text = string.toCharArray();
    }

    public DocNode[] parse() {
        block4: while (this.next()) {
            switch (this.curr()) {
                case '\n': {
                    continue block4;
                }
                case ' ': {
                    this.pre();
                    continue block4;
                }
            }
            this.para();
        }
        return this.nodes.toArray(new DocNode[this.nodes.size()]);
    }

    private void pre() {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            char c = this.curr();
            char c2 = this.peek();
            if (c == '\n' && (c2 == '\u0000' || c2 != ' ')) break;
            stringBuffer.append(c);
        } while (this.next());
        this.nodes.add(new PreNode(stringBuffer.toString()));
    }

    private void para() {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            char c = this.curr();
            char c2 = this.peek();
            if (c == '\n' && (c2 == '\u0000' || c2 == '\n' || c2 == ' ')) break;
            stringBuffer.append(c);
        } while (this.next());
        this.nodes.add(new ParaNode(stringBuffer.toString()));
    }

    private boolean next() {
        if (this.off + 1 >= this.text.length) {
            return false;
        }
        ++this.off;
        return true;
    }

    private char curr() {
        return this.text[this.off];
    }

    private char peek() {
        return this.off + 1 < this.text.length ? this.text[this.off + 1] : (char)'\u0000';
    }

    public static class PreNode
    extends DocNode {
        public PreNode(String string) {
            this.text = string;
        }

        @Override
        public int id() {
            return 2;
        }
    }

    public static class ParaNode
    extends DocNode {
        public ParaNode(String string) {
            this.text = string;
        }

        @Override
        public int id() {
            return 1;
        }
    }

    public static abstract class DocNode {
        public String text;
        public static final int PARA = 1;
        public static final int PRE = 2;

        public abstract int id();
    }
}

