/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import sedona.Env;
import sedona.util.FileUtil;
import sedona.util.Log;
import sedona.util.TextUtil;
import sedona.xml.XWriter;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.FieldDef;
import sedonac.ast.KitDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;
import sedonac.util.DocParser;

public class WriteDoc
extends CompilerStep {
    static TypeComparator typeCompare = new TypeComparator();
    static SlotComparator slotCompare = new SlotComparator();
    KitDef kit;
    File dir;
    TypeDef[] types;
    boolean www;

    public WriteDoc(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        if (!this.compiler.doc) {
            return;
        }
        File file = this.compiler.outDir;
        if (file == null) {
            file = new File(Env.home, "doc");
        }
        this.www = this.compiler.www;
        this.kit = this.compiler.ast;
        this.dir = new File(file, this.kit.name);
        if (!this.kit.doc) {
            return;
        }
        this.log.info("  WriteDoc [" + this.dir + "]");
        this.mkdir();
        this.filterTypes();
        this.index();
        this.generate();
    }

    private void mkdir() {
        try {
            FileUtil.delete((File)this.dir, (Log)this.log);
            FileUtil.mkdir((File)this.dir, (Log)this.log);
        }
        catch (IOException iOException) {
            throw this.err("Cannot make dir", new Location(this.dir), (Throwable)iOException);
        }
    }

    private void filterTypes() {
        ArrayList<TypeDef> arrayList = new ArrayList<TypeDef>();
        for (int i = 0; i < this.kit.types.length; ++i) {
            TypeDef typeDef = this.kit.types[i];
            if (!this.isDoc(typeDef)) continue;
            arrayList.add(typeDef);
        }
        this.types = arrayList.toArray(new TypeDef[arrayList.size()]);
        Arrays.sort(this.types, typeCompare);
    }

    private void header(XWriter xWriter, String string) {
        String string2 = this.www ? "../../index.html" : "../index.html";
        xWriter.w((Object)"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n");
        xWriter.w((Object)" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        xWriter.w((Object)"<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        xWriter.w((Object)"<head>\n");
        xWriter.w((Object)"  <title>").w((Object)string).w((Object)"</title>\n");
        xWriter.w((Object)"  <meta http-equiv='Content-type' content='text/html;charset=UTF-8' />\n");
        xWriter.w((Object)"  <link rel='stylesheet' type='text/css' href='../style.css'/>\n");
        xWriter.w((Object)"</head>\n");
        xWriter.w((Object)"<body>\n");
        xWriter.w((Object)"<p>\n");
        xWriter.w((Object)"  <a href='").w((Object)string2).w((Object)"'>\n");
        xWriter.w((Object)"    <img src='../logo.png' alt='Sedona'/>\n");
        xWriter.w((Object)"  </a>\n");
        xWriter.w((Object)"</p>\n");
        if (this.www) {
            xWriter.w((Object)"<ul class='tabs'>\n");
            xWriter.w((Object)"  <li><a href='").w((Object)string2).w((Object)"'>Home</a></li>\n");
            xWriter.w((Object)"  <li><a class='active' href='index.html'>Documentation</a></li>\n");
            xWriter.w((Object)"  <li><a href='../../community.html'>Community</a></li>\n");
            xWriter.w((Object)"  <li><a href='/download/'>Download</a></li>\n");
            xWriter.w((Object)"  <li><a href='http://groups.google.com/group/sedonadev'>Forum</a></li>\n");
            xWriter.w((Object)"</ul>\n");
        }
        this.nav(xWriter);
    }

    private void footer(XWriter xWriter) {
        this.nav(xWriter);
        xWriter.w((Object)"<div class='copyright'>Copyright &#169; 2009, Tridium, Inc.</div>\n");
        xWriter.w((Object)"</body>\n");
        xWriter.w((Object)"</html>\n");
    }

    private void nav(XWriter xWriter) {
        if (this.www) {
            this.wwwNav(xWriter);
        } else {
            this.normNav(xWriter);
        }
    }

    private void normNav(XWriter xWriter) {
        xWriter.w((Object)"<div class='nav'>\n");
        xWriter.w((Object)"  <a href='../index.html'>Index</a> |\n");
        xWriter.w((Object)"  <a href='../api.html'>Kits</a> |\n");
        xWriter.w((Object)"  <a href='index.html'>").w((Object)this.kit.name).w((Object)"</a>\n");
        xWriter.w((Object)"</div>\n");
    }

    private void wwwNav(XWriter xWriter) {
        xWriter.w((Object)"<div class='nav'>\n");
        xWriter.w((Object)"  <a href='../index.html'>Index</a> |\n");
        xWriter.w((Object)"  <a href='../api.html'>Kits</a> |\n");
        xWriter.w((Object)"  <a href='index.html'>").w((Object)this.kit.name).w((Object)"</a>\n");
        xWriter.w((Object)"</div>\n");
    }

    private void index() {
        File file = new File(this.dir, "index.html");
        try {
            XWriter xWriter = new XWriter(file);
            this.index(xWriter);
            xWriter.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write file", new Location(file), (Throwable)exception);
        }
    }

    private void index(XWriter xWriter) {
        this.header(xWriter, this.kit.name);
        xWriter.w((Object)"<h1 class='title'>").w((Object)this.kit.name).w((Object)"</h1>\n");
        xWriter.w((Object)"<ul>\n");
        for (int i = 0; i < this.types.length; ++i) {
            TypeDef typeDef = this.types[i];
            xWriter.w((Object)"  <li><a href='").w((Object)typeDef.name).w((Object)".html'>").w((Object)typeDef.name).w((Object)"</a></li>\n");
        }
        xWriter.w((Object)"</ul>\n");
        this.footer(xWriter);
    }

    private void generate() {
        for (int i = 0; i < this.types.length; ++i) {
            this.generate(this.types[i]);
        }
    }

    private void generate(TypeDef typeDef) {
        File file = new File(this.dir, typeDef.name + ".html");
        try {
            XWriter xWriter = new XWriter(file);
            this.generate(typeDef, xWriter);
            xWriter.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write file", new Location(file), (Throwable)exception);
        }
    }

    void generate(TypeDef typeDef, XWriter xWriter) {
        this.header(xWriter, typeDef.qname);
        xWriter.w((Object)"<h1 class='title'>").w((Object)typeDef.qname).w((Object)"</h1>\n");
        xWriter.w((Object)"<hr/>\n");
        xWriter.w((Object)"<pre class='inheritance'>");
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Type type = typeDef.base; type != null; type = type.base()) {
            arrayList.add(0, type);
        }
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (n > 0) {
                xWriter.w((Object)TextUtil.getSpaces((int)n));
            }
            this.typeLink((Type)arrayList.get(i), xWriter, false);
            xWriter.w((Object)"\n");
            n += 2;
        }
        if (n > 0) {
            xWriter.w((Object)TextUtil.getSpaces((int)n));
        }
        xWriter.w((Object)typeDef.qname).w((Object)"\n");
        xWriter.w((Object)"</pre>\n");
        this.typeModifiers(typeDef, xWriter, "em");
        xWriter.w((Object)(" class <b>" + typeDef.name() + "</b>  "));
        if (typeDef.facets() != null && !typeDef.facets().isEmpty()) {
            xWriter.safe(typeDef.facets().toString());
        }
        xWriter.w((Object)"<br>\n");
        xWriter.w((Object)"<hr/>\n");
        if (typeDef.doc != null) {
            this.writeDoc(typeDef.doc, xWriter);
        }
        xWriter.w((Object)"<hr/>\n");
        SlotDef[] slotDefArray = typeDef.slotDefs();
        Arrays.sort(slotDefArray, slotCompare);
        boolean bl = false;
        for (int i = 0; i < slotDefArray.length; ++i) {
            MethodDef methodDef;
            SlotDef slotDef = slotDefArray[i];
            if (!this.isDoc(slotDef)) continue;
            if (!bl) {
                xWriter.w((Object)"<dl>\n");
                bl = true;
            }
            String string = slotDef.name;
            if (slotDef.isMethod() && (methodDef = (MethodDef)slotDef).isInstanceInit()) {
                string = methodDef.parent.name();
            }
            xWriter.w((Object)"<dt>").w((Object)string).w((Object)"</dt>\n");
            xWriter.w((Object)"<dd>");
            xWriter.w((Object)"<p class='sig'><code>");
            this.slotDef(slotDef, xWriter);
            xWriter.w((Object)"</code></p>\n");
            if (slotDef.doc != null) {
                this.writeDoc(slotDef.doc, xWriter);
            }
            xWriter.w((Object)"</dd>\n");
        }
        if (bl) {
            xWriter.w((Object)"</dl>\n");
        }
        this.footer(xWriter);
    }

    void slotDef(SlotDef slotDef, XWriter xWriter) {
        if (slotDef.isField()) {
            FieldDef fieldDef = (FieldDef)slotDef;
            this.slotModifiers(slotDef, xWriter, "em");
            xWriter.w((Object)"<b>");
            this.typeLink(fieldDef.type(), xWriter);
            xWriter.w((Object)" ").w((Object)fieldDef.name());
            xWriter.w((Object)"</b>");
        } else {
            MethodDef methodDef = (MethodDef)slotDef;
            this.slotModifiers(slotDef, xWriter, "em");
            xWriter.w((Object)"<b>");
            this.typeLink(methodDef.returnType(), xWriter);
            String string = methodDef.name();
            if (methodDef.isInstanceInit()) {
                string = methodDef.parent.name();
            }
            xWriter.w((Object)" ").w((Object)string).w((Object)"(");
            for (int i = 0; i < methodDef.params.length; ++i) {
                if (i > 0) {
                    xWriter.w((Object)", ");
                }
                this.typeLink(methodDef.params[i].type, xWriter);
                xWriter.w((Object)" ").w((Object)methodDef.params[i].name);
            }
            xWriter.w((Object)")");
            xWriter.w((Object)"</b>");
        }
        if (slotDef.facets() != null && !slotDef.facets().isEmpty()) {
            xWriter.safe(" " + slotDef.facets().toString());
        }
        xWriter.w((Object)"\n\n");
    }

    void typeModifiers(TypeDef typeDef, XWriter xWriter, String string) {
        if (string != null && string.length() > 0) {
            xWriter.w((Object)("<" + string + ">"));
        }
        if (typeDef.isPublic()) {
            xWriter.w((Object)"public ");
        }
        if (typeDef.isInternal()) {
            xWriter.w((Object)"internal ");
        }
        if (typeDef.isAbstract()) {
            xWriter.w((Object)"abstract ");
        }
        if (typeDef.isConst()) {
            xWriter.w((Object)"const ");
        }
        if (typeDef.isFinal()) {
            xWriter.w((Object)"final ");
        }
        if (string != null && string.length() > 0) {
            xWriter.w((Object)("</" + string + ">"));
        }
    }

    void slotModifiers(SlotDef slotDef, XWriter xWriter, String string) {
        if (string != null && string.length() > 0) {
            xWriter.w((Object)("<" + string + ">"));
        }
        if (slotDef.isPublic()) {
            xWriter.w((Object)"<em>public</em> ");
        }
        if (slotDef.isProtected()) {
            xWriter.w((Object)"<em>protected</em> ");
        }
        if (slotDef.isPrivate()) {
            xWriter.w((Object)"<em>private</em> ");
        }
        if (slotDef.isInternal()) {
            xWriter.w((Object)"<em>internal</em> ");
        }
        if (slotDef.isStatic()) {
            xWriter.w((Object)"<em>static</em> ");
        }
        if (slotDef.isAbstract()) {
            xWriter.w((Object)"<em>abstract</em> ");
        } else if (slotDef.isAction()) {
            xWriter.w((Object)"<em>action</em> ");
        } else if (slotDef.isVirtual()) {
            xWriter.w((Object)"<em>virtual</em> ");
        }
        if (slotDef.isNative()) {
            xWriter.w((Object)"<em>native</em> ");
        }
        if (slotDef.isOverride()) {
            xWriter.w((Object)"<em>override</em> ");
        }
        if (slotDef.isConst()) {
            xWriter.w((Object)"<em>const</em> ");
        }
        if (slotDef.isDefine()) {
            xWriter.w((Object)"<em>define</em> ");
        }
        if (slotDef.isInline()) {
            xWriter.w((Object)"<em>inline</em> ");
        }
        if (slotDef.isProperty()) {
            xWriter.w((Object)"<em>property</em> ");
        }
        if (string != null && string.length() > 0) {
            xWriter.w((Object)("</" + string + ">"));
        }
    }

    boolean isDoc(TypeDef typeDef) {
        if (!typeDef.isPublic()) {
            return false;
        }
        return !TypeUtil.isTestOnly(typeDef);
    }

    boolean isDoc(SlotDef slotDef) {
        if (slotDef.isPrivate()) {
            return false;
        }
        if (slotDef.isInternal()) {
            return false;
        }
        return !slotDef.synthetic;
    }

    void writeDoc(String string, XWriter xWriter) {
        DocParser.DocNode[] docNodeArray = new DocParser(string).parse();
        block4: for (int i = 0; i < docNodeArray.length; ++i) {
            int n = docNodeArray[i].id();
            String string2 = docNodeArray[i].text;
            switch (n) {
                case 1: {
                    xWriter.w((Object)"<p>").safe(string2).w((Object)"</p>\n");
                    continue block4;
                }
                case 2: {
                    xWriter.w((Object)"<pre class='doc'>").safe(string2).w((Object)"</pre>\n");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unknown DocNode id: " + n);
                }
            }
        }
    }

    void typeLink(Type type, XWriter xWriter) {
        this.typeLink(type, xWriter, true);
    }

    void typeLink(Type type, XWriter xWriter, boolean bl) {
        if (type.isPrimitive()) {
            xWriter.w((Object)type);
        } else if (type.isArray()) {
            this.typeLink(type.arrayOf(), xWriter, bl);
            xWriter.w((Object)"[]");
        } else if (!type.isPublic()) {
            this.typeLink(type.base(), xWriter, bl);
        } else {
            String string = bl ? type.name() : type.qname();
            String string2 = "../" + type.kit().name() + "/" + type.name() + ".html";
            xWriter.w((Object)"<a href='").w((Object)string2).w((Object)"'>").w((Object)string).w((Object)"</a>");
        }
    }

    static class SlotComparator
    implements Comparator {
        SlotComparator() {
        }

        public int compare(Object object, Object object2) {
            SlotDef slotDef = (SlotDef)object;
            SlotDef slotDef2 = (SlotDef)object2;
            return slotDef.name.compareTo(slotDef2.name);
        }
    }

    static class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        public int compare(Object object, Object object2) {
            TypeDef typeDef = (TypeDef)object;
            TypeDef typeDef2 = (TypeDef)object2;
            return typeDef.name.compareTo(typeDef2.name);
        }
    }
}

