/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.zip.CRC32;
import sedona.Env;
import sedona.platform.NativeManifest;
import sedona.platform.PlatformManifest;
import sedona.xml.XContent;
import sedona.xml.XWriter;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.namespace.NativeId;
import sedonac.namespace.Slot;
import sedonac.platform.PlatformDef;
import sedonac.util.VarResolver;

public class StagePlatform
extends CompilerStep {
    PlatformManifest manifest;

    public StagePlatform(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.info("  StagePlatform");
        this.makePlatformManifest(this.compiler.platform);
        this.writeCHeaders();
        this.writeManifest();
        this.quitIfErrors();
    }

    private void makePlatformManifest(PlatformDef platformDef) {
        int n;
        this.manifest = new PlatformManifest();
        this.manifest.id = platformDef.idPattern;
        this.manifest.vendor = platformDef.vendor;
        this.manifest.endian = platformDef.endian;
        this.manifest.blockSize = platformDef.blockSize;
        this.manifest.refSize = platformDef.refSize;
        this.manifest.armDouble = platformDef.armDouble;
        this.manifest.debug = platformDef.debug;
        this.manifest.test = platformDef.test;
        this.manifest.nativeKits = platformDef.nativeKits;
        Slot[] slotArray = this.findNativeMethods();
        this.manifest.nativeMethods = new NativeManifest[slotArray.length];
        for (n = 0; n < slotArray.length; ++n) {
            this.manifest.nativeMethods[n] = this.toNativeManifest(this.manifest, slotArray[n]);
        }
        Arrays.sort(this.manifest.nativeMethods, new NativeComparator());
        for (n = 0; n < platformDef.manifestIncludes.length; ++n) {
            this.manifest.manifestIncludes.addContent((XContent)platformDef.manifestIncludes[n]);
        }
        this.resolvePlatformId();
    }

    private Slot[] findNativeMethods() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (int i = 0; i < this.compiler.kits.length; ++i) {
            IrKit irKit = this.compiler.kits[i];
            if (!irKit.manifest.hasNatives) continue;
            for (int j = 0; j < irKit.types.length; ++j) {
                Slot[] slotArray = irKit.types[j].slots();
                for (int k = 0; k < slotArray.length; ++k) {
                    if (!slotArray[k].isNative()) continue;
                    arrayList.add(slotArray[k]);
                }
            }
        }
        return arrayList.toArray(new Slot[arrayList.size()]);
    }

    private NativeManifest toNativeManifest(PlatformManifest platformManifest, Slot slot) {
        IrMethod irMethod = (IrMethod)slot;
        return new NativeManifest(platformManifest, irMethod.qname(), irMethod.nativeId.string);
    }

    private void resolvePlatformId() {
        if (this.manifest.id == null) {
            return;
        }
        Properties properties = new Properties();
        properties.put("stage.nativeChecksum", this.calcNativeCksum());
        try {
            this.manifest.id = new VarResolver(properties).resolve(this.manifest.id);
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage(), "id attribute");
        }
    }

    private String calcNativeCksum() {
        CRC32 cRC32 = new CRC32();
        for (int i = 0; i < this.manifest.nativeMethods.length; ++i) {
            NativeManifest nativeManifest = this.manifest.nativeMethods[i];
            cRC32.update(nativeManifest.qname.getBytes());
            cRC32.update(nativeManifest.nativeId.getBytes());
        }
        return Integer.toHexString((int)cRC32.getValue());
    }

    private void writeCHeaders() {
        if (this.manifest.id == null) {
            return;
        }
        File file = new File(this.compiler.outDir, "sedonaPlatform.h");
        this.log.debug("    Writing [ " + file + " ]");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("//");
            printWriter.println("// Generated by sedonac " + Env.version);
            printWriter.println("// " + Env.timestamp());
            printWriter.println("//");
            printWriter.println();
            printWriter.println("#ifndef SEDONAC_SEDONA_PLATFORM_H");
            printWriter.println("#define SEDONAC_SEDONA_PLATFORM_H");
            printWriter.println();
            printWriter.println("#define PLATFORM_ID \"" + this.manifest.id + "\"");
            printWriter.println();
            printWriter.println("#endif");
            printWriter.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write sedonaPlatform.h", new Location(file), (Throwable)exception);
        }
    }

    private void writeManifest() {
        File file = new File(this.compiler.outDir, ".par");
        File file2 = new File(file, "platformManifest.xml");
        this.log.debug("    Writing [ " + file2 + " ]");
        try {
            XWriter xWriter = new XWriter(file2);
            this.manifest.encodeXml(xWriter);
            xWriter.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write platformManifest.xml", new Location(file2), (Throwable)exception);
        }
    }

    private class NativeComparator
    implements Comparator {
        private NativeComparator() {
        }

        public int compare(Object object, Object object2) {
            NativeId nativeId;
            NativeId nativeId2 = NativeId.parse(null, ((NativeManifest)object).nativeId);
            if (nativeId2.equals(nativeId = NativeId.parse(null, ((NativeManifest)object2).nativeId))) {
                throw new IllegalStateException("Duplicate nativeIds: " + nativeId2 + " " + nativeId);
            }
            int n = nativeId2.kitId - nativeId.kitId;
            return n == 0 ? nativeId2.methodId - nativeId.methodId : n;
        }
    }
}

