/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import sedona.Depend;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.namespace.Namespace;

public class OrderStaticInits
extends CompilerStep {
    public OrderStaticInits(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.debug("  OrderStaticInits");
        Arrays.sort(this.compiler.flat.staticInits, new StaticInitComparator(this.graphDependencies()));
        this.quitIfErrors();
        if (this.log.isDebug()) {
            for (int i = 0; i < this.compiler.flat.staticInits.length; ++i) {
                this.log.debug("    " + this.compiler.flat.staticInits[i]);
            }
        }
    }

    private HashMap graphDependencies() {
        HashMap<String, IrKit> hashMap = new HashMap<String, IrKit>(this.compiler.kits.length);
        for (int i = 0; i < this.compiler.kits.length; ++i) {
            hashMap.put(this.compiler.kits[i].name(), this.compiler.kits[i]);
        }
        HashMap<String, HashSet> hashMap2 = new HashMap<String, HashSet>(this.compiler.kits.length);
        for (int i = 0; i < this.compiler.kits.length; ++i) {
            hashMap2.put(this.compiler.kits[i].name(), this.graphDependencies(hashMap, hashMap2, this.compiler.kits[i], this.compiler.kits[i].name()));
        }
        return hashMap2;
    }

    private HashSet graphDependencies(HashMap hashMap, HashMap hashMap2, IrKit irKit, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < irKit.manifest.depends.length; ++i) {
            Depend depend = irKit.manifest.depends[i];
            HashSet hashSet2 = (HashSet)hashMap2.get(depend.name());
            if (hashSet2 == null) {
                IrKit irKit2 = (IrKit)hashMap.get(depend.name());
                if (irKit2 == null) {
                    this.err("Dependency on '" + depend.name() + "' required through '" + string + "'", this.compiler.input);
                    continue;
                }
                hashSet2 = this.graphDependencies(hashMap, hashMap2, (IrKit)hashMap.get(depend.name()), string + " -> " + depend.name());
                hashMap2.put(depend.name(), hashSet2);
            }
            hashSet.add(depend.name());
            hashSet.addAll(hashSet2);
        }
        return hashSet;
    }

    class StaticInitComparator
    implements Comparator {
        HashMap dependencies;
        Namespace ns;

        public StaticInitComparator(HashMap hashMap) {
            this.dependencies = hashMap;
            this.ns = OrderStaticInits.this.ns;
        }

        public int compare(Object object, Object object2) {
            IrMethod irMethod = (IrMethod)object;
            IrMethod irMethod2 = (IrMethod)object2;
            if (irMethod.parent.is(this.ns.sysType)) {
                return -1;
            }
            if (irMethod2.parent.is(this.ns.sysType)) {
                return 1;
            }
            IrKit irKit = irMethod.parent.kit;
            IrKit irKit2 = irMethod2.parent.kit;
            if (irKit.name().equals(irKit2.name())) {
                return 0;
            }
            HashSet hashSet = (HashSet)this.dependencies.get(irKit.name());
            HashSet hashSet2 = (HashSet)this.dependencies.get(irKit2.name());
            if (hashSet.contains(irKit2.name())) {
                return 1;
            }
            if (hashSet2.contains(irKit.name())) {
                return -1;
            }
            return 0;
        }
    }
}

