/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

import java.util.ArrayList;
import sedonac.jasm.AttributeInfo;
import sedonac.jasm.Buffer;
import sedonac.jasm.ConstantPool;
import sedonac.jasm.FieldInfo;
import sedonac.jasm.MethodInfo;

public class Assembler {
    public final int thisClass;
    public final int superClass;
    public final int[] interfaces;
    public final int accessFlags;
    public final ConstantPool cp = new ConstantPool();
    private ArrayList fields = new ArrayList();
    private ArrayList methods = new ArrayList();
    private ArrayList attributes = new ArrayList();

    public Assembler(String string, String string2, int n, String[] stringArray) {
        this.thisClass = this.cp.cls(string);
        this.superClass = string2 == null ? this.cp.cls("java/lang/Object") : this.cp.cls(string2);
        this.accessFlags = n;
        this.interfaces = new int[stringArray == null ? 0 : stringArray.length];
        for (int i = 0; i < this.interfaces.length; ++i) {
            this.interfaces[i] = this.cp.cls(stringArray[i]);
        }
    }

    public FieldInfo addField(FieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
        return fieldInfo;
    }

    public MethodInfo addMethod(MethodInfo methodInfo) {
        this.methods.add(methodInfo);
        return methodInfo;
    }

    public AttributeInfo addAttribute(AttributeInfo attributeInfo) {
        this.attributes.add(attributeInfo);
        return attributeInfo;
    }

    public Buffer compile() {
        int n;
        Buffer buffer = new Buffer();
        buffer.u4(-889275714);
        buffer.u2(3);
        buffer.u2(45);
        buffer.u2(this.cp.count + 1);
        buffer.append(this.cp.buf);
        buffer.u2(this.accessFlags);
        buffer.u2(this.thisClass);
        buffer.u2(this.superClass);
        buffer.u2(this.interfaces.length);
        for (n = 0; n < this.interfaces.length; ++n) {
            buffer.u2(this.interfaces[n]);
        }
        buffer.u2(this.fields.size());
        for (n = 0; n < this.fields.size(); ++n) {
            ((FieldInfo)this.fields.get(n)).compile(buffer);
        }
        buffer.u2(this.methods.size());
        for (n = 0; n < this.methods.size(); ++n) {
            ((MethodInfo)this.methods.get(n)).compile(buffer);
        }
        buffer.u2(this.attributes.size());
        for (n = 0; n < this.attributes.size(); ++n) {
            ((AttributeInfo)this.attributes.get(n)).compile(buffer);
        }
        return buffer;
    }
}

