/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ir;

import sedona.Facets;
import sedonac.ir.IrAddressable;
import sedonac.ir.IrType;
import sedonac.ir.IrWriter;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public abstract class IrSlot
implements Slot {
    public final IrType parent;
    public final int flags;
    public final int rtFlags;
    public final String name;
    public final String qname;
    public final Facets facets;
    public final IrAddressable reflect;
    public int id = -1;

    public IrSlot(IrType irType, int n, String string, Facets facets) {
        this.parent = irType;
        this.flags = n;
        this.name = string;
        this.qname = irType.qname + "." + string;
        this.rtFlags = TypeUtil.rtFlags(this, facets);
        this.facets = facets.ro();
        this.reflect = new IrAddressable.Impl(this.qname + " (reflect)");
    }

    @Override
    public Type parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String qname() {
        return this.qname;
    }

    public String toString() {
        return this.qname;
    }

    @Override
    public Facets facets() {
        return this.facets;
    }

    @Override
    public boolean isInherited(Type type) {
        return TypeUtil.isInherited(this, type);
    }

    @Override
    public boolean isReflective() {
        return this.isAction() || this.isProperty();
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public boolean isAbstract() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isAction() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isConst() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isDefine() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isInline() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isNative() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isOverride() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isProperty() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.flags & 0x1000) != 0;
    }

    @Override
    public boolean isVirtual() {
        return (this.flags & 0x2000) != 0;
    }

    @Override
    public int rtFlags() {
        return this.rtFlags;
    }

    @Override
    public boolean isRtAction() {
        return (this.rtFlags & 1) != 0;
    }

    @Override
    public boolean isRtConfig() {
        return (this.rtFlags & 2) != 0;
    }

    public void dump() {
        IrWriter irWriter = new IrWriter(System.out);
        irWriter.writeSlot(this);
        irWriter.flush();
    }
}

