/*
 * Decompiled with CFR 0.152.
 */
package sedonac.gen;

import java.util.Arrays;
import java.util.HashMap;
import sedona.Buf;
import sedonac.CompilerSupport;
import sedonac.ast.Expr;
import sedonac.gen.ImageGen;
import sedonac.ir.IrAddressable;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

public class ConstPool
extends CompilerSupport {
    ImageGen parent;
    HashMap ints = new HashMap();
    HashMap longs = new HashMap();
    HashMap floats = new HashMap();
    HashMap doubles = new HashMap();
    HashMap strings = new HashMap();
    HashMap bufs = new HashMap();
    HashMap arrays = new HashMap();
    HashMap qnameTypes = new HashMap();
    HashMap qnameSlots = new HashMap();

    public ConstPool(ImageGen imageGen) {
        super(imageGen.compiler);
        this.parent = imageGen;
    }

    IrInt toInt(Integer n) {
        IrInt irInt = (IrInt)this.ints.get(n);
        if (irInt == null) {
            irInt = new IrInt(n);
            this.ints.put(n, irInt);
        }
        return irInt;
    }

    void ints() {
        Buf buf = this.parent.code;
        buf.align(4);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 4 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.ints.keySet().toArray(new Integer[this.ints.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            IrInt irInt = (IrInt)this.ints.get(objectArray[i]);
            irInt.blockIndex = this.blockIndex();
            int n = irInt.val;
            buf.i4(n);
            this.blockAlign();
        }
    }

    IrLong toLong(Long l) {
        IrLong irLong = (IrLong)this.longs.get(l);
        if (irLong == null) {
            irLong = new IrLong(l);
            this.longs.put(l, irLong);
        }
        return irLong;
    }

    void longs() {
        Buf buf = this.parent.code;
        buf.align(8);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 8 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.longs.keySet().toArray(new Long[this.longs.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            IrLong irLong = (IrLong)this.longs.get(objectArray[i]);
            irLong.blockIndex = this.blockIndex();
            long l = irLong.val;
            buf.i8(l);
            this.blockAlign();
        }
    }

    IrFloat toFloat(Float f) {
        IrFloat irFloat = (IrFloat)this.floats.get(f);
        if (irFloat == null) {
            irFloat = new IrFloat(f);
            this.floats.put(f, irFloat);
        }
        return irFloat;
    }

    void floats() {
        Buf buf = this.parent.code;
        buf.align(4);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 4 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.floats.keySet().toArray(new Float[this.floats.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            IrFloat irFloat = (IrFloat)this.floats.get(objectArray[i]);
            irFloat.blockIndex = this.blockIndex();
            float f = irFloat.val.floatValue();
            buf.f4(f);
            this.blockAlign();
        }
    }

    IrDouble toDouble(Double d) {
        IrDouble irDouble = (IrDouble)this.doubles.get(d);
        if (irDouble == null) {
            irDouble = new IrDouble(d);
            this.doubles.put(d, irDouble);
        }
        return irDouble;
    }

    void doubles() {
        Buf buf = this.parent.code;
        buf.align(8);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 8 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.doubles.keySet().toArray(new Double[this.doubles.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            IrDouble irDouble = (IrDouble)this.doubles.get(objectArray[i]);
            irDouble.blockIndex = this.blockIndex();
            double d = irDouble.val;
            if (this.parent.image.armDouble) {
                long l = Double.doubleToLongBits(d);
                buf.i4((int)(l >> 32 & 0xFFFFFFFFL));
                buf.i4((int)(l & 0xFFFFFFFFL));
            } else {
                buf.f8(d);
            }
            this.blockAlign();
        }
    }

    IrStr string(String string) {
        IrStr irStr = (IrStr)this.strings.get(string);
        if (irStr == null) {
            irStr = new IrStr(string);
            this.strings.put(string, irStr);
        }
        return irStr;
    }

    void strings() {
        Buf buf = this.parent.code;
        Object[] objectArray = this.strings.keySet().toArray(new String[this.strings.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            IrStr irStr = (IrStr)this.strings.get(objectArray[i]);
            irStr.blockIndex = this.blockIndex();
            this.writeStrLiteral(buf, irStr.val);
        }
    }

    void writeStrLiteral(Buf buf, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                throw this.err("Invalid string literal: " + string);
            }
            buf.u1((int)c);
        }
        buf.u1(0);
        this.blockAlign();
    }

    IrBuf buf(Buf buf) {
        IrBuf irBuf = (IrBuf)this.bufs.get(buf);
        if (irBuf == null) {
            irBuf = new IrBuf(buf);
            this.bufs.put(buf, irBuf);
        }
        return irBuf;
    }

    void bufs() {
        Buf buf = this.parent.code;
        buf.align(2);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 2 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.bufs.keySet().toArray(new Buf[this.bufs.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            IrBuf irBuf = (IrBuf)this.bufs.get(objectArray[i]);
            irBuf.blockIndex = this.blockIndex();
            Buf buf2 = irBuf.val;
            buf.u2(buf2.size);
            buf.u2(buf2.size);
            buf.append(buf2);
            buf.align(2);
            this.blockAlign();
        }
    }

    IrArray array(Expr.Literal literal) {
        Object[] objectArray;
        Type type = literal.type.arrayOf();
        IrArray irArray = new IrArray(type, objectArray = literal.asArray());
        IrArray irArray2 = (IrArray)this.arrays.get(irArray);
        if (irArray2 == null) {
            irArray2 = irArray;
            this.arrays.put(irArray, irArray);
        }
        return irArray2;
    }

    void arrays() {
        Buf buf = this.parent.code;
        IrArray[] irArrayArray = this.arrays.values().toArray(new IrArray[this.arrays.size()]);
        block8: for (int i = 0; i < irArrayArray.length; ++i) {
            IrArray irArray = irArrayArray[i];
            Type type = irArray.of;
            Object[] objectArray = irArray.array;
            this.blockAlign();
            if (type.isStr()) {
                int n;
                int[] nArray = new int[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    nArray[n] = this.blockIndex();
                    this.writeStrLiteral(buf, (String)objectArray[n]);
                }
                buf.align(2);
                irArray.blockIndex = this.blockIndex();
                for (n = 0; n < objectArray.length; ++n) {
                    if (this.parent.image.blockIndexSize == 4) {
                        buf.u4(nArray[n]);
                        continue;
                    }
                    buf.u2(nArray[n]);
                }
                continue;
            }
            switch (type.id()) {
                case 2: {
                    irArray.blockIndex = this.blockIndex();
                    for (int j = 0; j < objectArray.length; ++j) {
                        buf.u1(((Integer)objectArray[j]).intValue());
                    }
                    continue block8;
                }
                case 3: {
                    buf.align(2);
                    irArray.blockIndex = this.blockIndex();
                    for (int j = 0; j < objectArray.length; ++j) {
                        buf.u2(((Integer)objectArray[j]).intValue());
                    }
                    continue block8;
                }
                case 4: {
                    buf.align(4);
                    irArray.blockIndex = this.blockIndex();
                    for (int j = 0; j < objectArray.length; ++j) {
                        buf.i4(((Integer)objectArray[j]).intValue());
                    }
                    continue block8;
                }
                case 5: {
                    buf.align(8);
                    irArray.blockIndex = this.blockIndex();
                    for (int j = 0; j < objectArray.length; ++j) {
                        buf.i8(((Long)objectArray[j]).longValue());
                    }
                    continue block8;
                }
                case 6: {
                    buf.align(4);
                    irArray.blockIndex = this.blockIndex();
                    for (int j = 0; j < objectArray.length; ++j) {
                        buf.f4(((Float)objectArray[j]).floatValue());
                    }
                    continue block8;
                }
                case 7: {
                    buf.align(8);
                    irArray.blockIndex = this.blockIndex();
                    if (this.parent.image.armDouble) {
                        for (int j = 0; j < objectArray.length; ++j) {
                            double d = (Double)objectArray[j];
                            long l = Double.doubleToLongBits(d);
                            buf.i4((int)(l >> 32 & 0xFFFFFFFFL));
                            buf.i4((int)(l & 0xFFFFFFFFL));
                        }
                        continue block8;
                    }
                    for (int j = 0; j < objectArray.length; ++j) {
                        buf.f8(((Double)objectArray[j]).doubleValue());
                    }
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("array literal: " + type);
                }
            }
        }
        this.blockAlign();
    }

    IrQnameType qnameType(Type type) {
        String string = type.qname();
        IrQnameType irQnameType = (IrQnameType)this.qnameTypes.get(string);
        if (irQnameType == null) {
            irQnameType = new IrQnameType();
            irQnameType.kitName = this.string(type.kit().name());
            irQnameType.typeName = this.string(type.name());
            this.qnameTypes.put(string, irQnameType);
        }
        return irQnameType;
    }

    void qnameTypes() {
        Buf buf = this.parent.code;
        buf.align(this.parent.image.blockIndexSize);
        for (IrQnameType irQnameType : this.qnameTypes.values()) {
            irQnameType.blockIndex = this.blockIndex();
            if (irQnameType.kitName.blockIndex <= 0) {
                throw new IllegalStateException();
            }
            if (this.parent.image.blockIndexSize == 4) {
                buf.u4(irQnameType.kitName.blockIndex);
                buf.u4(irQnameType.typeName.blockIndex);
            } else {
                buf.u2(irQnameType.kitName.blockIndex);
                buf.u2(irQnameType.typeName.blockIndex);
            }
            this.blockAlign();
        }
    }

    IrQnameSlot qnameSlot(Slot slot) {
        String string = slot.qname();
        IrQnameSlot irQnameSlot = (IrQnameSlot)this.qnameSlots.get(string);
        if (irQnameSlot == null) {
            irQnameSlot = new IrQnameSlot();
            irQnameSlot.qnameType = this.qnameType(slot.parent());
            irQnameSlot.slotName = this.string(slot.name());
            this.qnameSlots.put(string, irQnameSlot);
        }
        return irQnameSlot;
    }

    void qnameSlots() {
        Buf buf = this.parent.code;
        buf.align(this.parent.image.blockIndexSize);
        for (IrQnameSlot irQnameSlot : this.qnameSlots.values()) {
            irQnameSlot.blockIndex = this.blockIndex();
            if (irQnameSlot.qnameType.blockIndex <= 0 || irQnameSlot.slotName.blockIndex <= 0) {
                throw new IllegalStateException();
            }
            if (this.parent.image.blockIndexSize == 4) {
                buf.u4(irQnameSlot.qnameType.blockIndex);
                buf.u4(irQnameSlot.slotName.blockIndex);
            } else {
                buf.u2(irQnameSlot.qnameType.blockIndex);
                buf.u2(irQnameSlot.slotName.blockIndex);
            }
            this.blockAlign();
        }
    }

    public int blockIndex() {
        return this.parent.blockIndex();
    }

    public void blockAlign() {
        this.parent.blockAlign();
    }

    static class IrQnameSlot
    implements IrAddressable {
        int blockIndex;
        IrQnameType qnameType;
        IrStr slotName;

        IrQnameSlot() {
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrQnameType
    implements IrAddressable {
        int blockIndex;
        IrStr kitName;
        IrStr typeName;

        IrQnameType() {
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrArray
    implements IrAddressable {
        final Type of;
        final Object[] array;
        final int hash;
        int blockIndex;

        IrArray(Type type, Object[] objectArray) {
            this.of = type;
            this.array = objectArray;
            this.hash = type.name().hashCode() ^ objectArray.length;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            IrArray irArray = (IrArray)object;
            if (!((Object)this.of).equals(irArray.of)) {
                return false;
            }
            if (this.array.length != irArray.array.length) {
                return false;
            }
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i].equals(irArray.array[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrBuf
    implements IrAddressable {
        final Buf val;
        int blockIndex;

        IrBuf(Buf buf) {
            this.val = buf;
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrStr
    implements IrAddressable {
        final String val;
        int blockIndex;

        IrStr(String string) {
            this.val = string;
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrDouble
    implements IrAddressable {
        final Double val;
        int blockIndex;

        IrDouble(Double d) {
            this.val = d;
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrFloat
    implements IrAddressable {
        final Float val;
        int blockIndex;

        IrFloat(Float f) {
            this.val = f;
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrLong
    implements IrAddressable {
        final Long val;
        int blockIndex;

        IrLong(Long l) {
            this.val = l;
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }

    static class IrInt
    implements IrAddressable {
        final Integer val;
        int blockIndex;

        IrInt(Integer n) {
            this.val = n;
        }

        @Override
        public int getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        @Override
        public boolean alignBlockIndex() {
            return true;
        }
    }
}

