/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import sedona.Facets;
import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.AstVisitor;
import sedonac.ast.Expr;
import sedonac.ast.FacetDef;

public abstract class FacetsNode
extends AstNode {
    public FacetDef[] facetDefs;
    private Facets resolvedFacets;

    public FacetsNode(Location location, FacetDef[] facetDefArray) {
        super(location);
        this.facetDefs = facetDefArray;
    }

    public Facets facets() {
        if (this.resolvedFacets == null) {
            throw new IllegalStateException("Facets haven't been resolved yet");
        }
        return this.resolvedFacets;
    }

    public void setResolvedFacets(Facets facets) {
        this.resolvedFacets = facets;
    }

    public void setFacet(String string, int n) {
        this.facets();
        if (this.resolvedFacets.isRO()) {
            this.resolvedFacets = new Facets();
        }
        this.resolvedFacets.seti(string, n);
    }

    public void addFacetDef(String string, Expr expr) {
        FacetDef[] facetDefArray = new FacetDef[this.facetDefs.length + 1];
        System.arraycopy(this.facetDefs, 0, facetDefArray, 0, this.facetDefs.length);
        facetDefArray[this.facetDefs.length] = new FacetDef(this.loc, string, expr);
        this.facetDefs = facetDefArray;
    }

    public void walkFacets(AstVisitor astVisitor, int n) {
        for (int i = 0; i < this.facetDefs.length; ++i) {
            this.facetDefs[i].walk(astVisitor, n);
        }
    }
}

