/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.AstNode;
import sedonac.ast.Expr;
import sedonac.ast.FacetsNode;
import sedonac.ast.FieldDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Type;

public class UnusedCodeAnalysis
extends CompilerStep {
    private HashMap refs;

    public UnusedCodeAnalysis(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.refs = new HashMap();
        this.walkAst(3);
        this.logUnused();
        this.refs = null;
    }

    @Override
    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        if (typeDef.isInternal() && !this.refs.containsKey(typeDef)) {
            this.refs.put(typeDef, null);
        }
    }

    @Override
    public void enterMethod(MethodDef methodDef) {
        super.enterMethod(methodDef);
        if ((methodDef.isInternal() || methodDef.isPrivate()) && !this.refs.containsKey(methodDef)) {
            this.refs.put(methodDef, null);
        }
        if (methodDef.qname().equals("sys::Sys.malloc") || methodDef.qname().equals("sys::Sys.free")) {
            this.refs.put(methodDef, methodDef);
        }
    }

    @Override
    public void enterField(FieldDef fieldDef) {
        super.enterField(fieldDef);
        if ((fieldDef.isInternal() || fieldDef.isPrivate()) && !this.refs.containsKey(fieldDef)) {
            this.refs.put(fieldDef, null);
        }
        this.markReferenced(fieldDef.type);
    }

    @Override
    public Expr expr(Expr expr) {
        switch (expr.id) {
            case 70: {
                this.markReferenced(expr.type);
                break;
            }
            case 65: {
                this.markReferenced(((Expr.Call)expr).method);
                break;
            }
            case 63: {
                this.markReferenced(((Expr.Field)expr).field);
            }
        }
        return super.expr(expr);
    }

    private void markReferenced(Type type) {
        if (type == null || !type.isInternal() || !(type instanceof TypeDef)) {
            return;
        }
        this.refs.put(type, type);
    }

    private void markReferenced(Method method) {
        if (method == null || method.isPublic() || method.isProtected() || !(method instanceof MethodDef)) {
            return;
        }
        this.refs.put(method, method);
    }

    private void markReferenced(Field field) {
        if (field == null || field.isPublic() || field.isProtected() || !(field instanceof FieldDef)) {
            return;
        }
        if (this.curMethod.isInstanceInit()) {
            return;
        }
        this.refs.put(field, field);
    }

    private void logUnused() {
        AstNode[] astNodeArray = this.refs.keySet().toArray(new AstNode[this.refs.size()]);
        Arrays.sort(astNodeArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((AstNode)object).loc.compareTo(((AstNode)object2).loc);
            }
        });
        for (int i = 0; i < astNodeArray.length; ++i) {
            FacetsNode facetsNode;
            AstNode astNode = astNodeArray[i];
            if (this.refs.get(astNode) != null) continue;
            if (astNode instanceof TypeDef) {
                facetsNode = (TypeDef)astNode;
                this.warn("internal class '" + ((TypeDef)facetsNode).qname() + "' is not used", ((TypeDef)facetsNode).loc);
                continue;
            }
            if (!(astNode instanceof MethodDef)) continue;
            facetsNode = (MethodDef)astNode;
            String string = ((SlotDef)facetsNode).isInternal() ? "internal" : "private";
            this.warn(string + " method '" + ((SlotDef)facetsNode).qname() + "' is not used", ((MethodDef)facetsNode).loc);
        }
    }
}

