/*
 * Decompiled with CFR 0.152.
 */
package sedonac;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import sedona.Env;
import sedona.util.Version;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.test.Test;

public class Main {
    public static void usage() {
        Main.println("usage:");
        Main.println("  sedonac [options] <input file>");
        Main.println("inputs:");
        Main.println("  dir          directory containing kit.xml file");
        Main.println("  kit.xml      compile Sedona source files into kit file");
        Main.println("  scode.xml    compile Sedona kits into a scode image");
        Main.println("  *.sax        convert sax to sab");
        Main.println("  *.sab        convert sab to sax");
        Main.println("options:");
        Main.println("  -doc         generate HTML Sedona docs for kit");
        Main.println("  -outDir      output directory");
        Main.println("  -v           verbose logging");
        Main.println("  -ver         print version info and exit");
        Main.println("  -? -help     print this usage synopsis");
        Main.println("  -test        run test suite");
        Main.println("  -layout      dump field layout (when compiling image)");
        Main.println("  -kitVersion  force output kit to have specified version");
        Main.println("  -noOptimize  skip const folding and optimization steps");
        Main.println("  -noChecksum  exclude checksums from sax if input is sab file");
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public static int doMain(String[] stringArray) {
        int n;
        if (!Env.checkJavaVersion()) {
            return 1;
        }
        if (stringArray.length == 0) {
            Main.usage();
            return 1;
        }
        if (stringArray[0].startsWith("sedona.") || stringArray[0].startsWith("sedonac.")) {
            try {
                Class<?> clazz = Class.forName(stringArray[0]);
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                clazz.getMethod("main", String[].class).invoke(null, new Object[]{stringArray2});
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (Exception exception) {
                System.out.println("ERROR: Cannot run main: " + stringArray[0]);
                exception.printStackTrace();
            }
            return 0;
        }
        Compiler compiler = new Compiler();
        String string = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string2.equals("-?") || string2.equals("-help")) {
                Main.usage();
                return 1;
            }
            if (string2.equals("-doc")) {
                compiler.doc = true;
                continue;
            }
            if (string2.equals("-outDir")) {
                if (n + 1 >= stringArray.length) {
                    Main.println("WARNING: Invalid outDir option");
                    continue;
                }
                compiler.outDir = new File(stringArray[++n]);
                continue;
            }
            if (string2.equals("-ver")) {
                Env.printVersion((String)"Sedona Compiler");
                System.out.println("sedonac.options = 4ByteBix");
                return 1;
            }
            if (string2.equals("-v")) {
                compiler.log.severity = 1;
                continue;
            }
            if (string2.equals("-noOptimize")) {
                compiler.optimize = false;
                continue;
            }
            if (string2.equals("-www")) {
                compiler.www = true;
                continue;
            }
            if (string2.equals("-layout")) {
                compiler.dumpLayout = true;
                continue;
            }
            if (string2.equals("-test")) {
                String string3 = null;
                if (n + 1 < stringArray.length) {
                    string3 = stringArray[n + 1];
                }
                return Test.run(string3);
            }
            if (string2.equals("-kitVersion")) {
                if (n + 1 >= stringArray.length) {
                    Main.println("WARNING: Invalid kitVersion option");
                    continue;
                }
                compiler.kitVersion = new Version(stringArray[++n]);
                continue;
            }
            if (string2.equals("-noChecksum")) {
                compiler.nochk = true;
                continue;
            }
            if (string2.startsWith("-")) {
                Main.println("WARNING: Unknown option " + string2);
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            Main.println("WARNING: Ignoring argument " + string2);
        }
        if (string == null) {
            System.out.println("ERROR: No input specified");
            return 1;
        }
        try {
            compiler.compile(new File(string));
            n = compiler.warnings.size();
            if (n > 0) {
                System.out.println("*** Success with " + n + " warning(s) ***");
            } else {
                System.out.println("*** Success! ***");
            }
            return 0;
        }
        catch (CompilerException compilerException) {
            int n2 = compiler.warnings.size();
            int n3 = compiler.logErrors();
            if (n3 == 0) {
                compilerException.printStackTrace();
            } else {
                System.out.println("*** FAILED with " + n3 + " error(s) and " + n2 + " warning(s) ***");
            }
            return 1;
        }
        catch (Throwable throwable) {
            compiler.log.error("Internal compiler error", throwable);
            throwable.printStackTrace();
            return 1;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n = Main.doMain(stringArray);
            System.exit(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

