/*
 * Decompiled with CFR 0.152.
 */
package sedona.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import sedona.web.WebMsg;
import sedona.web.WebReq;
import sedona.web.WebRes;

public class WebServer {
    public int port = 80;
    volatile boolean alive = true;
    volatile Thread thread;

    public void start() {
        this.alive = true;
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                WebServer.this.loop();
            }
        });
        this.thread.start();
    }

    public void stop() {
        this.alive = false;
        this.thread.interrupt();
        this.thread = null;
    }

    void loop() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (Exception exception) {
            System.out.println("WebServer: cannot open port " + this.port + ": " + exception);
            return;
        }
        System.out.println("WebServer: opened on port " + this.port);
        while (this.alive) {
            try {
                final Socket socket = serverSocket.accept();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WebServer.this.process(socket);
                    }
                }).start();
            }
            catch (Throwable throwable) {
                if (!this.alive) continue;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(Socket socket) {
        BufferedInputStream bufferedInputStream = null;
        OutputStream outputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            outputStream = new BufferedOutputStream(socket.getOutputStream());
            WebReq webReq = new WebReq();
            webReq.readText(bufferedInputStream);
            WebRes webRes = new WebRes();
            webRes.set("Content-Type", "text/plain");
            webRes.writeText(outputStream);
            WebMsg.writeLine(outputStream, "Here was original request:");
            webReq.writeText(outputStream);
        }
        catch (Throwable throwable) {
            if (this.alive) {
                throwable.printStackTrace();
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Throwable throwable) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new WebServer().start();
        Thread.sleep(Long.MAX_VALUE);
    }
}

