/*
 * Decompiled with CFR 0.152.
 */
package sedona.vm.inet;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import sedona.vm.Context;
import sedona.vm.ReflectUtil;
import sedona.vm.inet.InetUtil;

public class UdpSocket_n
extends ReflectUtil {
    public static int maxPacketSize(Context context) {
        return 512;
    }

    public static int idealPacketSize(Context context) {
        return 512;
    }

    public static byte open(Object object, Context context) {
        try {
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.configureBlocking(false);
            UdpSocket_n.set(object, "peer", (Object)datagramChannel);
            UdpSocket_n.set(object, "closed", (Object)new Byte(0));
            return 1;
        }
        catch (Exception exception) {
            System.out.println("UdpSocket_n.open: " + exception);
            exception.printStackTrace();
            return 0;
        }
    }

    public static byte bind(Object object, int n, Context context) {
        try {
            DatagramChannel datagramChannel = UdpSocket_n.toChannel(object);
            datagramChannel.socket().bind(new InetSocketAddress(n));
            return 1;
        }
        catch (Exception exception) {
            System.out.println("UdpSocket_n.bind: " + exception);
            exception.printStackTrace();
            return 0;
        }
    }

    public static byte send(Object object, Object object2, Context context) {
        try {
            DatagramChannel datagramChannel = UdpSocket_n.toChannel(object);
            if (UdpSocket_n.getb(object, "closed")) {
                return 0;
            }
            byte[] byArray = (byte[])UdpSocket_n.get(object2, "buf");
            int n = UdpSocket_n.geti(object2, "len");
            int n2 = UdpSocket_n.geti(object2, "off");
            int n3 = UdpSocket_n.geti(object2, "port");
            InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", n3);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n);
            int n4 = datagramChannel.send(byteBuffer, inetSocketAddress);
            if (n == n4) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            System.out.println("UdpSocket_n.send: " + exception);
            exception.printStackTrace();
            return 0;
        }
    }

    public static byte receive(Object object, Object object2, Context context) {
        try {
            DatagramChannel datagramChannel = UdpSocket_n.toChannel(object);
            if (UdpSocket_n.getb(object, "closed")) {
                return 0;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(512);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramChannel.receive(byteBuffer);
            if (inetSocketAddress == null) {
                UdpSocket_n.set(object2, "addr", null);
                UdpSocket_n.seti(object2, "port", -1);
                UdpSocket_n.seti(object2, "len", 0);
                return 0;
            }
            byte[] byArray = (byte[])UdpSocket_n.get(object2, "buf");
            int n = UdpSocket_n.geti(object2, "off");
            int n2 = byteBuffer.flip().remaining();
            byteBuffer.get(byArray, n, n2);
            Object object3 = UdpSocket_n.get(object, "receiveAddr");
            InetUtil.javaToIpAddr(inetSocketAddress.getAddress(), object3);
            UdpSocket_n.seti(object2, "port", inetSocketAddress.getPort());
            UdpSocket_n.seti(object2, "len", n2);
            UdpSocket_n.set(object2, "addr", object3);
            return 1;
        }
        catch (Exception exception) {
            System.out.println("UdpSocket_n.receive: " + exception);
            exception.printStackTrace();
            return 0;
        }
    }

    public static void close(Object object, Context context) {
        try {
            UdpSocket_n.toChannel(object).close();
            UdpSocket_n.set(object, "peer", null);
            UdpSocket_n.set(object, "closed", (Object)new Byte(1));
        }
        catch (Exception exception) {
            System.out.println("UdpSocket_n.close: " + exception);
            exception.printStackTrace();
        }
    }

    static DatagramChannel toChannel(Object object) throws Exception {
        return (DatagramChannel)UdpSocket_n.get(object, "peer");
    }
}

