/*
 * Decompiled with CFR 0.152.
 */
package sedona.vm;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sedona.Depend;
import sedona.Kit;
import sedona.Schema;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.vm.Context;
import sedona.vm.Reflector;

public class SedonaClassLoader
extends ClassLoader {
    public final Schema schema;
    public final Reflector reflector;
    final HashMap kits;

    public SedonaClassLoader(ClassLoader classLoader, Schema schema, Context context) throws Exception {
        super(classLoader);
        if (context == null) {
            context = new Context();
        }
        this.schema = schema;
        this.kits = this.resolveKits();
        this.reflector = new Reflector(this, schema, context);
    }

    public SedonaClassLoader(Schema schema, Context context) throws Exception {
        this(schema.getClass().getClassLoader(), schema, context);
    }

    public SedonaClassLoader(Schema schema) throws Exception {
        this(schema, new Context());
    }

    private HashMap resolveKits() throws Exception {
        HashMap<String, ZipFile> hashMap = new HashMap<String, ZipFile>();
        for (int i = 0; i < this.schema.kits.length; ++i) {
            Kit kit = this.schema.kits[i];
            hashMap.put(kit.name, this.resolveKit(kit));
        }
        return hashMap;
    }

    private ZipFile resolveKit(Kit kit) throws Exception {
        Depend depend = Depend.makeChecksum(kit.name, kit.checksum);
        KitFile kitFile = KitDb.matchBest(depend);
        if (kitFile == null) {
            throw new Exception("Kit found found in local kit database: " + depend);
        }
        return new ZipFile(kitFile.file);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray;
        String string2 = this.parseKitName(string);
        String string3 = this.parseTypeName(string);
        if (string2 != null && string3 != null && (byArray = this.findSedonaClass(string2, string3)) != null) {
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        throw new ClassNotFoundException(string);
    }

    protected String parseKitName(String string) {
        if (string.startsWith("sedona.vm.")) {
            String string2 = string.substring("sedona.vm.".length());
            int n = string2.indexOf(46);
            return n >= 0 ? string2.substring(0, n) : null;
        }
        return null;
    }

    protected String parseTypeName(String string) {
        if (string.startsWith("sedona.vm.")) {
            String string2 = string.substring("sedona.vm.".length());
            int n = string2.indexOf(46);
            return n >= 0 ? string2.substring(n + 1) : null;
        }
        return null;
    }

    private byte[] findSedonaClass(String string, String string2) {
        ZipFile zipFile = (ZipFile)this.kits.get(string);
        if (zipFile == null) {
            return null;
        }
        String string3 = "sedona/vm/" + string + "/" + string2 + ".class";
        ZipEntry zipEntry = zipFile.getEntry(string3);
        if (zipEntry == null) {
            return null;
        }
        try {
            byte[] byArray = new byte[(int)zipEntry.getSize()];
            DataInputStream dataInputStream = new DataInputStream(zipFile.getInputStream(zipEntry));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            System.out.println("ERROR: Cannot read classfile from zip: " + string3);
            return null;
        }
    }

    private void dump(String string, byte[] byArray) {
        try {
            File file = new File("javap" + File.separator + string + ".class");
            System.out.println(":::: Dump " + file + "...");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

