/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.io.PrintWriter;
import java.util.ArrayList;
import sedona.Component;
import sedona.Link;
import sedona.Slot;
import sedona.Type;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponentListener;
import sedona.sox.SoxException;
import sedona.util.ArrayUtil;

public class SoxComponent
extends Component {
    public static final int TREE = 1;
    public static final int CONFIG = 2;
    public static final int RUNTIME = 4;
    public static final int LINKS = 8;
    public SoxComponentListener listener;
    final SoxClient client;
    final int id;
    String name;
    int parent;
    int subscription;
    Link[] links = Link.none;
    int[] children;
    int permissions;

    public SoxComponent(SoxClient soxClient, int n, Type type) {
        super(type);
        this.client = soxClient;
        this.id = n;
    }

    public SoxClient client() {
        return this.client;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Component getParent() {
        return this.parent();
    }

    @Override
    public Component[] getChildren() {
        return this.children();
    }

    @Override
    public Component getChild(String string) {
        return this.child(string);
    }

    public int parentId() {
        return this.parent;
    }

    public SoxComponent parent() {
        try {
            if (this.id == 0) {
                return null;
            }
            return this.client.load(this.parent);
        }
        catch (Exception exception) {
            throw new SoxException("Cannot read parent", exception);
        }
    }

    public int[] childrenIds() {
        return (int[])this.children.clone();
    }

    public SoxComponent[] children() {
        try {
            int n;
            int[] nArray = this.children;
            SoxComponent[] soxComponentArray = this.client.load(nArray, false);
            boolean bl = false;
            for (int i = 0; i < soxComponentArray.length; ++i) {
                if (soxComponentArray[i] != null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return soxComponentArray;
            }
            ArrayList<SoxComponent> arrayList = new ArrayList<SoxComponent>();
            for (n = 0; n < soxComponentArray.length; ++n) {
                if (soxComponentArray[n] == null) continue;
                arrayList.add(soxComponentArray[n]);
            }
            soxComponentArray = arrayList.toArray(new SoxComponent[arrayList.size()]);
            nArray = new int[soxComponentArray.length];
            for (n = 0; n < soxComponentArray.length; ++n) {
                nArray[n] = soxComponentArray[n].id;
            }
            this.children = nArray;
            return soxComponentArray;
        }
        catch (Exception exception) {
            throw new SoxException("Cannot read children", exception);
        }
    }

    public SoxComponent child(String string) {
        SoxComponent[] soxComponentArray = this.children();
        for (int i = 0; i < soxComponentArray.length; ++i) {
            if (!string.equals(soxComponentArray[i].name)) continue;
            return soxComponentArray[i];
        }
        return null;
    }

    @Override
    public Link[] links() {
        return (Link[])this.links.clone();
    }

    public int permissions() {
        return this.permissions;
    }

    synchronized void setChildren(int[] nArray) {
        this.children = nArray;
    }

    synchronized void addChild(int n) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != n) continue;
            return;
        }
        this.children = ArrayUtil.addOne(this.children, n);
    }

    synchronized void removeChild(int n) {
        this.children = ArrayUtil.removeOne(this.children, n);
    }

    public int subscription() {
        return this.subscription | (this.client.allTreeEvents ? 1 : 0);
    }

    public void fireChanged(int n) {
        try {
            if (this.listener != null) {
                this.listener.changed(this, n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter printWriter) {
        Slot[] slotArray = this.type.slots;
        printWriter.println(this.type + " " + this.id + " " + this.name);
        for (int i = 0; i < slotArray.length; ++i) {
            Slot slot = slotArray[i];
            if (!slot.isProp()) continue;
            printWriter.println("  " + slot.name + " = " + this.get(slot));
        }
        printWriter.flush();
    }
}

