/*
 * Decompiled with CFR 0.152.
 */
package sedona.offline;

import java.io.IOException;
import sedona.Buf;
import sedona.Slot;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;

public class OfflineLink {
    public OfflineComponent fromComp;
    public Slot fromSlot;
    public OfflineComponent toComp;
    public Slot toSlot;

    public OfflineLink(OfflineComponent offlineComponent, Slot slot, OfflineComponent offlineComponent2, Slot slot2) {
        this.fromComp = offlineComponent;
        this.fromSlot = slot;
        this.toComp = offlineComponent2;
        this.toSlot = slot2;
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public boolean equivalent(OfflineLink offlineLink) {
        if (this.fromComp.id < 0 || this.toComp.id < 0) {
            return this.fromComp == offlineLink.fromComp && this.fromSlot == offlineLink.fromSlot && this.toComp.id == offlineLink.toComp.id && this.toSlot.id == offlineLink.toSlot.id;
        }
        return this.fromComp.id == offlineLink.fromComp.id && this.fromSlot.id == offlineLink.fromSlot.id && this.toComp.id == offlineLink.toComp.id && this.toSlot.id == offlineLink.toSlot.id;
    }

    public String toString() {
        return this.fromComp.path() + "." + this.fromSlot.name + " -> " + this.toComp.path() + "." + this.toSlot.name;
    }

    public void encodeXml(XWriter xWriter) {
        xWriter.w("  <link ").attr("from", this.fromComp.path() + "." + this.fromSlot.name).w(" ").attr("to", this.toComp.path() + "." + this.toSlot.name).w("/>\n");
    }

    public static OfflineLink decodeXml(OfflineApp offlineApp, XElem xElem) throws Exception {
        String string = xElem.get("from");
        String string2 = xElem.get("to");
        int n = string.indexOf(46);
        int n2 = string2.indexOf(46);
        if (n <= 0) {
            throw new XException("Invalid from component/slot path: " + string, xElem);
        }
        if (n2 <= 0) {
            throw new XException("Invalid to component/slot path: " + string2, xElem);
        }
        String string3 = string.substring(0, n);
        String string4 = string2.substring(0, n2);
        String string5 = string.substring(n + 1);
        String string6 = string2.substring(n2 + 1);
        OfflineComponent offlineComponent = offlineApp.lookup(string3);
        OfflineComponent offlineComponent2 = offlineApp.lookup(string4);
        if (offlineComponent == null) {
            throw new XException("Unknown from component: " + string3, xElem);
        }
        if (offlineComponent2 == null) {
            throw new XException("Unknown to component: " + string4, xElem);
        }
        Slot slot = offlineComponent.slot(string5);
        Slot slot2 = offlineComponent2.slot(string6);
        if (slot == null) {
            throw new XException("Unknown from slot: " + offlineComponent.type + "." + string5, xElem);
        }
        if (slot2 == null) {
            throw new XException("Unknown to slot: " + offlineComponent2.type + "." + string6, xElem);
        }
        return new OfflineLink(offlineComponent, slot, offlineComponent2, slot2);
    }

    public void encodeBinary(Buf buf) {
        buf.u2(this.fromComp.id);
        buf.u1(this.fromSlot.id);
        buf.u2(this.toComp.id);
        buf.u1(this.toSlot.id);
    }

    public static OfflineLink decodeBinary(OfflineApp offlineApp, int n, Buf buf) throws Exception {
        int n2 = buf.u1();
        int n3 = buf.u2();
        int n4 = buf.u1();
        OfflineComponent offlineComponent = offlineApp.lookup(n);
        OfflineComponent offlineComponent2 = offlineApp.lookup(n3);
        if (offlineComponent == null) {
            throw new IOException("Invalid link from comp id: " + n);
        }
        if (offlineComponent2 == null) {
            throw new IOException("Invalid link to comp id: " + n3);
        }
        Slot slot = offlineComponent.type.slot(n2);
        Slot slot2 = offlineComponent2.type.slot(n4);
        if (slot == null) {
            throw new IOException("Invalid link from slot id: " + n2);
        }
        if (slot2 == null) {
            throw new IOException("Invalid link to slot id: " + n4);
        }
        return new OfflineLink(offlineComponent, slot, offlineComponent2, slot2);
    }
}

