/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import sedona.Buf;
import sedona.Env;
import sedona.dasp.DaspAcceptor;
import sedona.dasp.DaspConst;
import sedona.dasp.DaspException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocketInterface;
import sedona.dasp.DefaultDaspSocketInterface;
import sedona.dasp.ReceiveQueue;

public class DaspSocket
implements DaspConst {
    public static final int SOCKET_QUEUING = 13;
    public static final int SESSION_QUEUING = 14;
    public boolean traceSend;
    public boolean traceReceive;
    DaspAcceptor acceptor;
    volatile boolean isAlive;
    DaspSocketInterface[] interfaces;
    Object interfacesLock;
    HashMap sessions;
    Random rand;
    int qMode;
    ReceiveQueue queue;

    public static DaspSocket open(int n, DaspAcceptor daspAcceptor, int n2) throws Exception {
        if (n2 != 13 && n2 != 14) {
            throw new IllegalArgumentException("invalid queueingMode");
        }
        DaspSocket daspSocket = new DaspSocket(daspAcceptor, n2);
        daspSocket.addInterface(new DefaultDaspSocketInterface(n));
        return daspSocket;
    }

    private DaspSocket(DaspAcceptor daspAcceptor, int n) {
        Hashtable hashtable = Env.getProperties();
        if (daspAcceptor != null) {
            hashtable = daspAcceptor.options();
        }
        this.acceptor = daspAcceptor;
        this.isAlive = true;
        this.sessions = new HashMap(300);
        this.rand = new Random();
        this.interfacesLock = new Object();
        this.interfaces = new DaspSocketInterface[0];
        this.qMode = n;
        this.queue = new ReceiveQueue(DaspSession.option(hashtable, "dasp.socketQueueMax", 10000));
        this.traceSend = DaspSession.option(hashtable, "dasp.traceSend", false);
        this.traceReceive = DaspSession.option(hashtable, "dasp.traceReceive", false);
    }

    public int queuingMode() {
        return this.qMode;
    }

    public DaspAcceptor acceptor() {
        return this.acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaspSocketInterface[] interfaces() {
        Object object = this.interfacesLock;
        synchronized (object) {
            return (DaspSocketInterface[])this.interfaces.clone();
        }
    }

    public DaspSocketInterface route(InetAddress inetAddress, int n) {
        DaspSocketInterface[] daspSocketInterfaceArray = this.interfaces();
        for (int i = daspSocketInterfaceArray.length - 1; i >= 0; --i) {
            DaspSocketInterface daspSocketInterface = daspSocketInterfaceArray[i];
            if (!daspSocketInterface.routes(inetAddress, n)) continue;
            return daspSocketInterface;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterface(DaspSocketInterface daspSocketInterface) {
        Object object = this.interfacesLock;
        synchronized (object) {
            DaspSocketInterface[] daspSocketInterfaceArray = new DaspSocketInterface[this.interfaces.length + 1];
            System.arraycopy(this.interfaces, 0, daspSocketInterfaceArray, 0, this.interfaces.length);
            daspSocketInterfaceArray[this.interfaces.length] = daspSocketInterface;
            this.interfaces = daspSocketInterfaceArray;
            daspSocketInterface.start(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterface(DaspSocketInterface daspSocketInterface) {
        Object object = this.interfacesLock;
        synchronized (object) {
            ArrayList<DaspSocketInterface> arrayList = new ArrayList<DaspSocketInterface>(this.interfaces.length);
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (this.interfaces[i] == daspSocketInterface) continue;
                arrayList.add(this.interfaces[i]);
            }
            this.interfaces = arrayList.toArray(new DaspSocketInterface[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaspSession[] sessions() {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            return this.sessions.values().toArray(new DaspSession[this.sessions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaspSession session(int n) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            return (DaspSession)this.sessions.get(new Integer(n));
        }
    }

    public int port() {
        return ((DefaultDaspSocketInterface)this.interfaces[0]).sock.getLocalPort();
    }

    public boolean isClosed() {
        return !this.isAlive;
    }

    public void close() {
        DaspSession[] daspSessionArray = this.sessions();
        for (int i = 0; i < daspSessionArray.length; ++i) {
            try {
                daspSessionArray[i].close(Integer.MAX_VALUE, "socket closed");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.isAlive = false;
        DaspSocketInterface[] daspSocketInterfaceArray = this.interfaces();
        for (int i = 0; i < daspSocketInterfaceArray.length; ++i) {
            try {
                daspSocketInterfaceArray[i].stop();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public DaspSession connect(InetAddress inetAddress, int n, String string, String string2) throws Exception {
        return this.connect(inetAddress, n, string, string2, null);
    }

    public DaspSession connect(InetAddress inetAddress, int n, String string, String string2, Hashtable hashtable) throws Exception {
        if (!this.isAlive) {
            throw new IllegalStateException("socket is closed");
        }
        if (hashtable == null) {
            hashtable = System.getProperties();
        }
        DaspSocketInterface daspSocketInterface = this.route(inetAddress, n);
        DaspSession daspSession = this.alloc(daspSocketInterface, inetAddress, n, true, hashtable);
        daspSession.user = string;
        daspSession.pass = string2;
        daspSession.connect();
        return daspSession;
    }

    public DaspMessage receive(long l) throws Exception {
        if (this.qMode != 13) {
            throw new IllegalStateException("not using socket queuing mode");
        }
        DaspMessage daspMessage = this.queue.dequeue(l);
        if (daspMessage == null) {
            return null;
        }
        if (daspMessage.msgType != 6) {
            throw new DaspException("Invalid message received: " + daspMessage.msgType);
        }
        return daspMessage;
    }

    void enqueue(DaspMessage daspMessage) {
        try {
            this.queue.enqueue(daspMessage);
        }
        catch (ReceiveQueue.FullException fullException) {
            System.out.println("ERROR: DaspSocket queue full!");
        }
    }

    void dispatch(DaspSocketInterface daspSocketInterface, DatagramPacket datagramPacket) throws Exception {
        InetAddress inetAddress = datagramPacket.getAddress();
        int n = datagramPacket.getPort();
        byte[] byArray = datagramPacket.getData();
        int n2 = datagramPacket.getLength();
        DaspMessage daspMessage = new DaspMessage().decode(byArray, n2);
        DaspSession daspSession = this.session(daspMessage.sessionId);
        this.received(daspSocketInterface, daspSession, daspMessage);
        if (daspMessage.msgType == 1) {
            if (this.acceptor == null) {
                throw new IllegalStateException("Received hello with no acceptor");
            }
            DaspSession daspSession2 = this.alloc(daspSocketInterface, inetAddress, n, false, this.acceptor.options());
            daspSession2.challenge(daspMessage);
            return;
        }
        if (daspSession == null || !daspSession.host.equals(inetAddress) || daspSession.port != n) {
            return;
        }
        daspMessage.session = daspSession;
        daspSession.dispatch(daspMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DaspSession alloc(DaspSocketInterface daspSocketInterface, InetAddress inetAddress, int n, boolean bl, Hashtable hashtable) throws Exception {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            int n2;
            if (this.sessions.size() >= 10000) {
                throw new Exception("busy - too many sessions");
            }
            Integer n3 = null;
            while ((n2 = this.rand.nextInt() & 0xFFFF) == 65535 || this.sessions.get(n3 = new Integer(n2)) != null) {
            }
            DaspSession daspSession = new DaspSession(daspSocketInterface, n3, inetAddress, n, bl, hashtable);
            this.sessions.put(n3, daspSession);
            return daspSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(DaspSession daspSession) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(new Integer(daspSession.id));
        }
    }

    void send(DaspSession daspSession, DaspMessage daspMessage) {
        if (this.traceSend || daspSession.traceSend) {
            this.trace("send", daspMessage);
        }
        daspSession.iface.send(daspSession, daspMessage);
        ++daspSession.numSent;
        ++daspSession.iface.numSent;
    }

    void received(DaspSocketInterface daspSocketInterface, DaspSession daspSession, DaspMessage daspMessage) {
        if (this.traceReceive || daspSession != null && daspSession.traceReceive) {
            this.trace("recv", daspMessage);
        }
        ++daspSocketInterface.numReceived;
    }

    void trace(String string, DaspMessage daspMessage) {
        System.out.print("-- " + string + " s=" + Integer.toHexString(daspMessage.sessionId) + " seq=" + Integer.toHexString(daspMessage.seqNum));
        if (daspMessage.ack >= 0) {
            System.out.print(" ackNum=" + Integer.toHexString(daspMessage.ack));
            if (daspMessage.ackMore != null) {
                System.out.print(" ackMore=" + new Buf(daspMessage.ackMore));
            }
        }
        if (daspMessage.msgType == 6) {
            System.out.print(" cmd=" + (char)daspMessage.payload[0] + " reply=" + daspMessage.payload[1] + " ");
            System.out.print(new Buf(daspMessage.payload).toString());
        } else {
            System.out.print(" msgType=" + daspMessage.msgType);
        }
        System.out.println();
    }
}

