/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.util.HashMap;
import java.util.Iterator;
import sedona.Bool;
import sedona.Float;
import sedona.Int;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.util.TextUtil;
import sedona.xml.XElem;
import sedona.xml.XWriter;

public class Facets {
    public static final Facets empty = new Facets().ro();
    private HashMap map = new HashMap(7);
    private boolean ro = false;

    public boolean isRO() {
        return this.ro;
    }

    public Facets ro() {
        this.ro = true;
        return this;
    }

    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    public int size() {
        return this.map.size();
    }

    public String[] keys() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 1) {
                stringBuffer.append(", ");
            }
            String string = (String)iterator.next();
            stringBuffer.append(string);
            Value value = (Value)this.map.get(string);
            if (value == Bool.TRUE) continue;
            stringBuffer.append('=').append(value.toCode());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Value get(String string, Value value) {
        Value value2 = (Value)this.map.get(string);
        if (value2 == null) {
            return value;
        }
        return value2;
    }

    public Value get(String string) {
        return this.get(string, null);
    }

    public String gets(String string, String string2) {
        Str str = (Str)this.map.get(string);
        if (str == null) {
            return string2;
        }
        return str.val;
    }

    public String gets(String string) {
        return this.gets(string, null);
    }

    public boolean getb(String string, boolean bl) {
        Bool bool = (Bool)this.map.get(string);
        if (bool == null) {
            return bl;
        }
        return bool.val;
    }

    public boolean getb(String string) {
        return this.getb(string, false);
    }

    public int geti(String string, int n) {
        Int intVal = (Int)this.map.get(string);
        if (intVal == null) {
            return n;
        }
        return intVal.val;
    }

    public int geti(String string) {
        return this.geti(string, 0);
    }

    public float getf(String string, float f) {
        Float float_ = (Float)this.map.get(string);
        if (float_ == null) {
            return f;
        }
        return float_.val;
    }

    public float getf(String string) {
        return this.getf(string, 0.0f);
    }

    public Facets set(String string, Value value) {
        if (this.ro) {
            throw new IllegalStateException("Facets are readonly");
        }
        this.map.put(string, value);
        return this;
    }

    public Facets sets(String string, String string2) {
        return this.set(string, Str.make(string2));
    }

    public Facets setb(String string, boolean bl) {
        return this.set(string, Bool.make(bl));
    }

    public Facets seti(String string, int n) {
        return this.set(string, Int.make(n));
    }

    public Facets setf(String string, float f) {
        return this.set(string, Float.make(f));
    }

    public Facets remove(String string) {
        if (this.ro) {
            throw new IllegalStateException("Facets are readonly");
        }
        this.map.remove(string);
        return this;
    }

    public void encodeXml(XWriter xWriter, int n) {
        xWriter.w(TextUtil.getSpaces(n));
        xWriter.w("<facets>\n");
        String[] stringArray = this.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = this.get(string);
            String string2 = Type.predefinedName(value.typeId());
            xWriter.w(TextUtil.getSpaces(n + 2));
            xWriter.w("<").w(string2).w(" ").attr("name", string).w(" ").attr("val", value.encodeString()).w("/>\n");
        }
        xWriter.w(TextUtil.getSpaces(n));
        xWriter.w("</facets>\n");
    }

    public static Facets decodeXml(XElem xElem) {
        if (xElem == null) {
            return empty;
        }
        Facets facets = new Facets();
        XElem[] xElemArray = xElem.elems();
        for (int i = 0; i < xElemArray.length; ++i) {
            XElem xElem2 = xElemArray[i];
            String string = xElem2.name();
            String string2 = xElem2.get("name");
            String string3 = xElem2.get("val");
            Value value = Value.defaultForType(Type.predefinedId(string)).decodeString(string3);
            facets.set(string2, value);
        }
        return facets;
    }
}

