function MockAjaxObj(params) {
  
  this.params = params
  this.doneFunc = [];
  this.failFunc = [];
  this.alwaysFunc = [];
  
  this.done = function(doneFunc) {
    this.doneFunc.push(doneFunc);
    return this;
  }
  
  this.fail = function(failFunc) {
    this.failFunc.push(failFunc);
    return this;
  }
  
  this.always = function(alwaysFunc) {
    this.alwaysFunc.push(alwaysFunc);
    return this;
  }
  
  this._requestDone = function() {
    if (this.params) {
     if (this.params['success'])
      this.params.success();
     if (this.params['complete'])
       this.params.complete();
    }

    this.doneFunc.forEach(function(element, index, array) {
      element();
    });

    this.alwaysFunc.forEach(function(element, index, array) {
      element();
    });
  }
  
  if (this.params && this.params['beforeSend'])
    this.params.beforeSend();
  
  _.delay(_.bind(this._requestDone, this), 50);
}

function ProxyObjectData() {
  this._loaded = false;
  this.datas = {}
  
  this.hasWritePerm = function() { return true; }

  this.hasData = function(dataName) { 
    if (!window.propDataObj)
      return false;

    return window.propDataObj.hasOwnProperty(dataName)
  }

  this.readData = function(dataName) { 
    if (!window.propDataObj)
      return '';

    if (!window.propDataObj.hasOwnProperty(dataName))
      return '';
    
    return window.propDataObj[dataName]; 
  }
  
  this.invokeAction = function(actionPath, value, valueDataType, settings) {
    if (valueDataType == null) {
      valueDataType = "void";
    }
    if (settings == null) {
      settings = {};
    }
    
    if (_.str.startsWith(actionPath, '@'))
      this.writeData(actionPath, value, settings);
    return "action invoked";
  };

  this.writeData = function(dataName, dataValue, settings) {
    if (settings == null) {
      settings = {};
    }
    
    if (!window.propDataObj)
      return;
    
    window.propDataObj[dataName] = dataValue;
    window.propDataObj.propEdited(dataName);
  };

  this.runSqlQuery = function(sql, dataHandler, responseFormat, settings) {
    if (responseFormat == null) {
      responseFormat = "json";
    }
    if (settings == null) {
      settings = {};
    }
    return '';
  };
  
  this.readNote = function(path, dataHandler, settings) {
    if (settings == null)
      settings = {};

    var params = {
      type: "GET",
      url: "note_controller.php",
      data: {path: path},
      dataType: 'json',
      success: function(data) {
        var notes = window.propDataObj["notes"];
        var note = "this is a note for testing";
        if (notes && notes[path])
          note = notes[path];
        if (dataHandler)
          dataHandler(note);
      },
    };

    if (settings['beforeSend'])
      params['beforeSend'] = settings['beforeSend'];
    if (settings['complete'])
      params['complete'] = settings['complete'];
    if (settings['error'])
      params['error'] = settings['error'];
    
    var jqXHR = new MockAjaxObj(params);
    return jqXHR;
  };
 
  this.writeNote = function(path, content, settings) {
    if (settings == null)
      settings = {};

    var params = {
      type: "POST",
      url: "note_controller.php",
      data: {path: path, content: content},
      dataType: 'json',
      success: function(data) {
        var notes = window.propDataObj["notes"];
        if (!notes)
          notes = {};
        notes[path] = content;
        window.propDataObj["notes"] = notes;
      },
    };

    if (settings['beforeSend'])
      params['beforeSend'] = settings['beforeSend'];
    if (settings['complete'])
      params['complete'] = settings['complete'];
    if (settings['error'])
      params['error'] = settings['error'];
    
    var jqXHR = new MockAjaxObj(params);
    return jqXHR;
  };
  
  this._updatePropData = function(name) {
    if (!this._loaded || !window.propDataObj)
      return;
    
    if (!this.hasOwnProperty("update"))
      return;

    if (!name) {
      for(var prop in window.propDataObj) {
        try {
          this['update'](prop);
        } catch(err) {
        }
      }
    }
    else {
        try {
          this['update'](name);
        } catch(err) {
        }
    }
  };
  // user defined AdapterWidget's methods

  {{AdapterWidget_JSCode_Placeholder}}

  window.setInterval(_.bind(this._updatePropData, this), 3000);
  window.propDataObj.propEditedInCpt.connect(this, '_updatePropData');
}
