jQuery ->

  class ScriptLoaderSingleton
    instance = null

    @instance: ->
      instance ?= new ScriptLoader

    class ScriptLoader
      load: (scriptUrl, done, failed)->
        console.debug("start to load " + scriptUrl)
        @loadingStatus ?= {}

        stateData = @loadingStatus[scriptUrl]
        if typeof stateData == 'undefined'
          @loadingStatus[scriptUrl] = {state: 'loading', done: [], failed: []}
          dataType = _.str.endsWith(scriptUrl, ".js") and "script" or "text"
          $.ajax(
            url: scriptUrl
            dataType: dataType
            cache: true
            success: (data, status, xhr)->
              # inject returned css data
              return unless _.str.endsWith(scriptUrl, ".css")
              $('<style type="text/css"></style>').html(data).appendTo("head")
          ).done(=>
            @scriptLoaded(scriptUrl)
          ).fail(=>
            @scriptFailed(scriptUrl)
          )
          @loadingStatus[scriptUrl].done.push done if done
          @loadingStatus[scriptUrl].failed.push failed if failed
        else if stateData.state == 'loaded'
          done(scriptUrl) if done
        else if stateData.state == 'failed'
          failed(scriptUrl) if failed
        else if stateData.state == 'loading'
          stateData.done.push done if done
          stateData.failed.push failed if failed
          @loadingStatus[scriptUrl] = stateData

      scriptLoaded: (scriptUrl)=>
        stateData = @loadingStatus[scriptUrl]
        if typeof stateData == 'undefined'
          console.error "can not find loading status data for " + scriptUrl
          return

        stateData.state = 'loaded'
        done(scriptUrl) for done in stateData.done
        stateData.done = []
        stateData.failed = []
        @loadingStatus[scriptUrl] = stateData

      scriptFailed: (scriptUrl)=>
        stateData = @loadingStatus[scriptUrl]
        if typeof stateData == 'undefined'
          console.error "can not find loading status data for " + scriptUrl
          return

        stateData.state = 'failed'
        failed(scriptUrl) for failed in stateData.failed
        stateData.done = []
        stateData.failed = []
        @loadingStatus[scriptUrl] = stateData

  class AdapterWidget extends Backbone.View
    el: 'div#grWidget'

    initialize: ->
      @proxyObj = new ProxyObjectData

      # jsCode = properties.get("javascriptCode").get('value')
      # @widgetName = @model.get('name')
      @widgetName = "test"

      # (new Function(jsCode)).call(@proxyObj)

      @requiredScripts = []
      if @proxyObj.hasOwnProperty("requiredScripts")
        @requiredScripts = _.chain([@proxyObj['requiredScripts']()]).flatten().compact().value()
      @render()
        
    render: ->
      widgetWidth = window.manifestObj?.width ? 400
      widgetHeight = window.manifestObj?.height ? 800
      @$el.width(widgetWidth)
      @$el.height(widgetHeight)

      @$el.css("overflow", "visible")
      @$el.css("margin", "20px auto")

      @proxyObj['width'] = widgetWidth
      @proxyObj['height'] = widgetHeight
      @proxyObj['containerId'] = @widgetName + '_container'
      @proxyObj['elem'] = $("<div id='#{@proxyObj['containerId']}' style='width:#{widgetWidth}px; height:#{widgetHeight}px; margin: auto'></div>").appendTo(@$el)
      
      @loadScripts()
      @

    init: ->
      try
        @proxyObj['init']() if @proxyObj.hasOwnProperty("init")
      catch err
        console.warn "failed to execute 'init' method: #{err.message}"

      @proxyObj._loaded = true
      
    loadScripts: =>
      if @requiredScripts.length == 0
        @init()
      else
        scriptUrl = @requiredScripts.shift()
        ScriptLoaderSingleton.instance().load(scriptUrl, @loadScripts, @loadFailed)
        
    loadFailed: (scriptUrl)=>
      console.warn "failed to load required script: " + scriptUrl

    onDataChanged: (model, value, options)=>
      name = model.get('name')
      @proxyObj.datas[name] = value

      return unless @proxyObj._loaded

      try
        @proxyObj['update'](name) if @proxyObj.hasOwnProperty("update")
      catch err
        console.warn "failed to execute 'update' method: #{err.message}"

  window.grWidget = new AdapterWidget
