<?php
//vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";

class FileUploadController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }

  protected function genResponse() {
    $response = array();
    $file = $_FILES['file'];
    $tempPath = $file['tmp_name'];
    $name = $file['name'];

    $fileSize = filesize($tempPath);
    $imgPath = imgPath();
    if (!is_null($imgPath)) {
        //check if enough space left 
        $freeSpace = disk_free_space($imgPath);
        if ($freeSpace < $fileSize+1*1024*1024) {
          if ($this->isAjax())
            $this->renderAjaxError($response, "No enough space left.");
          else
            echo "No enough space left.";
          return;
        }

        $dstPath = build_file_path($imgPath, "login-logo.png");

        //backup original logo if possible 
        $origBackupPath = build_file_path($imgPath, "login-logo.png.orig");
        if (!file_exists($origBackupPath) && file_exists($dstPath)) {
          copy($dstPath, $origBackupPath);
        }

        move_uploaded_file($tempPath, $dstPath);
        // sync();
        if ($this->isAjax()) {
          $response['msg'] = "SUCCESS: File '$name' is uploaded sucessfully.";
          $this->renderAjaxSuccess($response);
        }
        else
          echo "SUCCESS: File '$name' is uploaded sucessfully.";
    }
    else {
      if ($this->isAjax())
        $this->renderAjaxError($response, "This platform is not supported.");
      else
        echo "This platform is not supported.";
    }
  }
  
  protected function doAjaxPost() {
    $this->genResponse();
  }

  protected function doPost() {
    echo '<textarea>';
    $this->genResponse();
    echo '</textarea>';
  }
};

$controller = new FileUploadController();
$controller->run();

?>
