<?php

class DataServiceUtility {

  public function backup($pluginsBackupDir) {
    if (!file_exists($pluginsBackupDir))
      return false;
    
    $pluginDir = __DIR__;
    $pluginDirName = basename($pluginDir);
    $pluginBackupDir = build_file_path($pluginsBackupDir, $pluginDirName);
    if (!file_exists($pluginBackupDir))
      mkdir($pluginBackupDir, 0777, TRUE);

    $files = array();
    $files[] = build_file_path($pluginDir, "data_mapping.json"); 
    $files[] = build_file_path($pluginDir, "data_mapping_config.json"); 
    $files[] = build_file_path($pluginDir, "uploads"); 
    foreach($files as $file) {
      if (!file_exists($file))
        continue;
      
      $dstPath = build_file_path($pluginBackupDir, basename($file));
      if (!recurseCopy($file, $dstPath)) {
        error_log("failed to backup " . $file . " to " . $dstPath);
        return false;
      }
    }
    return true;
  }

  public function restore() {
    $confFile = build_file_path(__DIR__, "data_mapping.json");
    if (!file_exists($confFile))
      return false;

    execCmd('ln -sf ' . $confFile . ' /etc/mqtt-service.json');
    return true;
  }
}

return new DataServiceUtility();

?>
