(function() {
  
  var UserLibClass = function() 
  {
    // define javascript methods that will be called when widget need to be initialized or data updated. 
    // in these methods' context, beside jQuery, following variables are accessible:
    //   * this.elem       - parent DOM element 
    //   * User Properties - you can define user property on AdapterWidget in CPT:
    //                        1. select a AdapterWidget object 
    //                        2. right click in the property editor
    //                        3. choose "New User Property" menu item
    //                       NOTE: all user defined properties must start with '@'. 
    //                       To read a user property's value: this.readData("@UserPropertyName");
    //                       To write a user property's value: this.writeData("@UserPropertyName", value);
    //                       To invoke an action: this.invokeAction("ActionSlotPath") or this.invokeAction("ActionSlotPath", value)
    //
    //
    // [optional] if this method defined, it should return a array of required javascript and css files
    // several js libraries(jquery, underscore, backbone etc) have been loaded, so no need to specify 
    // them here again. for all loaded js libraries, refers to file CPT/grweb/public/app/graphic.php
    // below is an example for highcharts:
    this.requiredScripts = function() {   
      // *Note*, you need to put the javascript files under CPT/grweb/public/user_codes folder
      //         manually, otherwise these files cannot be deployed to device
      return ["../user_codes/c3js/c3.min.css", "../user_codes/d3js/d3.min.js",
              "../user_codes/c3js/c3.min.js",
              "../js/daterangepicker.min.js", "../css/daterangepicker-bs2.css",
              "../js/grdaterangepicker.min.js"];
    };
    
    this.addCss = function(cls, rule) {
      var sheet = window.document.styleSheets[0];
      return sheet.insertRule(cls + '{' + rule +  '}', sheet.cssRules.length);
    }
    
    this.applyColorOfText = function() {
      var textColor = this.readData("@colorOfText");
      if (!textColor)
        return;
      if (this.oldTextColor === textColor )
        return;
      else
        this.oldTextColor = textColor;
        
      if (textColor.charAt(0) === '#')
        textColor = d3.rgb(textColor);
      else if (textColor.length == 0)
        textColor = d3.rgb("white");
      else
        textColor = d3.rgb("rgb("+_.first(textColor.split(","), 3).join()+")");
      
      var cls = '#'+this.elem.id+' .c3-axis text, #'+this.elem.id+' .c3-legend-item';
      this.addCss(cls, 'fill: '+textColor+';');
    }
    
    //GOTCHA: can not use onSettingsChanged, otherwise the parent 'onSettingsChanged' handler will be overrided
    this.settingsChangedHandler = function() {
      this.applyColorOfText();
    }
    
    // [required] after above required files loaded successfully, this method will be called to initialize the widget
    this.init = function() { 
        this.tableName = this.readData("@tableName");
        this.colData = {};
        this.collectColData(); 
        if (!this.tableName || _.isEmpty(this.colData)) {
          console.warn("table's configuration is not complete");
          return;
        }
    
        var chartId = _.uniqueId('history_line_');
        var chartDiv = $('<div id="'+ chartId +'"></div>').prependTo($(this.elem));
        this.chart = c3.generate({
            bindto: '#' + chartId,
            data: {
                xFormat: '%Y-%m-%d %H:%M:%S',
                json: [],
            },
            axis: {
                x: {
                    type: 'timeseries',
                    tick: { 
                        format: '%Y-%m-%d %H:%M:%S',
                        rotate: 45,
                        fit: true,
                    },
                }
            },
            grid: {
              x: {show: true}, y: {show: true}
            },
            line: { connectNull: true },
            zoom: { enabled: true }
        });
    
        this.applyColorOfText();
        
        var dateTimePickerHtml = " \
            <div class='datetime-range pull-right clearfix'> \
              <button class='btn' type='button'> \
              <i class='icon-calendar'></i> <span class='rangeLabel'>" + this.L("Today") + "</span> <span class='caret'></span> \
              </button> \
            </div>";
        
    //    var GrDateTimePicker = this.getExportedClass('GrDateTimePicker');
        this.picker = new GrDateTimePicker();
        this.picker.initialize();
        this.picker.attach($(dateTimePickerHtml).prependTo(chartDiv),
                this.readData("@startFromSunday") === "1" ? 'week' : 'isoWeek',
                _.bind(this.onDateTimeChanged, this));
        this.loadData(this.picker.startDate, this.picker.endDate);
        
        $(this.elem).on('settingsChanged', _.bind(this.settingsChangedHandler, this));
    };
    
    this.collectColData = function(){
      for (var i=1; ; ++i) {
        var name = this.readData("@colNameOfLine"+i);
        if (!name)
          return;
    
        var color = this.readData("@colorOfLine"+i);
        if (color.charAt(0) === '#')
          color = d3.rgb(color);
        else if (color.length == 0)
          color = d3.rgb("white");
        else
          color = d3.rgb("rgb("+_.first(color.split(","), 3).join()+")");
          
        var label = this.readData("@labelOfLine"+i);
        if (_.isEmpty(label))
          label = name;
        this.colData[name] = {
          "color": color,
          "label": label,
        };
      }
    };
    
    this.onDateTimeChanged = function(start, end) {
        this.picker.startDate = start;
        this.picker.endDate = end;
        $(this.elem).find(".rangeLabel").text(this.picker.rangeLabel(start, end));
    
        this.loadData(start, end);
    };
    
    this.loadData = function(start, end) {
        var _this = this;
        var startDT = start.utc().format('YYYY-MM-DD HH:mm:ss');
        var endDT = end.utc().format('YYYY-MM-DD HH:mm:ss');
        var local = moment();
        var tzOffset = local.utcOffset ? local.utcOffset() : local.zone();
    
        this.startSpinner();
        var colNames = _.reduce(_.keys(this.colData), function(memo, name) { return memo+", \""+name+"\""; }, "");
        var query = "SELECT datetime(dt, '" + -1*tzOffset + " minutes') as dt " + colNames + " FROM " + this.tableName + " WHERE dt >= '" + startDT + "' and dt <= '" + endDT +"';";
        _this.runSqlQuery(query, _.bind(_this.onDataLoaded, _this));
    };
    
    this.onDataLoaded = function(data) {
        this.stopSpinner();
        if (!data || _.isEmpty(data)) 
          this.chart.unload();
        else {
          var columns = data.columns;
          // map column name to user defined label
          for(var i=0; i<columns.length ; ++i) {
            var col = columns[i];
            if (!_.has(this.colData, columns[i]))
              continue;
    
            columns[i] = this.colData[col]['label'];
          }
    
          var _this = this;
          // prepare chart data
          var jsonData = _.map(data.rows, function(row) { return _.object(columns, row); });
          var colors = _.reduce(_.keys(this.colData), function(memo, col) { 
            memo[_this.colData[col]['label']] = _this.colData[col]['color'];
            return memo;
          }, {});
          this.chart.load({
            xFormat: '%Y-%m-%d %H:%M:%S',
            keys: {
               x: 'dt',
               value: columns,
            },
            colors: colors,
            json: jsonData
          });
        }
    };
    
    // [required] when user property changed, this callback method will be called
    // it is a good place to update widget with new data, you can read user property's value by:
    // this.readData("@UserPropertyName")
    this.update = function(userPropertyName) {
    };
    
    // [required] put possible clean up codes here
    this.cleanup = function() {
    };
                      
  };

  var userLib = new UserLibClass();
  var external_scripts = _.has(userLib, 'requiredScripts') ? userLib.requiredScripts() : [];
  if (external_scripts == null)
    external_scripts = [];
  external_scripts.push("../js/underscore.string.min.js");

  //TODO: generate settings from user_lib
  freeboard.loadWidgetPlugin({
    'external_scripts': external_scripts,
    'fill_size': false,
    'type_name': 'CPT_Sql_HistoryLineChart_Widget',
    'display_name': 'HistoryLineChart',
    'description': 'HistoryLineChart Widget converted from CPT Graphics'    ,
    'settings': [
      {
        'name': '@colNameOfLine1',
        'display_name': '@colNameOfLine1',
        'type': 'text',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@colNameOfLine2',
        'display_name': '@colNameOfLine2',
        'type': 'text',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@colorOfLine1',
        'display_name': '@colorOfLine1',
        'type': 'text',
        'default_value': '',
        'editor': 'color'
      },
      {
        'name': '@colorOfLine2',
        'display_name': '@colorOfLine2',
        'type': 'text',
        'default_value': '',
        'editor': 'color'
      },
      {
        'name': '@colorOfText',
        'display_name': '@colorOfText',
        'type': 'text',
        'default_value': '',
        'editor': 'color',
        'description': 'Text color of X, Y axis and legend'
      },
      {
        'name': '@labelOfLine1',
        'display_name': '@labelOfLine1',
        'type': 'text',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@labelOfLine2',
        'display_name': '@labelOfLine2',
        'type': 'text',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@startFromSunday',
        'display_name': '@startFromSunday',
        'type': 'boolean',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@tableName',
        'display_name': '@tableName',
        'type': 'text',
        'default_value': '',
        'editor': ''
      },
      {
        'name': 'rows',
        'display_name': 'Rows',
        'type': 'option',
        'default_value': '6',
        'options': [{'name': '1 row', 'value': 1}, {'name': '2 rows', 'value': 2}, {'name': '3 rows', 'value': 3}, {'name': '4 rows', 'value': 4}, {'name': '5 rows', 'value': 5}, {'name': '6 rows', 'value': 6}, {'name': '7 rows', 'value': 7}, {'name': '8 rows', 'value': 8}]
      }      
    ], 
    newInstance: function(settings, newInstanceCallback)
    {
      var wa = new WidgetAdapter(settings);
      wa = _.extend(wa, new UserLibClass());
      newInstanceCallback(wa);
    }
  });

})();
