(function() {
  
  var UserLibClass = function() 
  {
    // define javascript methods that will be called when widget need to be initialized or data updated. 
    // in these methods' context, beside jQuery, following variables are accessible:
    //   * this.elem       - parent DOM element 
    //   * User Properties - you can define user property on AdapterWidget in CPT:
    //                        1. select a AdapterWidget object 
    //                        2. right click in the property editor
    //                        3. choose "New User Property" menu item
    //                       NOTE: all user defined properties start with '@'. 
    //                       To read a user property's value: this.readData("@UserPropertyName");
    //                       To write a user property's value: this.writeData("@UserPropertyName", value);
    //                       To invoke an action: this.invokeAction("ActionSlotPath") or this.invokeAction("ActionSlotPath", value)
    //
    //
    // [optional] if this method defined, it should return a array of required javascript and css files
    this.requiredScripts = function() {   
      // *Note*, you need to put the javascript files under CPT/grweb/public/user_codes folder
      //         manually, otherwise these files cannot be deployed to device
      return ["../user_codes/circular-slider/dist/circular-slider.min.css",
                 "../user_codes/circular-slider/dist/circular-slider.min.js"];
    };
    
    this.getReadDelayAfterWrite = function() {
      var delay = this.readData("@ReadDelayAfterWrite");
      if (typeof this.isDashboard !== 'function' || !this.isDashboard()) {
        //CPT Graphics does not support enum with customized values, 
        //so we need to convert from index to value here. Yes, it sucks 
        delay = [15000, 30000, 60000][delay];
      }
      else {
        if (delay === null || Number.isNaN(_.str.toNumber(delay)))
          delay = 15000;
        else
          delay = _.str.toNumber(delay)*1000;
      }
      return delay;
    };
        
    this.changeData = function(elem, value) {
      var val = this.readData("@data");
      if (this.slider.getValue() == _.str.toNumber(val))
        return;
      
      var _this = this;
      var delay = this.getReadDelayAfterWrite();
        
      if (this.updateTimer !== null) {
        clearTimeout(this.updateTimer);
        this.updateTimer = null;
      }
      
      var enableDataUpdate = _.after(2, function() {
        _this.stopUpdate = false; 
        if (typeof _this.isDashboard !== 'function' || !_this.isDashboard())
          _this.update("@data");
      });
      this.updateTimer = setTimeout(enableDataUpdate, delay);
      
      this.stopUpdate = true;
      var settings = {'complete': enableDataUpdate};
      if (_.str.isBlank(this.setPointPath))
        this.writeData("@data", value, settings);
      else
        this.invokeAction(this.setPointPath, value, null, settings);
    };
    
    this.setupUI = function() {
      if (this.updateTimer !== null) {
        clearTimeout(this.updateTimer);
        this.updateTimer = null;
      }
      
      $(this.elem).empty();
      var parentWidth = $(this.elem).width();
      var parentHeight = $(this.elem).height();
      var radius = Math.min(parentWidth, parentHeight)/2-8;
      this.slider = $("<div style='width:100%; height:100%; text-align:center;'></div>").appendTo($(this.elem)).CircularSlider({
        min: _.str.toNumber(this.readData("@MinVal")), 
        max: _.str.toNumber(this.readData("@MaxVal")),
        radius: radius,
        labelSuffix: this.readData("@LabelSuffix"),
        onSlideEnd: _.bind(this.changeData, this)
      });
    };
    
    // [required] when required javascripts loaded successfully, this method will be called to initialize the widget
    this.init = function() { 
      this.stopUpdate = false;
      this.updateTimer = null;
      this.setPointPath = this.readData("@SetPoint");
      this.setupUI();
      
      $(this.elem).on('settingsChanged', _.bind(this.setupUI, this));
      this.update("@data");
    };
    
    // [required] when user property changed, this callback method will be called
    // it is a good place to update widget with new data, you can read user property's name by:
    // this.readData("@UserPropertyName")
    this.update = function(userPropertyName) {
      if (this.stopUpdate || userPropertyName != "@data")
        return;
    
      var val = _.str.toNumber(this.readData("@data"));
      if (isNaN(val))
        return; 
        
      let min = _.str.toNumber(this.readData("@MinVal"));
      let max = _.str.toNumber(this.readData("@MaxVal"));
      if (val < min || val > max) {
        $(this.elem).trigger("widget.error", "Out of range");
        return;
      } else  
        $(this.elem).trigger("widget.ok");
        
      this.slider.setValue(val);
    };
    
    // [required] put possible clean up codes here
    this.cleanup = function() {
    };    
  };

  var userLib = new UserLibClass();
  var external_scripts = _.has(userLib, 'requiredScripts') ? userLib.requiredScripts() : [];
  if (external_scripts == null)
    external_scripts = [];
  external_scripts.push("../js/underscore.string.min.js");

  //TODO: generate settings from user_lib
  freeboard.loadWidgetPlugin({
    'external_scripts': external_scripts,
    'fill_size': false,
    'type_name': 'CPT_Sliders_CircularSlider_Widget',
    'display_name': 'CircularSlider',
    'description': 'CircularSlider Widget converted from CPT Graphics'    ,
    'settings': [
      {
        'name': '@LabelSuffix',
        'display_name': '@LabelSuffix',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@MaxVal',
        'display_name': '@MaxVal',
        'type': 'calculated',
        'default_value': '100',
        'editor': ''
      },
      {
        'name': '@MinVal',
        'display_name': '@MinVal',
        'type': 'calculated',
        'default_value': '0',
        'editor': ''
      },
      {
        'name': '@ReadDelayAfterWrite',
        'display_name': '@ReadDelayAfterWrite',
        'type': 'option',
        'options': [{'name': 'Normal', 'value': '15'},{'name': 'Slow', 'value': '30'},{'name': 'Very Slow', 'value': '60'}],
        'default_value': '15',
        'editor': ''
      },
      {
        'name': '@SetPoint',
        'display_name': '@SetPoint',
        'type': 'calculated',
        'default_value': '',
        'editor': 'action'
      },
      {
        'name': '@data',
        'display_name': '@data',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': 'rows',
        'display_name': 'Rows',
        'type': 'option',
        'default_value': '4',
        'options': [{'name': '1 row', 'value': 1}, {'name': '2 rows', 'value': 2}, {'name': '3 rows', 'value': 3}, {'name': '4 rows', 'value': 4}, {'name': '5 rows', 'value': 5}, {'name': '6 rows', 'value': 6}, {'name': '7 rows', 'value': 7}, {'name': '8 rows', 'value': 8}]
      }      
    ], 
    newInstance: function(settings, newInstanceCallback)
    {
      var wa = new WidgetAdapter(settings);
      wa = _.extend(wa, new UserLibClass());
      newInstanceCallback(wa);
    }
  });

})();
