(function() {
  
  var UserLibClass = function() 
  {
    
    // define javascript methods that will be called when widget need to be initialized or data updated. 
    // in these methods' context, beside jQuery, following variables are accessible:
    //   * this.elem       - parent DOM element 
    //   * User Properties - you can define user property on AdapterWidget in CPT:
    //                        1. select a AdapterWidget object 
    //                        2. right click in the property editor
    //                        3. choose "New User Property" menu item
    //                       NOTE: all user defined properties must start with '@'. 
    //                       To read a user property's value: this.readData("@UserPropertyName");
    //                       To write a user property's value: this.writeData("@UserPropertyName", value);
    //                       To invoke an action: this.invokeAction("ActionSlotPath") or this.invokeAction("ActionSlotPath", value)
    //
    //
    // [optional] if this method defined, it should return a array of required javascript and css files
    // several js libraries(jquery, underscore, backbone etc) have been loaded, so no need to specify 
    // them here again. for all loaded js libraries, refers to file CPT/grweb/public/app/graphic.php
    // below is an example for highcharts:
    this.requiredScripts = function() {   
      // *Note*, you need to put the javascript files under CPT/grweb/public/user_codes folder
      //         manually, otherwise these files cannot be deployed to device
      //return ["../user_codes/highcharts/js/highcharts.js",
      //        "../user_codes/highcharts/js/highcharts-more.js",
      //        "../user_codes/highcharts/js/exporting.js"];
    };
    
    this.updateUI = function() {
      $(this.elem).empty();
      
      var defaultHtml = "<div class='int-image' style='width:100%; height:100%; background: #9E9E9E center center no-repeat; background-size:contain;'></div>";
      var intVal = parseInt(this.readData("@IntegerData"));
      if (isNaN(intVal)) {
        $(this.elem).html(defaultHtml);
      } else {
        var img = this.readData("@Image"+intVal);
        if (!_.str.isBlank(img)) {
          $(this.elem).html("<div class='int-image' style='width:100%; height:100%; background:url("+img+") center center no-repeat; background-size:contain;'></div>");
        } else {
          $(this.elem).html(defaultHtml);
        }
      }
    
    }
    // [required] after above required files loaded successfully, this method will be called to initialize the widget
    this.init = function() { 
      this.updateUI();
      $(this.elem).on("settingsChanged", _.bind(this.updateUI, this));
    };
    
    // [required] when user property changed, this callback method will be called
    // it is a good place to update widget with new data, you can read user property's value by:
    // this.readData("@UserPropertyName")
    this.update = function(userPropertyName) {
      if (userPropertyName != "@IntegerData")
        return;
        
      this.updateUI();
    };
    
    // [required] put possible clean up codes here
    this.cleanup = function() {
    };
                      
  };

  var userLib = new UserLibClass();
  var external_scripts = _.has(userLib, 'requiredScripts') ? userLib.requiredScripts() : [];
  if (external_scripts == null)
    external_scripts = [];
  external_scripts.push("../js/underscore.string.min.js");

  //TODO: generate settings from user_lib
  freeboard.loadWidgetPlugin({
    'external_scripts': external_scripts,
    'fill_size': false,
    'type_name': 'CPT_Image_IntegerImage_Widget',
    'display_name': 'IntegerImage',
    'description': 'IntegerImage Widget converted from CPT Graphics'    ,
    'settings': [
      {
        'name': '@Image0',
        'display_name': '@Image0',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@Image1',
        'display_name': '@Image1',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@Image2',
        'display_name': '@Image2',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@Image3',
        'display_name': '@Image3',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@Image4',
        'display_name': '@Image4',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@Image5',
        'display_name': '@Image5',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@Image6',
        'display_name': '@Image6',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@Image7',
        'display_name': '@Image7',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@IntegerData',
        'display_name': '@IntegerData',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': 'rows',
        'display_name': 'Rows',
        'type': 'option',
        'default_value': '1',
        'options': [{'name': '1 row', 'value': 1}, {'name': '2 rows', 'value': 2}, {'name': '3 rows', 'value': 3}, {'name': '4 rows', 'value': 4}, {'name': '5 rows', 'value': 5}, {'name': '6 rows', 'value': 6}, {'name': '7 rows', 'value': 7}, {'name': '8 rows', 'value': 8}]
      }      
    ], 
    newInstance: function(settings, newInstanceCallback)
    {
      var wa = new WidgetAdapter(settings);
      wa = _.extend(wa, new UserLibClass());
      newInstanceCallback(wa);
    }
  });

})();
