(function() {
  
  var UserLibClass = function() 
  {
    this.requiredScripts = function() {   
    };
    
    this.setupUI = function() {
      $(this.elem).empty();

      $(this.elem).mouseenter(_.bind(this.onMouseEnter, this));
      $(this.elem).mouseleave(_.bind(this.onMouseLeave, this));

      var label = this.readData("@ValueLabel");
      var value = this.readData("@Value");
      if (_.str.startsWith(value, 'datasources['))
        value = '';
      $("<div class='view-panel tw-value' style='font-size: 30px; color: rgb(255, 255, 255); max-width: 100%;'><span style='color:#8b8b8b'>"+label+"</span><span class='value-section'>"+value+"</span></div>").appendTo($(this.elem));

      var editPanel = $("<div class='edit-panel' style='display:none;height:100%;width:100%;padding-top:10px;'><label for='slotValue' style='margin-right:10px;'>"+label+"</label><input id='slotValue' type='text' style='width:50%; max-width:160px; margin-right:10px;'></input><div style='margin-top:4px;float:right;'><span class='text-button'><i class='icon-ok icon-white' style='margin-right:0;'></i></span><span class='text-button'><i class='icon-remove icon-white' style='margin-right:0;'></i></span></div></div>").appendTo($(this.elem));
      editPanel.find(".icon-ok").on('click', _.bind(this.saveNewVal, this));
      editPanel.find(".icon-remove").on('click', _.bind(this.toggleViewPanel, this));
      editPanel.find("input").on('keyup', _.bind(this.onInputChanged, this));
      
      var overlay = $("<div class='hint-overlay' style='display:none;position:absolute;top:0;left:0;width:100%;height:100%;z-index:10;background-color:#2a2a2a;text-align:center;padding-top:10px;opacity:0.8;color:#B88F51;font-size:30px;'>Click to Edit</div>").appendTo($(this.elem));
      overlay.on('click', _.bind(this.toggleEditPanel, this));
    };
    
    this.isEditing = function() {
      return $(this.elem).find(".edit-panel").is(":visible");
    };
    
    this.onMouseEnter = function() { 
      if (this.isEditing())
        return;

      if (typeof freeboard != 'undefined' && null != freeboard && freeboard.isEditing())
        return;

      $(this.elem).find(".hint-overlay").show();
    };

    this.onMouseLeave = function() {
      $(this.elem).find(".hint-overlay").hide();
    };
    
    this.isInputValid = function() {
      var newVal = $(this.elem).find(".edit-panel input").val();
      var dataType = this.slotDataType('@Value');
      
      if (this.readData("@allowBlank") && _.str.isBlank(newVal) )
        return true;

      var isValid = false;
      if (dataType == 'bool') {
        isValid = /^true|True|TRUE|1|false|False|FALSE|0$/.test(newVal);
      } else if (dataType == 'Buf') { 
        // GOTCHA: now can not differentiate Str from Buf, so hack it here
        if (/^0[xX]/.test(newVal))
          isValid = /^0[xX][0-9a-fA-F]+$/.test(newVal)
        else
          return true; // /^\w+$/.test(newVal);
      // } else if (dataType == 'Str') {
      //   isValid = /^\w+$/.test(newVal);
      } else if (dataType == 'byte' || dataType == 'short' || dataType == 'int' || dataType == 'long') {
        isValid = !isNaN(parseInt(newVal));
      } else if (dataType == 'float' || dataType == 'double') {
        isValid = !isNaN(parseFloat(newVal));
      }
      return isValid;
    };
    
    this.onInputChanged = function() {
      if (this.isInputValid()) {
        $(this.elem).find('.edit-panel input').css({color: 'white'});
        $(this.elem).find('.edit-panel .icon-ok').addClass('icon-white');
        // $(this.elem).find('.edit-panel .icon-ok').enable();
      } else {
        // $(this.elem).find('.edit-panel .icon-ok').disable();
        $(this.elem).find('.edit-panel input').css({color: 'red'});
        $(this.elem).find('.edit-panel .icon-ok').removeClass('icon-white');
      }
    };
    
    this.toggleEditPanel = function() {
      $(this.elem).find(".hint-overlay").hide();

      var viewPanel = $(this.elem).find('.view-panel');
      viewPanel.hide();
      var curVal = viewPanel.find('.value-section').text();

      var editPanel = $(this.elem).find('.edit-panel');
      editPanel.find('input').val(curVal);
      editPanel.show();
    };
    
    this.toggleViewPanel = function() {
      $(this.elem).find('.edit-panel').hide();
      $(this.elem).find('.view-panel').show();
    };
    
    this.saveNewVal = function() {
      if (typeof freeboard != 'undefined' && null != freeboard && freeboard.isEditing())
        return;

      if (!this.isInputValid())
        return;

      this.toggleViewPanel();
      var newVal = $(this.elem).find('.edit-panel input').val();
      this.writeData('@Value', newVal);
    };
    
    // [required] after above required files loaded successfully, this method will be called to initialize the widget
    this.init = function() { 
      this.setupUI();
      
      $(this.elem).on('settingsChanged', _.bind(this.setupUI, this));
    };
    
    // [required] when user property changed, this callback method will be called
    // it is a good place to update widget with new data, you can read user property's value by:
    // this.readData("@UserPropertyName")
    this.update = function(userPropertyName) {
      if (userPropertyName != "@Value")
        return ;
      
      var val = this.readData("@Value");
      if (_.str.startsWith(val, 'datasources['))
        val = '';
      $(this.elem).find('.view-panel .value-section').text(val);
    };
    
    // [required] put possible clean up codes here
    this.cleanup = function() {
    };
                      
  };

  var userLib = new UserLibClass();
  var external_scripts = _.has(userLib, 'requiredScripts') ? userLib.requiredScripts() : [];
  if (external_scripts == null)
    external_scripts = [];
  external_scripts.push("../js/underscore.string.min.js");

  freeboard.loadWidgetPlugin({
    'external_scripts': external_scripts,
    'fill_size': false,
    'type_name': 'CPT_Editor_ValueEditor_Widget',
    'display_name': 'ValueEditor',
    'description': 'ValueEditor Widget converted from CPT Graphics'    ,
    'settings': [
      {
        'name': '@ValueLabel',
        'display_name': '@ValueLabel',
        'type': 'text',
        'default_value': '',
        'editor': '',
        'description': 'label of value'
      },
      {
        'name': '@Value',
        'display_name': '@Value',
        'type': 'calculated',
        'default_value': '',
        'editor': '',
        'description': 'value slot'
      },
      {
        'name': '@allowBlank',
        'display_name': '@AllowBlank',
        'type': 'boolean',
        'default_value': false
      },
      {
        'name': 'rows',
        'display_name': 'Rows',
        'type': 'option',
        'default_value': '1',
        'options': [{'name': '1 row', 'value': 1}, {'name': '2 rows', 'value': 2}, {'name': '3 rows', 'value': 3}, {'name': '4 rows', 'value': 4}, {'name': '5 rows', 'value': 5}, {'name': '6 rows', 'value': 6}, {'name': '7 rows', 'value': 7}, {'name': '8 rows', 'value': 8}]
      }      
    ], 
    newInstance: function(settings, newInstanceCallback)
    {
      var wa = new WidgetAdapter(settings);
      wa = _.extend(wa, new UserLibClass());
      newInstanceCallback(wa);
    }
  });

})();
