function DialogBox(contentElement,title,okTitle,cancelTitle,okCallback){function closeModal(){overlay.fadeOut(200,function(){$(this).remove()})}var overlay=$('<div id="modal_overlay" style="display:none;"></div>'),modalDialog=$('<div class="modal"></div>');modalDialog.append('<header><h2 class="title">'+title+"</h2></header>"),$("<section></section>").appendTo(modalDialog).append(contentElement);var footer=$("<footer></footer>").appendTo(modalDialog);okTitle&&$('<span id="dialog-ok" class="text-button">'+okTitle+"</span>").appendTo(footer).click(function(){var hold=!1;_.isFunction(okCallback)&&(hold=okCallback()),hold||closeModal()}),cancelTitle&&$('<span id="dialog-cancel" class="text-button">'+cancelTitle+"</span>").appendTo(footer).click(function(){closeModal()}),overlay.append(modalDialog),$("body").append(overlay),overlay.fadeIn(200)}function FreeboardModel(datasourcePlugins,widgetPlugins,freeboardUI){var self=this,SERIALIZATION_VERSION=1;this.version=0,this.isEditing=ko.observable(!1),this.allow_edit=ko.observable(!1),this.allow_edit.subscribe(function(newValue){newValue?$("#main-header").show():$("#main-header").hide()}),this.header_image=ko.observable(),this.plugins=ko.observableArray(),this.datasources=ko.observableArray(),this.panes=ko.observableArray(),this.datasourceData={},this.processDatasourceUpdate=function(datasourceModel,newData){var datasourceName=datasourceModel.name();self.datasourceData[datasourceName]=newData,_.each(self.panes(),function(pane){_.each(pane.widgets(),function(widget){widget.processDatasourceUpdate(datasourceName)})})},this._datasourceTypes=ko.observable(),this.datasourceTypes=ko.computed({read:function(){self._datasourceTypes();var returnTypes=[];return _.each(datasourcePlugins,function(datasourcePluginType){var typeName=datasourcePluginType.type_name,displayName=typeName;_.isUndefined(datasourcePluginType.display_name)||(displayName=datasourcePluginType.display_name),returnTypes.push({name:typeName,display_name:displayName})}),returnTypes}}),this._widgetTypes=ko.observable(),this.widgetTypes=ko.computed({read:function(){self._widgetTypes();var returnTypes=[];return _.each(widgetPlugins,function(widgetPluginType){var typeName=widgetPluginType.type_name,displayName=typeName;_.isUndefined(widgetPluginType.display_name)||(displayName=widgetPluginType.display_name),returnTypes.push({name:typeName,display_name:displayName})}),returnTypes}}),this.addPluginSource=function(pluginSource){pluginSource&&-1==self.plugins.indexOf(pluginSource)&&self.plugins.push(pluginSource)},this.serialize=function(){var panes=[];_.each(self.panes(),function(pane){panes.push(pane.serialize())});var datasources=[];return _.each(self.datasources(),function(datasource){datasources.push(datasource.serialize())}),{version:SERIALIZATION_VERSION,header_image:self.header_image(),allow_edit:self.allow_edit(),plugins:self.plugins(),panes:panes,datasources:datasources,columns:freeboardUI.getUserColumns()}},this.deserialize=function(object,finishedCallback){function finishLoad(){freeboardUI.setUserColumns(object.columns),self.allow_edit(_.isUndefined(object.allow_edit)?!0:object.allow_edit),self.version=object.version||0,self.header_image(object.header_image),_.each(object.datasources,function(datasourceConfig){var datasource=new DatasourceModel(self,datasourcePlugins);datasource.deserialize(datasourceConfig),self.addDatasource(datasource)});var sortedPanes=_.sortBy(object.panes,function(pane){return freeboardUI.getPositionForScreenSize(pane).row});_.each(sortedPanes,function(paneConfig){var pane=new PaneModel(self,widgetPlugins);pane.deserialize(paneConfig),self.panes.push(pane)}),self.allow_edit()&&0==self.panes().length&&self.setEditing(!0),_.isFunction(finishedCallback)&&finishedCallback(),freeboardUI.processResize(!0)}self.clearDashboard(),_.each(object.plugins,function(plugin){self.addPluginSource(plugin)}),_.isArray(object.plugins)&&object.plugins.length>0?head.js(object.plugins,function(){finishLoad()}):finishLoad()},this.clearDashboard=function(){freeboardUI.removeAllPanes(),_.each(self.datasources(),function(datasource){datasource.dispose()}),_.each(self.panes(),function(pane){pane.dispose()}),self.plugins.removeAll(),self.datasources.removeAll(),self.panes.removeAll()},this.loadDashboard=function(dashboardData,callback){freeboardUI.showLoadingIndicator(!0),self.deserialize(dashboardData,function(){freeboardUI.showLoadingIndicator(!1),_.isFunction(callback)&&callback(),freeboard.emit("dashboard_loaded")})},this.loadDashboardFromLocalFile=function(){if(window.File&&window.FileReader&&window.FileList&&window.Blob){var input=document.createElement("input");input.type="file",$(input).on("change",function(event){var files=event.target.files;if(files&&files.length>0){var file=files[0],reader=new FileReader;reader.addEventListener("load",function(fileReaderEvent){var textFile=fileReaderEvent.target,jsonObject=JSON.parse(textFile.result);self.loadDashboard(jsonObject),self.setEditing(!1)}),reader.readAsText(file)}}),$(input).trigger("click")}else alert("Unable to load a file in this browser.")},this.saveDashboardClicked=function(){var target=$(event.currentTarget),siblingsShown=target.data("siblings-shown")||!1;siblingsShown?$(event.currentTarget).siblings("label").fadeOut("slow"):$(event.currentTarget).siblings("label").fadeIn("slow"),target.data("siblings-shown",!siblingsShown)},this.saveDashboard=function(_thisref,event){var pretty=$(event.currentTarget).data("pretty"),contentType="application/octet-stream",a=document.createElement("a");if(pretty)var blob=new Blob([JSON.stringify(self.serialize(),null,"	")],{type:contentType});else var blob=new Blob([JSON.stringify(self.serialize())],{type:contentType});document.body.appendChild(a),a.href=window.URL.createObjectURL(blob),a.download="dashboard.json",a.target="_self",a.click()},this.addDatasource=function(datasource){self.datasources.push(datasource)},this.deleteDatasource=function(datasource){delete self.datasourceData[datasource.name()],datasource.dispose(),self.datasources.remove(datasource)},this.createPane=function(){var newPane=new PaneModel(self,widgetPlugins);self.addPane(newPane)},this.addGridColumnLeft=function(){freeboardUI.addGridColumnLeft()},this.addGridColumnRight=function(){freeboardUI.addGridColumnRight()},this.subGridColumnLeft=function(){freeboardUI.subGridColumnLeft()},this.subGridColumnRight=function(){freeboardUI.subGridColumnRight()},this.addPane=function(pane){self.panes.push(pane)},this.deletePane=function(pane){pane.dispose(),self.panes.remove(pane)},this.deleteWidget=function(widget){ko.utils.arrayForEach(self.panes(),function(pane){pane.widgets.remove(widget)}),widget.dispose()},this.setEditing=function(editing,animate){if(self.allow_edit()||!editing){self.isEditing(editing),_.isUndefined(animate)&&(animate=!0);var animateLength=animate?250:0,barHeight=$("#admin-bar").outerHeight();editing?($("#toggle-header-icon").addClass("icon-chevron-up").removeClass("icon-wrench"),$(".gridster .gs_w").css({cursor:"pointer"}),$("#main-header").animate({top:"0px"},animateLength),$("#board-content").animate({top:barHeight+20+"px"},animateLength),$("#main-header").data().shown=!0,freeboardUI.attachWidgetEditIcons($(".sub-section")),freeboardUI.enableGrid()):($("#toggle-header-icon").addClass("icon-wrench").removeClass("icon-chevron-up"),$(".gridster .gs_w").css({cursor:"default"}),$("#main-header").animate({top:"-"+barHeight+"px"},animateLength),$("#board-content").animate({top:"20"},animateLength),$("#main-header").data().shown=!1,$(".sub-section").unbind(),freeboardUI.disableGrid()),freeboardUI.showPaneEditIcons(editing,animate)}},this.toggleEditing=function(){var editing=!self.isEditing();self.setEditing(editing)}}function FreeboardUI(){function processResize(layoutWidgets){var maxDisplayableColumns=getMaxDisplayableColumnCount(),repositionFunction=function(){};layoutWidgets&&(repositionFunction=function(){var paneElement=this,paneModel=ko.dataFor(paneElement),newPosition=getPositionForScreenSize(paneModel);$(paneElement).attr("data-sizex",Math.min(paneModel.col_width(),maxDisplayableColumns,grid.cols)).attr("data-row",newPosition.row).attr("data-col",newPosition.col),paneModel.processSizeChange()}),updateGridWidth(Math.min(maxDisplayableColumns,userColumns)),repositionGrid(repositionFunction),updateGridColumnControls()}function addGridColumn(shift){var num_cols=grid.cols+1;updateGridWidth(num_cols)&&repositionGrid(function(){var newPosition,paneElement=this,paneModel=ko.dataFor(paneElement),prevColumnIndex=grid.cols>1?grid.cols-1:1,prevCol=paneModel.col[prevColumnIndex],prevRow=paneModel.row[prevColumnIndex];if(shift){leftPreviewCol=!0;var newCol=prevCol<grid.cols?prevCol+1:grid.cols;newPosition={row:prevRow,col:newCol}}else rightPreviewCol=!0,newPosition={row:prevRow,col:prevCol};$(paneElement).attr("data-sizex",Math.min(paneModel.col_width(),grid.cols)).attr("data-row",newPosition.row).attr("data-col",newPosition.col)}),updateGridColumnControls(),userColumns=grid.cols}function subtractGridColumn(shift){var num_cols=grid.cols-1;updateGridWidth(num_cols)&&repositionGrid(function(){var newPosition,paneElement=this,paneModel=ko.dataFor(paneElement),prevColumnIndex=grid.cols+1,prevCol=paneModel.col[prevColumnIndex],prevRow=paneModel.row[prevColumnIndex];if(shift){var newCol=prevCol>1?prevCol-1:1;newPosition={row:prevRow,col:newCol}}else{var newCol=prevCol<=grid.cols?prevCol:grid.cols;newPosition={row:prevRow,col:newCol}}$(paneElement).attr("data-sizex",Math.min(paneModel.col_width(),grid.cols)).attr("data-row",newPosition.row).attr("data-col",newPosition.col)}),updateGridColumnControls(),userColumns=grid.cols}function updateGridColumnControls(){var col_controls=$(".column-tool"),available_width=$("#board-content").width(),max_columns=Math.floor(available_width/COLUMN_WIDTH);grid.cols<=MIN_COLUMNS?col_controls.addClass("min"):col_controls.removeClass("min"),grid.cols>=max_columns?col_controls.addClass("max"):col_controls.removeClass("max")}function getMaxDisplayableColumnCount(){var available_width=$("#board-content").width();return Math.floor(available_width/COLUMN_WIDTH)}function updateGridWidth(newCols){(void 0===newCols||MIN_COLUMNS>newCols)&&(newCols=MIN_COLUMNS);var max_columns=getMaxDisplayableColumnCount();newCols>max_columns&&(newCols=max_columns);var new_width=COLUMN_WIDTH*newCols+newCols;return $(".responsive-column-width").css("max-width",new_width),newCols===grid.cols?!1:!0}function repositionGrid(repositionFunction){var rootElement=grid.$el;rootElement.find("> li").unbind().removeData(),$(".responsive-column-width").css("width",""),grid.generate_grid_and_stylesheet(),rootElement.find("> li").each(repositionFunction),grid.init(),$(".responsive-column-width").css("width",grid.cols*PANE_WIDTH+grid.cols*PANE_MARGIN*2)}function getUserColumns(){return userColumns}function setUserColumns(numCols){userColumns=Math.max(MIN_COLUMNS,numCols)}function addPane(element,viewModel,isEditing){var position=getPositionForScreenSize(viewModel),col=position.col,row=position.row,width=Number(viewModel.width()),height=Number(viewModel.getCalculatedHeight());grid.add_widget(element,width,height,col,row),isEditing&&showPaneEditIcons(!0),updatePositionForScreenSize(viewModel,row,col),$(element).attrchange({trackValues:!0,callback:function(event){"data-row"==event.attributeName?updatePositionForScreenSize(viewModel,Number(event.newValue),void 0):"data-col"==event.attributeName&&updatePositionForScreenSize(viewModel,void 0,Number(event.newValue))}})}function updatePane(element,viewModel){var calculatedHeight=viewModel.getCalculatedHeight(),elementHeight=Number($(element).attr("data-sizey")),elementWidth=Number($(element).attr("data-sizex"));(calculatedHeight!=elementHeight||viewModel.col_width()!=elementWidth)&&grid.resize_widget($(element),viewModel.col_width(),calculatedHeight,function(){grid.set_dom_grid_height()})}function updatePositionForScreenSize(paneModel,row,col){var displayCols=grid.cols;_.isUndefined(row)||(paneModel.row[displayCols]=row),_.isUndefined(col)||(paneModel.col[displayCols]=col)}function showLoadingIndicator(show){show?loadingIndicator.fadeOut(0).appendTo("body").fadeIn(500):loadingIndicator.fadeOut(500).remove()}function showPaneEditIcons(show,animate){_.isUndefined(animate)&&(animate=!0);var animateLength=animate?250:0;show?($(".pane-tools").fadeIn(animateLength),$("#column-tools").fadeIn(animateLength)):($(".pane-tools").fadeOut(animateLength),$("#column-tools").fadeOut(animateLength))}function attachWidgetEditIcons(element){$(element).hover(function(){showWidgetEditIcons(this,!0)},function(){showWidgetEditIcons(this,!1)})}function showWidgetEditIcons(element,show){show?$(element).find(".sub-section-tools").fadeIn(250):$(element).find(".sub-section-tools").fadeOut(250)}function getPositionForScreenSize(paneModel){var cols=grid.cols;if(_.isNumber(paneModel.row)&&_.isNumber(paneModel.col)){var obj={};obj[cols]=paneModel.row,paneModel.row=obj,obj={},obj[cols]=paneModel.col,paneModel.col=obj}var newColumnIndex=1,columnDiff=1e3;for(var columnIndex in paneModel.col){if(columnIndex==cols)return{row:paneModel.row[columnIndex],col:paneModel.col[columnIndex]};if(paneModel.col[columnIndex]>cols)newColumnIndex=cols;else{var delta=cols-columnIndex;columnDiff>delta&&(newColumnIndex=columnIndex,columnDiff=delta)}}return newColumnIndex in paneModel.col&&newColumnIndex in paneModel.row?{row:paneModel.row[newColumnIndex],col:paneModel.col[newColumnIndex]}:{row:1,col:newColumnIndex}}var grid,PANE_MARGIN=10,PANE_WIDTH=300,MIN_COLUMNS=3,COLUMN_WIDTH=PANE_MARGIN+PANE_WIDTH+PANE_MARGIN,userColumns=MIN_COLUMNS,loadingIndicator=$('<div class="wrapperloading"><div class="loading up" ></div><div class="loading down"></div></div>');return ko.bindingHandlers.grid={init:function(element){grid=$(element).gridster({widget_margins:[PANE_MARGIN,PANE_MARGIN],widget_base_dimensions:[PANE_WIDTH,10],resize:{enabled:!1,axes:"x"}}).data("gridster"),processResize(!1),grid.disable()}},{showLoadingIndicator:function(show){showLoadingIndicator(show)},showPaneEditIcons:function(show,animate){showPaneEditIcons(show,animate)},attachWidgetEditIcons:function(element){attachWidgetEditIcons(element)},getPositionForScreenSize:function(paneModel){return getPositionForScreenSize(paneModel)},processResize:function(layoutWidgets){processResize(layoutWidgets)},disableGrid:function(){grid.disable()},enableGrid:function(){grid.enable()},addPane:function(element,viewModel,isEditing){addPane(element,viewModel,isEditing)},updatePane:function(element,viewModel){updatePane(element,viewModel)},removePane:function(element){grid.remove_widget(element)},removeAllPanes:function(){grid.remove_all_widgets()},addGridColumnLeft:function(){addGridColumn(!0)},addGridColumnRight:function(){addGridColumn(!1)},subGridColumnLeft:function(){subtractGridColumn(!0)},subGridColumnRight:function(){subtractGridColumn(!1)},getUserColumns:function(){return getUserColumns()},setUserColumns:function(numCols){setUserColumns(numCols)}}}function PaneModel(theFreeboardModel,widgetPlugins){var self=this;this.title=ko.observable(),this.width=ko.observable(1),this.row={},this.col={},this.col_width=ko.observable(1),this.col_width.subscribe(function(){self.processSizeChange()}),this.widgets=ko.observableArray(),this.addWidget=function(widget){this.widgets.push(widget)},this.widgetCanMoveUp=function(widget){return self.widgets.indexOf(widget)>=1},this.widgetCanMoveDown=function(widget){var i=self.widgets.indexOf(widget);return i<self.widgets().length-1},this.moveWidgetUp=function(widget){if(self.widgetCanMoveUp(widget)){var i=self.widgets.indexOf(widget),array=self.widgets();self.widgets.splice(i-1,2,array[i],array[i-1])}},this.moveWidgetDown=function(widget){if(self.widgetCanMoveDown(widget)){var i=self.widgets.indexOf(widget),array=self.widgets();self.widgets.splice(i,2,array[i+1],array[i])}},this.processSizeChange=function(){setTimeout(function(){_.each(self.widgets(),function(widget){widget.processSizeChange()})},1e3)},this.getCalculatedHeight=function(){var sumHeights=_.reduce(self.widgets(),function(memo,widget){return memo+widget.height()},0);sumHeights*=6,sumHeights+=3,sumHeights*=10;var rows=Math.ceil((sumHeights+20)/30);return Math.max(4,rows)},this.serialize=function(){var widgets=[];return _.each(self.widgets(),function(widget){widgets.push(widget.serialize())}),{title:self.title(),width:self.width(),row:self.row,col:self.col,col_width:self.col_width(),widgets:widgets}},this.deserialize=function(object){self.title(object.title),self.width(object.width),self.row=object.row,self.col=object.col,self.col_width(object.col_width||1),_.each(object.widgets,function(widgetConfig){var widget=new WidgetModel(theFreeboardModel,widgetPlugins);widget.deserialize(widgetConfig),self.widgets.push(widget)})},this.dispose=function(){_.each(self.widgets(),function(widget){widget.dispose()})}}function WidgetModel(theFreeboardModel,widgetPlugins){function disposeWidgetInstance(){_.isUndefined(self.widgetInstance)||(_.isFunction(self.widgetInstance.onDispose)&&self.widgetInstance.onDispose(),self.widgetInstance=void 0)}var self=this;this.datasourceRefreshNotifications={},this.calculatedSettingScripts={},this.title=ko.observable(),this.fillSize=ko.observable(!1),this.type=ko.observable(),this.type.subscribe(function(newValue){function finishLoad(){widgetType.newInstance(self.settings(),function(widgetInstance){self.fillSize(widgetType.fill_size===!0),self.widgetInstance=widgetInstance,self.shouldRender(!0),self._heightUpdate.valueHasMutated()})}if(disposeWidgetInstance(),newValue in widgetPlugins&&_.isFunction(widgetPlugins[newValue].newInstance)){var widgetType=widgetPlugins[newValue];widgetType.external_scripts?head.js(widgetType.external_scripts.slice(0),finishLoad):finishLoad()}}),this.settings=ko.observable({}),this.settings.subscribe(function(newValue){!_.isUndefined(self.widgetInstance)&&_.isFunction(self.widgetInstance.onSettingsChanged)&&self.widgetInstance.onSettingsChanged(newValue),self.updateCalculatedSettings(),self._heightUpdate.valueHasMutated()}),this.processDatasourceUpdate=function(datasourceName){var refreshSettingNames=self.datasourceRefreshNotifications[datasourceName];_.isArray(refreshSettingNames)&&_.each(refreshSettingNames,function(settingName){self.processCalculatedSetting(settingName)})},this.callValueFunction=function(theFunction){return theFunction.call(void 0,theFreeboardModel.datasourceData)},this.processSizeChange=function(){!_.isUndefined(self.widgetInstance)&&_.isFunction(self.widgetInstance.onSizeChanged)&&self.widgetInstance.onSizeChanged()},this.processCalculatedSetting=function(settingName){if(_.isFunction(self.calculatedSettingScripts[settingName])){var returnValue=void 0;try{returnValue=self.callValueFunction(self.calculatedSettingScripts[settingName])}catch(e){var rawValue=self.settings()[settingName];e instanceof ReferenceError&&/^\w+$/.test(rawValue)&&(returnValue=rawValue)}if(!_.isUndefined(self.widgetInstance)&&_.isFunction(self.widgetInstance.onCalculatedValueChanged)&&!_.isUndefined(returnValue))try{self.widgetInstance.onCalculatedValueChanged(settingName,returnValue)}catch(e){console.log(e.toString())}}},this.updateCalculatedSettings=function(){if(self.datasourceRefreshNotifications={},self.calculatedSettingScripts={},!_.isUndefined(self.type())){var settingsDefs=widgetPlugins[self.type()].settings,datasourceRegex=new RegExp("datasources.([\\w_-]+)|datasources\\[['\"]([^'\"]+)","g"),currentSettings=self.settings();_.each(settingsDefs,function(settingDef){if("calculated"==settingDef.type){var script=currentSettings[settingDef.name];if(!_.isUndefined(script)){_.isArray(script)&&(script="["+script.join(",")+"]"),(script.match(/;/g)||[]).length<=1&&-1==script.indexOf("return")&&(script="return "+script);var valueFunction;try{valueFunction=new Function("datasources",script)}catch(e){var literalText=currentSettings[settingDef.name].replace(/"/g,'\\"').replace(/[\r\n]/g," \\\n");valueFunction=new Function("datasources",'return "'+literalText+'";')}self.calculatedSettingScripts[settingDef.name]=valueFunction,self.processCalculatedSetting(settingDef.name);for(var matches;matches=datasourceRegex.exec(script);){var dsName=matches[1]||matches[2],refreshSettingNames=self.datasourceRefreshNotifications[dsName];_.isUndefined(refreshSettingNames)&&(refreshSettingNames=[],self.datasourceRefreshNotifications[dsName]=refreshSettingNames),-1==_.indexOf(refreshSettingNames,settingDef.name)&&refreshSettingNames.push(settingDef.name)}}}})}},this._heightUpdate=ko.observable(),this.height=ko.computed({read:function(){return self._heightUpdate(),!_.isUndefined(self.widgetInstance)&&_.isFunction(self.widgetInstance.getHeight)?self.widgetInstance.getHeight():1}}),this.shouldRender=ko.observable(!1),this.render=function(element){self.shouldRender(!1),!_.isUndefined(self.widgetInstance)&&_.isFunction(self.widgetInstance.render)&&(self.widgetInstance.render(element),self.updateCalculatedSettings())},this.dispose=function(){},this.serialize=function(){return{title:self.title(),type:self.type(),settings:self.settings()}},this.deserialize=function(object){self.title(object.title),self.settings(object.settings),self.type(object.type)}}DatasourceModel=function(theFreeboardModel,datasourcePlugins){function disposeDatasourceInstance(){_.isUndefined(self.datasourceInstance)||(_.isFunction(self.datasourceInstance.onDispose)&&self.datasourceInstance.onDispose(),self.datasourceInstance=void 0)}var self=this;this.name=ko.observable(),this.latestData=ko.observable(),this.settings=ko.observable({}),this.settings.subscribe(function(newValue){!_.isUndefined(self.datasourceInstance)&&_.isFunction(self.datasourceInstance.onSettingsChanged)&&self.datasourceInstance.onSettingsChanged(newValue)}),this.updateCallback=function(newData){theFreeboardModel.processDatasourceUpdate(self,newData),self.latestData(newData);var now=new Date;self.last_updated(now.toLocaleTimeString())},this.type=ko.observable(),this.type.subscribe(function(newValue){function finishLoad(){datasourceType.newInstance(self.settings(),function(datasourceInstance){self.datasourceInstance=datasourceInstance,datasourceInstance.updateNow()},self.updateCallback)}if(disposeDatasourceInstance(),newValue in datasourcePlugins&&_.isFunction(datasourcePlugins[newValue].newInstance)){var datasourceType=datasourcePlugins[newValue];datasourceType.external_scripts?head.js(datasourceType.external_scripts.slice(0),finishLoad):finishLoad()}}),this.last_updated=ko.observable("never"),this.last_error=ko.observable(),this.serialize=function(){return{name:self.name(),type:self.type(),settings:self.settings()}},this.deserialize=function(object){self.settings(object.settings),self.name(object.name),self.type(object.type)},this.getDataRepresentation=function(dataPath){var valueFunction=new Function("data","return "+dataPath+";");return valueFunction.call(void 0,self.latestData())},this.updateNow=function(){!_.isUndefined(self.datasourceInstance)&&_.isFunction(self.datasourceInstance.updateNow)&&self.datasourceInstance.updateNow()},this.dispose=function(){disposeDatasourceInstance()}},DeveloperConsole=function(theFreeboardModel){function showDeveloperConsole(){function addNewScriptRow(scriptURL){var tableRow=$("<tr></tr>"),tableOperations=$('<ul class="board-toolbar"></ul>'),scriptInput=$('<input class="table-row-value" style="width:100%;" type="text">'),deleteOperation=$('<li><i class="icon-trash icon-white"></i></li>').click(function(){pluginScriptsInputs=_.without(pluginScriptsInputs,scriptInput),tableRow.remove()});pluginScriptsInputs.push(scriptInput),scriptURL&&scriptInput.val(scriptURL),tableOperations.append(deleteOperation),tableBody.append(tableRow.append($("<td></td>").append(scriptInput)).append($('<td class="table-row-operation">').append(tableOperations)))}var pluginScriptsInputs=[],container=$("<div></div>"),addScript=$('<div class="table-operation text-button">ADD</div>'),table=$('<table class="table table-condensed sub-table"></table>');table.append($('<thead style=""><tr><th>Plugin Script URL</th></tr></thead>'));var tableBody=$("<tbody></tbody>");table.append(tableBody),container.append($("<p>Here you can add references to other scripts to load datasource or widget plugins.</p>")).append(table).append(addScript).append('<p>To learn how to build plugins for freeboard, please visit <a target="_blank" href="http://freeboard.github.io/freeboard/docs/plugin_example.html">http://freeboard.github.io/freeboard/docs/plugin_example.html</a></p>'),_.each(theFreeboardModel.plugins(),function(pluginSource){addNewScriptRow(pluginSource)}),addScript.click(function(){addNewScriptRow()}),new DialogBox(container,"Developer Console","OK",null,function(){_.each(theFreeboardModel.plugins(),function(pluginSource){$('script[src^="'+pluginSource+'"]').remove()}),theFreeboardModel.plugins.removeAll(),_.each(pluginScriptsInputs,function(scriptInput){var scriptURL=scriptInput.val();scriptURL&&scriptURL.length>0&&(theFreeboardModel.addPluginSource(scriptURL),head.js(scriptURL+"?"+Date.now()))})})}return{showDeveloperConsole:function(){showDeveloperConsole()}}},JSEditor=function(){function setAssetRoot(_assetRoot){assetRoot=_assetRoot}function displayJSEditor(value,callback){var exampleText='// Example: Convert temp from C to F and truncate to 2 decimal places.\n// return (datasources["MyDatasource"].sensor.tempInF * 1.8 + 32).toFixed(2);';value||(value=exampleText);var codeWindow=$('<div class="code-window"></div>'),codeMirrorWrapper=$('<div class="code-mirror-wrapper"></div>'),codeWindowFooter=$('<div class="code-window-footer"></div>'),codeWindowHeader=$('<div class="code-window-header cm-s-ambiance">This javascript will be re-evaluated any time a datasource referenced here is updated, and the value you <code><span class="cm-keyword">return</span></code> will be displayed in the widget. You can assume this javascript is wrapped in a function of the form <code><span class="cm-keyword">function</span>(<span class="cm-def">datasources</span>)</code> where datasources is a collection of javascript objects (keyed by their name) corresponding to the most current data in a datasource.</div>');codeWindow.append([codeWindowHeader,codeMirrorWrapper,codeWindowFooter]),$("body").append(codeWindow);var codeMirrorEditor=CodeMirror(codeMirrorWrapper.get(0),{value:value,mode:"javascript",theme:"ambiance",indentUnit:4,lineNumbers:!0,matchBrackets:!0,autoCloseBrackets:!0}),closeButton=$('<span id="dialog-cancel" class="text-button">Close</span>').click(function(){if(callback){var newValue=codeMirrorEditor.getValue();newValue===exampleText&&(newValue=""),callback(newValue),codeWindow.remove()}});codeWindowFooter.append(closeButton)}var assetRoot="";return{displayJSEditor:function(value,callback){displayJSEditor(value,callback)},setAssetRoot:function(assetRoot){setAssetRoot(assetRoot)}}},PluginEditor=function(jsEditor,valueEditor){function _displayValidationError(settingName,errorMessage){var errorElement=$('<div class="validation-error"></div>').html(errorMessage);$("#setting-value-container-"+settingName).append(errorElement)}function _removeSettingsRows(){$("#setting-row-instance-name").length?$("#setting-row-instance-name").nextAll().remove():$("#setting-row-plugin-types").nextAll().remove()}function _isNumerical(n){return!isNaN(parseFloat(n))&&isFinite(n)}function _appendCalculatedSettingRow(valueCell,newSettings,settingDef,currentValue,includeRemove){var input=$("<textarea></textarea>");input.change(settingDef.multi_input?function(){var arrayInput=[];$(valueCell).find("textarea").each(function(){var thisVal=$(this).val();thisVal&&(arrayInput=arrayInput.concat(thisVal))}),newSettings.settings[settingDef.name]=arrayInput}:function(){newSettings.settings[settingDef.name]=$(this).val()}),currentValue&&input.val(currentValue),valueEditor.createValueEditor(input);var datasourceToolbox=$('<ul class="board-toolbar datasource-input-suffix"></ul>'),wrapperDiv=$('<div class="calculated-setting-row"></div>');wrapperDiv.append(input).append(datasourceToolbox);var datasourceTool=$('<li><i class="icon-plus icon-white"></i><label>DATASOURCE</label></li>').mousedown(function(e){e.preventDefault(),$(input).val("").focus().insertAtCaret('datasources["').trigger("freeboard-eval")});datasourceToolbox.append(datasourceTool);var jsEditorTool=$('<li><i class="icon-fullscreen icon-white"></i><label>.JS EDITOR</label></li>').mousedown(function(e){e.preventDefault(),jsEditor.displayJSEditor(input.val(),function(result){input.val(result),input.change()})});if(datasourceToolbox.append(jsEditorTool),includeRemove){var removeButton=$('<li class="remove-setting-row"><i class="icon-minus icon-white"></i><label></label></li>').mousedown(function(e){e.preventDefault(),wrapperDiv.remove(),$(valueCell).find("textarea:first").change()});datasourceToolbox.prepend(removeButton)}$(valueCell).append(wrapperDiv)}function createPluginEditor(title,pluginTypes,currentTypeName,currentSettingsValues,settingsSavedCallback){function createSettingRow(name,displayName){var tr=$('<div id="setting-row-'+name+'" class="form-row"></div>').appendTo(form);return tr.append('<div class="form-label"><label class="control-label">'+displayName+"</label></div>"),$('<div id="setting-value-container-'+name+'" class="form-value"></div>').appendTo(tr)}function createSettingsFromDefinition(settingsDefs,typeaheadSource,typeaheadDataSegment){_.each(settingsDefs,function(settingDef){function processHeaderVisibility(){newSettings.settings[settingDef.name].length>0?subTableHead.show():subTableHead.hide()}function createSubsettingRow(subsettingValue){var subsettingRow=$("<tr></tr>").appendTo(subTableBody),newSetting={};_.isArray(newSettings.settings[settingDef.name])||(newSettings.settings[settingDef.name]=[]),newSettings.settings[settingDef.name].push(newSetting),_.each(settingDef.settings,function(subSettingDef){var subsettingCol=$("<td></td>").appendTo(subsettingRow),subsettingValueString="";_.isUndefined(subsettingValue[subSettingDef.name])||(subsettingValueString=subsettingValue[subSettingDef.name]),newSetting[subSettingDef.name]=subsettingValueString,$('<input class="table-row-value" type="text">').appendTo(subsettingCol).val(subsettingValueString).change(function(){newSetting[subSettingDef.name]=$(this).val()})}),subsettingRow.append($('<td class="table-row-operation"></td>').append($('<ul class="board-toolbar"></ul>').append($("<li></li>").append($('<i class="icon-trash icon-white"></i>').click(function(){var subSettingIndex=newSettings.settings[settingDef.name].indexOf(newSetting);-1!=subSettingIndex&&(newSettings.settings[settingDef.name].splice(subSettingIndex,1),subsettingRow.remove(),processHeaderVisibility())}))))),subTableDiv.scrollTop(subTableDiv[0].scrollHeight),processHeaderVisibility()}!_.isUndefined(settingDef.default_value)&&_.isUndefined(currentSettingsValues[settingDef.name])&&(currentSettingsValues[settingDef.name]=settingDef.default_value);var displayName=settingDef.name;_.isUndefined(settingDef.display_name)||(displayName=settingDef.display_name);var valueCell=createSettingRow(settingDef.name,displayName);switch(settingDef.type){case"array":var subTableDiv=$('<div class="form-table-value-subtable"></div>').appendTo(valueCell),subTable=$('<table class="table table-condensed sub-table"></table>').appendTo(subTableDiv),subTableHead=$("<thead></thead>").hide().appendTo(subTable),subTableHeadRow=$("<tr></tr>").appendTo(subTableHead),subTableBody=$("<tbody></tbody>").appendTo(subTable),currentSubSettingValues=[];_.each(settingDef.settings,function(subSettingDef){var subsettingDisplayName=subSettingDef.name;_.isUndefined(subSettingDef.display_name)||(subsettingDisplayName=subSettingDef.display_name),$("<th>"+subsettingDisplayName+"</th>").appendTo(subTableHeadRow)}),settingDef.name in currentSettingsValues&&(currentSubSettingValues=currentSettingsValues[settingDef.name]),$('<div class="table-operation text-button">ADD</div>').appendTo(valueCell).click(function(){var newSubsettingValue={};
_.each(settingDef.settings,function(subSettingDef){newSubsettingValue[subSettingDef.name]=""}),createSubsettingRow(newSubsettingValue)}),_.each(currentSubSettingValues,function(currentSubSettingValue){createSubsettingRow(currentSubSettingValue)});break;case"boolean":newSettings.settings[settingDef.name]=currentSettingsValues[settingDef.name];var onOffSwitch=$('<div class="onoffswitch"><label class="onoffswitch-label" for="'+settingDef.name+'-onoff"><div class="onoffswitch-inner"><span class="on">YES</span><span class="off">NO</span></div><div class="onoffswitch-switch"></div></label></div>').appendTo(valueCell),input=$('<input type="checkbox" name="onoffswitch" class="onoffswitch-checkbox" id="'+settingDef.name+'-onoff">').prependTo(onOffSwitch).change(function(){newSettings.settings[settingDef.name]=this.checked});settingDef.name in currentSettingsValues&&input.prop("checked",currentSettingsValues[settingDef.name]);break;case"option":var defaultValue=currentSettingsValues[settingDef.name],input=$("<select></select>").appendTo($('<div class="styled-select"></div>').appendTo(valueCell)).change(function(){newSettings.settings[settingDef.name]=$(this).val()});_.each(settingDef.options,function(option){var optionName,optionValue;_.isObject(option)?(optionName=option.name,optionValue=option.value):optionName=option,_.isUndefined(optionValue)&&(optionValue=optionName),_.isUndefined(defaultValue)&&(defaultValue=optionValue),$("<option></option>").text(optionName).attr("value",optionValue).appendTo(input)}),newSettings.settings[settingDef.name]=defaultValue,settingDef.name in currentSettingsValues&&input.val(currentSettingsValues[settingDef.name]);break;default:if(newSettings.settings[settingDef.name]=currentSettingsValues[settingDef.name],"calculated"==settingDef.type){if(settingDef.name in currentSettingsValues){var currentValue=currentSettingsValues[settingDef.name];if(settingDef.multi_input&&_.isArray(currentValue))for(var includeRemove=!1,i=0;i<currentValue.length;i++)_appendCalculatedSettingRow(valueCell,newSettings,settingDef,currentValue[i],includeRemove),includeRemove=!0;else _appendCalculatedSettingRow(valueCell,newSettings,settingDef,currentValue,!1)}else _appendCalculatedSettingRow(valueCell,newSettings,settingDef,null,!1);if(settingDef.multi_input){var inputAdder=$('<ul class="board-toolbar"><li class="add-setting-row"><i class="icon-plus icon-white"></i><label>ADD</label></li></ul>').mousedown(function(e){e.preventDefault(),_appendCalculatedSettingRow(valueCell,newSettings,settingDef,null,!0)});$(valueCell).siblings(".form-label").append(inputAdder)}}else{var input=$('<input type="text">').appendTo(valueCell).change(function(){newSettings.settings[settingDef.name]="number"==settingDef.type?Number($(this).val()):$(this).val()});if(settingDef.name in currentSettingsValues&&input.val(currentSettingsValues[settingDef.name]),typeaheadSource&&settingDef.typeahead_data_field&&input.addClass("typeahead_data_field-"+settingDef.typeahead_data_field),typeaheadSource&&settingDef.typeahead_field){var typeaheadValues=[];input.keyup(function(event){event.which>=65&&event.which<=91&&input.trigger("change")}),$(input).autocomplete({source:typeaheadValues,select:function(event,ui){input.val(ui.item.value),input.trigger("change")}}),input.change(function(){var value=input.val(),source=_.template(typeaheadSource)({input:value});$.get(source,function(data){if(typeaheadDataSegment&&(data=data[typeaheadDataSegment]),data=_.select(data,function(elm){return elm[settingDef.typeahead_field][0]==value[0]}),typeaheadValues=_.map(data,function(elm){return elm[settingDef.typeahead_field]}),$(input).autocomplete("option","source",typeaheadValues),1==data.length){data=data[0];for(var field in data)if(data.hasOwnProperty(field)){var otherInput=$(_.template("input.typeahead_data_field-<%= field %>")({field:field}));otherInput&&(otherInput.val(data[field]),otherInput.val()!=input.val()&&otherInput.trigger("change"))}}})})}}}_.isUndefined(settingDef.suffix)||valueCell.append($('<div class="input-suffix">'+settingDef.suffix+"</div>")),_.isUndefined(settingDef.description)||valueCell.append($('<div class="setting-description">'+settingDef.description+"</div>"))})}var selectedType,newSettings={type:currentTypeName,settings:{}},form=$("<div></div>"),pluginDescriptionElement=$('<div id="plugin-description"></div>').hide();form.append(pluginDescriptionElement),new DialogBox(form,title,"Save","Cancel",function(){$(".validation-error").remove();for(var index=0;index<selectedType.settings.length;index++){var settingDef=selectedType.settings[index];if(settingDef.required&&(_.isUndefined(newSettings.settings[settingDef.name])||""==newSettings.settings[settingDef.name]))return _displayValidationError(settingDef.name,"This is required."),!0;if("number"==settingDef.type&&!_isNumerical(newSettings.settings[settingDef.name]))return _displayValidationError(settingDef.name,"Must be a number."),!0}_.isFunction(settingsSavedCallback)&&settingsSavedCallback(newSettings)});var typeSelect,pluginTypeNames=_.keys(pluginTypes);if(pluginTypeNames.length>1){var typeRow=createSettingRow("plugin-types","Type");typeSelect=$("<select></select>").appendTo($('<div class="styled-select"></div>').appendTo(typeRow)),typeSelect.append($("<option>Select a type...</option>").attr("value","undefined")),_.each(pluginTypes,function(pluginType){typeSelect.append($("<option></option>").text(pluginType.display_name).attr("value",pluginType.type_name))}),typeSelect.change(function(){newSettings.type=$(this).val(),newSettings.settings={},_removeSettingsRows(),selectedType=pluginTypes[typeSelect.val()],_.isUndefined(selectedType)?($("#setting-row-instance-name").hide(),$("#dialog-ok").hide()):($("#setting-row-instance-name").show(),selectedType.description&&selectedType.description.length>0?pluginDescriptionElement.html(selectedType.description).show():pluginDescriptionElement.hide(),$("#dialog-ok").show(),createSettingsFromDefinition(selectedType.settings,selectedType.typeahead_source,selectedType.typeahead_data_segment))})}else 1==pluginTypeNames.length&&(selectedType=pluginTypes[pluginTypeNames[0]],newSettings.type=selectedType.type_name,newSettings.settings={},createSettingsFromDefinition(selectedType.settings));typeSelect&&(_.isUndefined(currentTypeName)?($("#setting-row-instance-name").hide(),$("#dialog-ok").hide()):($("#dialog-ok").show(),typeSelect.val(currentTypeName).trigger("change")))}return{createPluginEditor:function(title,pluginTypes,currentInstanceName,currentTypeName,currentSettingsValues,settingsSavedCallback){createPluginEditor(title,pluginTypes,currentInstanceName,currentTypeName,currentSettingsValues,settingsSavedCallback)}}},ValueEditor=function(theFreeboardModel){function _isPotentialTypeMatch(value,expectsType){return _.isArray(value)||_.isObject(value)?!0:_isTypeMatch(value,expectsType)}function _isTypeMatch(value,expectsType){switch(expectsType){case EXPECTED_TYPE.ANY:return!0;case EXPECTED_TYPE.ARRAY:return _.isArray(value);case EXPECTED_TYPE.OBJECT:return _.isObject(value);case EXPECTED_TYPE.STRING:return _.isString(value);case EXPECTED_TYPE.NUMBER:return _.isNumber(value);case EXPECTED_TYPE.BOOLEAN:return _.isBoolean(value)}}function _checkCurrentValueType(element,expectsType){$(element).parent().find(".validation-error").remove(),_isTypeMatch(currentValue,expectsType)||$(element).parent().append("<div class='validation-error'>This field expects an expression that evaluates to type "+expectsType+".</div>")}function _resizeValueEditor(element){var lineBreakCount=($(element).val().match(/\n/g)||[]).length,newHeight=Math.min(200,20*(lineBreakCount+1));$(element).css({height:newHeight+"px"})}function _autocompleteFromDatasource(inputString,datasources,expectsType){var match=_veDatasourceRegex.exec(inputString),options=[];if(match)if(""==match[1])_.each(datasources,function(datasource){options.push({value:datasource.name(),entity:void 0,precede_char:"",follow_char:'"]'})});else if(""!=match[1]&&_.isUndefined(match[2])){var replacementString=match[1];_.each(datasources,function(datasource){var dsName=datasource.name();dsName!=replacementString&&0==dsName.indexOf(replacementString)&&options.push({value:dsName,entity:void 0,precede_char:"",follow_char:'"]'})})}else{var datasource=_.find(datasources,function(datasource){return datasource.name()===match[1]});if(!_.isUndefined(datasource)){var dataPath="data",remainder="";if(!_.isUndefined(match[2])){var remainderIndex=match[3].lastIndexOf("]")+1;dataPath+=match[3].substring(0,remainderIndex),remainder=match[3].substring(remainderIndex,match[3].length),remainder=remainder.replace(/^[\[\"]*/,""),remainder=remainder.replace(/[\"\]]*$/,"")}var dataValue=datasource.getDataRepresentation(dataPath);if(currentValue=dataValue,_.isArray(dataValue)){for(var index=0;index<dataValue.length;index++)if(0==index.toString().indexOf(remainder)){var value=dataValue[index];_isPotentialTypeMatch(value,expectsType)&&options.push({value:index,entity:value,precede_char:"[",follow_char:"]",preview:value.toString()})}}else _.isObject(dataValue)&&_.each(dataValue,function(value,name){0==name.indexOf(remainder)&&_isPotentialTypeMatch(value,expectsType)&&options.push({value:name,entity:value,precede_char:'["',follow_char:'"]'})})}}_autocompleteOptions=options}function _renderAutocompleteDropdown(element,expectsType){var inputString=$(element).val().substring(0,$(element).getCaretPosition());if(inputString=inputString.replace(String.fromCharCode(160)," "),_autocompleteFromDatasource(inputString,theFreeboardModel.datasources(),expectsType),_autocompleteOptions.length>0){dropdown||(dropdown=$('<ul id="value-selector" class="value-dropdown"></ul>').insertAfter(element).width($(element).outerWidth()-2).css("left",$(element).position().left).css("top",$(element).position().top+$(element).outerHeight()-1)),dropdown.empty(),dropdown.scrollTop(0);var selected=!0;selectedOptionIndex=0,_.each(_autocompleteOptions,function(option,index){var li=_renderAutocompleteDropdownOption(element,inputString,option,index);selected&&($(li).addClass("selected"),selected=!1)})}else _checkCurrentValueType(element,expectsType),$(element).next("ul#value-selector").remove(),dropdown=null,selectedOptionIndex=-1}function _renderAutocompleteDropdownOption(element,inputString,option,currentIndex){var optionLabel=option.value;option.preview&&(optionLabel=optionLabel+"<span class='preview'>"+option.preview+"</span>");var li=$("<li>"+optionLabel+"</li>").appendTo(dropdown).mouseenter(function(){$(this).trigger("freeboard-select")}).mousedown(function(event){$(this).trigger("freeboard-insertValue"),event.preventDefault()}).data("freeboard-optionIndex",currentIndex).data("freeboard-optionValue",option.value).bind("freeboard-insertValue",function(){var optionValue=option.value;optionValue=option.precede_char+optionValue+option.follow_char;var replacementIndex=inputString.lastIndexOf("]");-1!=replacementIndex?$(element).replaceTextAt(replacementIndex+1,$(element).val().length,optionValue):$(element).insertAtCaret(optionValue),currentValue=option.entity,$(element).triggerHandler("mouseup")}).bind("freeboard-select",function(){$(this).parent().find("li.selected").removeClass("selected"),$(this).addClass("selected"),selectedOptionIndex=$(this).data("freeboard-optionIndex")});return li}function createValueEditor(element,expectsType){$(element).addClass("calculated-value-input").bind("keyup mouseup freeboard-eval",function(event){return!dropdown||"keyup"!=event.type||38!=event.keyCode&&40!=event.keyCode&&13!=event.keyCode?void _renderAutocompleteDropdown(element,expectsType):void event.preventDefault()}).focus(function(){$(element).css({"z-index":3001}),_resizeValueEditor(element)}).focusout(function(){_checkCurrentValueType(element,expectsType),$(element).css({height:"","z-index":3e3}),$(element).next("ul#value-selector").remove(),dropdown=null,selectedOptionIndex=-1}).bind("keydown",function(event){if(dropdown)if(38==event.keyCode||40==event.keyCode){event.preventDefault();var optionItems=$(dropdown).find("li");38==event.keyCode?selectedOptionIndex--:40==event.keyCode&&selectedOptionIndex++,0>selectedOptionIndex?selectedOptionIndex=optionItems.size()-1:selectedOptionIndex>=optionItems.size()&&(selectedOptionIndex=0);var optionElement=$(optionItems).eq(selectedOptionIndex);optionElement.trigger("freeboard-select"),$(dropdown).scrollTop($(optionElement).position().top)}else 13==event.keyCode&&(event.preventDefault(),-1!=selectedOptionIndex&&$(dropdown).find("li").eq(selectedOptionIndex).trigger("freeboard-insertValue"))})}var _veDatasourceRegex=new RegExp('.*datasources\\["([^"]*)("\\])?(.*)$'),dropdown=null,selectedOptionIndex=0,_autocompleteOptions=[],currentValue=null,EXPECTED_TYPE={ANY:"any",ARRAY:"array",OBJECT:"object",STRING:"string",NUMBER:"number",BOOLEAN:"boolean"};return{createValueEditor:function(element,expectsType){expectsType?createValueEditor(element,expectsType):createValueEditor(element,EXPECTED_TYPE.ANY)},EXPECTED_TYPE:EXPECTED_TYPE}},function($){function isDOMAttrModifiedSupported(){var p=document.createElement("p"),flag=!1;if(p.addEventListener)p.addEventListener("DOMAttrModified",function(){flag=!0},!1);else{if(!p.attachEvent)return!1;p.attachEvent("onDOMAttrModified",function(){flag=!0})}return p.setAttribute("id","target"),flag}function checkAttributes(chkAttr,e){if(chkAttr){var attributes=this.data("attr-old-value");if(e.attributeName.indexOf("style")>=0){attributes.style||(attributes.style={});var keys=e.attributeName.split(".");e.attributeName=keys[0],e.oldValue=attributes.style[keys[1]],e.newValue=keys[1]+":"+this.prop("style")[$.camelCase(keys[1])],attributes.style[keys[1]]=e.newValue}else e.oldValue=attributes[e.attributeName],e.newValue=this.attr(e.attributeName),attributes[e.attributeName]=e.newValue;this.data("attr-old-value",attributes)}}var MutationObserver=window.MutationObserver||window.WebKitMutationObserver;$.fn.attrchange=function(o){var cfg={trackValues:!1,callback:$.noop};if("function"==typeof o?cfg.callback=o:$.extend(cfg,o),cfg.trackValues&&$(this).each(function(i,el){for(var attr,attributes={},i=0,attrs=el.attributes,l=attrs.length;l>i;i++)attr=attrs.item(i),attributes[attr.nodeName]=attr.value;$(this).data("attr-old-value",attributes)}),MutationObserver){var mOptions={subtree:!1,attributes:!0,attributeOldValue:cfg.trackValues},observer=new MutationObserver(function(mutations){mutations.forEach(function(e){var _this=e.target;cfg.trackValues&&(e.newValue=$(_this).attr(e.attributeName)),cfg.callback.call(_this,e)})});return this.each(function(){observer.observe(this,mOptions)})}return isDOMAttrModifiedSupported()?this.on("DOMAttrModified",function(event){event.originalEvent&&(event=event.originalEvent),event.attributeName=event.attrName,event.oldValue=event.prevValue,cfg.callback.call(this,event)}):"onpropertychange"in document.body?this.on("propertychange",function(e){e.attributeName=window.event.propertyName,checkAttributes.call($(this),cfg.trackValues,e),cfg.callback.call(this,e)}):this}}(jQuery),function(jQuery){jQuery.eventEmitter={_JQInit:function(){this._JQ=jQuery(this)},emit:function(evt,data){!this._JQ&&this._JQInit(),this._JQ.trigger(evt,data)},once:function(evt,handler){!this._JQ&&this._JQInit(),this._JQ.one(evt,handler)},on:function(evt,handler){!this._JQ&&this._JQInit(),this._JQ.bind(evt,handler)},off:function(evt,handler){!this._JQ&&this._JQInit(),this._JQ.unbind(evt,handler)}}}(jQuery);var freeboard=function(){function getParameterByName(name){name=name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var regex=new RegExp("[\\?&]"+name+"=([^&#]*)"),results=regex.exec(location.search);return null==results?"":decodeURIComponent(results[1].replace(/\+/g," "))}var datasourcePlugins={},widgetPlugins={},freeboardUI=new FreeboardUI,theFreeboardModel=new FreeboardModel(datasourcePlugins,widgetPlugins,freeboardUI),jsEditor=new JSEditor,valueEditor=new ValueEditor(theFreeboardModel),pluginEditor=new PluginEditor(jsEditor,valueEditor),developerConsole=new DeveloperConsole(theFreeboardModel),currentStyle={values:{"font-family":'"HelveticaNeue-UltraLight", "Helvetica Neue Ultra Light", "Helvetica Neue", sans-serif',color:"#d3d4d4","font-weight":100}};return ko.bindingHandlers.pluginEditor={init:function(element,valueAccessor,allBindingsAccessor,viewModel){var options=ko.unwrap(valueAccessor()),types={},settings=void 0,title="";"datasource"==options.type?(types=datasourcePlugins,title="Datasource"):"widget"==options.type?(types=widgetPlugins,title="Widget"):"pane"==options.type&&(title="Pane"),$(element).click(function(){if("delete"==options.operation){var phraseElement=$("<p>Are you sure you want to delete this "+title+"?</p>");new DialogBox(phraseElement,"Confirm Delete","Yes","No",function(){"datasource"==options.type?theFreeboardModel.deleteDatasource(viewModel):"widget"==options.type?theFreeboardModel.deleteWidget(viewModel):"pane"==options.type&&theFreeboardModel.deletePane(viewModel)})}else{var instanceType=void 0;"datasource"==options.type?"add"==options.operation?settings={}:(instanceType=viewModel.type(),settings=viewModel.settings(),settings.name=viewModel.name()):"widget"==options.type?"add"==options.operation?settings={}:(instanceType=viewModel.type(),settings=viewModel.settings()):"pane"==options.type&&(settings={},"edit"==options.operation&&(settings.title=viewModel.title(),settings.col_width=viewModel.col_width()),types={settings:{settings:[{name:"title",display_name:"Title",type:"text"},{name:"col_width",display_name:"Columns",type:"number",default_value:1,required:!0}]}}),pluginEditor.createPluginEditor(title,types,instanceType,settings,function(newSettings){if("add"==options.operation){if("datasource"==options.type){var newViewModel=new DatasourceModel(theFreeboardModel,datasourcePlugins);theFreeboardModel.addDatasource(newViewModel),newViewModel.name(newSettings.settings.name),delete newSettings.settings.name,newViewModel.settings(newSettings.settings),newViewModel.type(newSettings.type)}else if("widget"==options.type){var newViewModel=new WidgetModel(theFreeboardModel,widgetPlugins);newViewModel.settings(newSettings.settings),newViewModel.type(newSettings.type),viewModel.widgets.push(newViewModel),freeboardUI.attachWidgetEditIcons(element)}}else"edit"==options.operation&&("pane"==options.type?(viewModel.title(newSettings.settings.title),viewModel.col_width(newSettings.settings.col_width),freeboardUI.processResize(!1)):("datasource"==options.type&&(viewModel.name(newSettings.settings.name),delete newSettings.settings.name),viewModel.type(newSettings.type),viewModel.settings(newSettings.settings)))})}})}},ko.virtualElements.allowedBindings.datasourceTypeSettings=!0,ko.bindingHandlers.datasourceTypeSettings={update:function(element,valueAccessor,allBindingsAccessor,viewModel,bindingContext){processPluginSettings(element,valueAccessor,allBindingsAccessor,viewModel,bindingContext)}},ko.bindingHandlers.pane={init:function(element,valueAccessor,allBindingsAccessor,viewModel,bindingContext){theFreeboardModel.isEditing()&&$(element).css({cursor:"pointer"}),freeboardUI.addPane(element,viewModel,bindingContext.$root.isEditing())},update:function(element,valueAccessor,allBindingsAccessor,viewModel){-1==theFreeboardModel.panes.indexOf(viewModel)&&freeboardUI.removePane(element),freeboardUI.updatePane(element,viewModel)}},ko.bindingHandlers.widget={init:function(element){theFreeboardModel.isEditing()&&freeboardUI.attachWidgetEditIcons($(element).parent())},update:function(element,valueAccessor,allBindingsAccessor,viewModel){viewModel.shouldRender()&&($(element).empty(),viewModel.render(element))}},$(function(){function resizeEnd(){freeboardUI.processResize(!0)}freeboardUI.showLoadingIndicator(!0);var resizeTimer;$(window).resize(function(){clearTimeout(resizeTimer),resizeTimer=setTimeout(resizeEnd,500)})}),{initialize:function(allowEdit,finishedCallback){ko.applyBindings(theFreeboardModel);var freeboardLocation=getParameterByName("load");""!=freeboardLocation?$.ajax({url:freeboardLocation,success:function(data){theFreeboardModel.loadDashboard(data),_.isFunction(finishedCallback)&&finishedCallback()}}):(theFreeboardModel.allow_edit(allowEdit),theFreeboardModel.setEditing(allowEdit),freeboardUI.showLoadingIndicator(!1),_.isFunction(finishedCallback)&&finishedCallback(),freeboard.emit("initialized"))},newDashboard:function(){theFreeboardModel.loadDashboard({allow_edit:!0})},loadDashboard:function(configuration,callback){theFreeboardModel.loadDashboard(configuration,callback)},serialize:function(){return theFreeboardModel.serialize()},setEditing:function(editing,animate){theFreeboardModel.setEditing(editing,animate)},isEditing:function(){return theFreeboardModel.isEditing()},loadDatasourcePlugin:function(plugin){_.isUndefined(plugin.display_name)&&(plugin.display_name=plugin.type_name),plugin.settings.unshift({name:"name",display_name:"Name",type:"text",required:!0}),theFreeboardModel.addPluginSource(plugin.source),datasourcePlugins[plugin.type_name]=plugin,theFreeboardModel._datasourceTypes.valueHasMutated()},resize:function(){freeboardUI.processResize(!0)},loadWidgetPlugin:function(plugin){_.isUndefined(plugin.display_name)&&(plugin.display_name=plugin.type_name),theFreeboardModel.addPluginSource(plugin.source),widgetPlugins[plugin.type_name]=plugin,theFreeboardModel._widgetTypes.valueHasMutated()},setAssetRoot:function(assetRoot){jsEditor.setAssetRoot(assetRoot)},addStyle:function(selector,rules){var styleString=selector+"{"+rules+"}",styleElement=$("style#fb-styles");0==styleElement.length&&(styleElement=$('<style id="fb-styles" type="text/css"></style>'),$("head").append(styleElement)),styleElement[0].styleSheet?styleElement[0].styleSheet.cssText+=styleString:styleElement.text(styleElement.text()+styleString)},showLoadingIndicator:function(show){freeboardUI.showLoadingIndicator(show)},showDialog:function(contentElement,title,okTitle,cancelTitle,okCallback){new DialogBox(contentElement,title,okTitle,cancelTitle,okCallback)},getDatasourceSettings:function(datasourceName){var datasources=theFreeboardModel.datasources(),datasource=_.find(datasources,function(datasourceModel){return datasourceModel.name()===datasourceName});return datasource?datasource.settings():null},setDatasourceSettings:function(datasourceName,settings){var datasources=theFreeboardModel.datasources(),datasource=_.find(datasources,function(datasourceModel){return datasourceModel.name()===datasourceName});if(!datasource)return void console.log("Datasource not found");var combinedSettings=_.defaults(settings,datasource.settings());datasource.settings(combinedSettings)},getStyleString:function(name){var returnString="";return _.each(currentStyle[name],function(value,name){returnString=returnString+name+":"+value+";"}),returnString},getStyleObject:function(name){return currentStyle[name]},showDeveloperConsole:function(){developerConsole.showDeveloperConsole()}}}();$.extend(freeboard,jQuery.eventEmitter),function(){var jsonDatasource=function(settings,updateCallback){function updateRefresh(refreshTime){updateTimer&&clearInterval(updateTimer),updateTimer=setInterval(function(){self.updateNow()},refreshTime)}var self=this,updateTimer=null,currentSettings=settings,errorStage=0,lockErrorStage=!1;updateRefresh(1e3*currentSettings.refresh),this.updateNow=function(){if(!(errorStage>1&&!currentSettings.use_thingproxy||errorStage>2)){var requestURL=currentSettings.url;2==errorStage&&currentSettings.use_thingproxy&&(requestURL=("https:"==location.protocol?"https:":"http:")+"//thingproxy.freeboard.io/fetch/"+encodeURI(currentSettings.url));var body=currentSettings.body;if(body)try{body=JSON.parse(body)}catch(e){}$.ajax({url:requestURL,dataType:1==errorStage?"JSONP":"JSON",type:currentSettings.method||"GET",data:body,beforeSend:function(xhr){try{_.each(currentSettings.headers,function(header){var name=header.name,value=header.value;_.isUndefined(name)||_.isUndefined(value)||xhr.setRequestHeader(name,value)})}catch(e){}},success:function(data){lockErrorStage=!0,updateCallback(data)},error:function(){lockErrorStage||(errorStage++,self.updateNow())}})}},this.onDispose=function(){clearInterval(updateTimer),updateTimer=null},this.onSettingsChanged=function(newSettings){lockErrorStage=!1,errorStage=0,currentSettings=newSettings,updateRefresh(1e3*currentSettings.refresh),self.updateNow()}};freeboard.loadDatasourcePlugin({type_name:"JSON",settings:[{name:"url",display_name:"URL",type:"text"},{name:"use_thingproxy",display_name:"Try thingproxy",description:'A direct JSON connection will be tried first, if that fails, a JSONP connection will be tried. If that fails, you can use thingproxy, which can solve many connection problems to APIs. <a href="https://github.com/Freeboard/thingproxy" target="_blank">More information</a>.',type:"boolean",default_value:!0},{name:"refresh",display_name:"Refresh Every",type:"number",suffix:"seconds",default_value:5},{name:"method",display_name:"Method",type:"option",options:[{name:"GET",value:"GET"},{name:"POST",value:"POST"},{name:"PUT",value:"PUT"},{name:"DELETE",value:"DELETE"}]},{name:"body",display_name:"Body",type:"text",description:"The body of the request. Normally only used if method is POST"},{name:"headers",display_name:"Headers",type:"array",settings:[{name:"name",display_name:"Name",type:"text"},{name:"value",display_name:"Value",type:"text"}]}],newInstance:function(settings,newInstanceCallback,updateCallback){newInstanceCallback(new jsonDatasource(settings,updateCallback))}});var openWeatherMapDatasource=function(settings,updateCallback){function updateRefresh(refreshTime){updateTimer&&clearInterval(updateTimer),updateTimer=setInterval(function(){self.updateNow()},refreshTime)}function toTitleCase(str){return str.replace(/\w\S*/g,function(txt){return txt.charAt(0).toUpperCase()+txt.substr(1).toLowerCase()})}var self=this,updateTimer=null,currentSettings=settings;updateRefresh(1e3*currentSettings.refresh),this.updateNow=function(){$.ajax({url:"http://api.openweathermap.org/data/2.5/weather?q="+encodeURIComponent(currentSettings.location)+"&units="+currentSettings.units,dataType:"JSONP",success:function(data){var newData={place_name:data.name,sunrise:new Date(1e3*data.sys.sunrise).toLocaleTimeString(),sunset:new Date(1e3*data.sys.sunset).toLocaleTimeString(),conditions:toTitleCase(data.weather[0].description),current_temp:data.main.temp,high_temp:data.main.temp_max,low_temp:data.main.temp_min,pressure:data.main.pressure,humidity:data.main.humidity,wind_speed:data.wind.speed,wind_direction:data.wind.deg};updateCallback(newData)},error:function(){}})},this.onDispose=function(){clearInterval(updateTimer),updateTimer=null},this.onSettingsChanged=function(newSettings){currentSettings=newSettings,self.updateNow(),updateRefresh(1e3*currentSettings.refresh)}};freeboard.loadDatasourcePlugin({type_name:"openweathermap",display_name:"Open Weather Map API",settings:[{name:"location",display_name:"Location",type:"text",description:"Example: London, UK"},{name:"units",display_name:"Units",type:"option","default":"imperial",options:[{name:"Imperial",value:"imperial"},{name:"Metric",value:"metric"}]},{name:"refresh",display_name:"Refresh Every",type:"number",suffix:"seconds",default_value:5}],newInstance:function(settings,newInstanceCallback,updateCallback){newInstanceCallback(new openWeatherMapDatasource(settings,updateCallback))}});var dweetioDatasource=function(settings,updateCallback){function onNewDweet(dweet){updateCallback(dweet)}var self=this,currentSettings=settings;this.updateNow=function(){dweetio.get_latest_dweet_for(currentSettings.thing_id,function(err,dweet){err||onNewDweet(dweet[0].content)})},this.onDispose=function(){},this.onSettingsChanged=function(newSettings){dweetio.stop_listening(),currentSettings=newSettings,dweetio.listen_for(currentSettings.thing_id,function(dweet){onNewDweet(dweet.content)})},self.onSettingsChanged(settings)};freeboard.loadDatasourcePlugin({type_name:"dweet_io",display_name:"Dweet.io",external_scripts:["http://dweet.io/client/dweet.io.min.js"],settings:[{name:"thing_id",display_name:"Thing Name",description:"Example: salty-dog-1",type:"text"}],newInstance:function(settings,newInstanceCallback,updateCallback){newInstanceCallback(new dweetioDatasource(settings,updateCallback))}});var playbackDatasource=function(settings,updateCallback){function moveNext(){currentDataset.length>0?(currentIndex<currentDataset.length&&(updateCallback(currentDataset[currentIndex]),currentIndex++),currentIndex>=currentDataset.length&&currentSettings.loop&&(currentIndex=0),currentIndex<currentDataset.length&&(currentTimeout=setTimeout(moveNext,1e3*currentSettings.refresh))):updateCallback({})}function stopTimeout(){currentDataset=[],currentIndex=0,currentTimeout&&(clearTimeout(currentTimeout),currentTimeout=null)}var currentTimeout,self=this,currentSettings=settings,currentDataset=[],currentIndex=0;this.updateNow=function(){stopTimeout(),$.ajax({url:currentSettings.datafile,dataType:currentSettings.is_jsonp?"JSONP":"JSON",success:function(data){currentDataset=_.isArray(data)?data:[],currentIndex=0,moveNext()},error:function(){}})},this.onDispose=function(){stopTimeout()},this.onSettingsChanged=function(newSettings){currentSettings=newSettings,self.updateNow()}};freeboard.loadDatasourcePlugin({type_name:"playback",display_name:"Playback",settings:[{name:"datafile",display_name:"Data File URL",type:"text",description:"A link to a JSON array of data."},{name:"is_jsonp",display_name:"Is JSONP",type:"boolean"},{name:"loop",display_name:"Loop",type:"boolean",description:"Rewind and loop when finished"},{name:"refresh",display_name:"Refresh Every",type:"number",suffix:"seconds",default_value:5}],newInstance:function(settings,newInstanceCallback,updateCallback){newInstanceCallback(new playbackDatasource(settings,updateCallback))}});var clockDatasource=function(settings,updateCallback){function stopTimer(){timer&&(clearTimeout(timer),timer=null)}function updateTimer(){stopTimer(),timer=setInterval(self.updateNow,1e3*currentSettings.refresh)}var timer,self=this,currentSettings=settings;this.updateNow=function(){var date=new Date,data={numeric_value:date.getTime(),full_string_value:date.toLocaleString(),date_string_value:date.toLocaleDateString(),time_string_value:date.toLocaleTimeString(),date_object:date};updateCallback(data)},this.onDispose=function(){stopTimer()},this.onSettingsChanged=function(newSettings){currentSettings=newSettings,updateTimer()},updateTimer()};freeboard.loadDatasourcePlugin({type_name:"clock",display_name:"Clock",settings:[{name:"refresh",display_name:"Refresh Every",type:"number",suffix:"seconds",default_value:1}],newInstance:function(settings,newInstanceCallback,updateCallback){newInstanceCallback(new clockDatasource(settings,updateCallback))}}),freeboard.loadDatasourcePlugin({type_name:"meshblu",display_name:"Octoblu",description:"app.octoblu.com",external_scripts:["http://meshblu.octoblu.com/js/meshblu.js"],settings:[{name:"uuid",display_name:"UUID",type:"text",default_value:"device uuid",description:"your device UUID",required:!0},{name:"token",display_name:"Token",type:"text",default_value:"device token",description:"your device TOKEN",required:!0},{name:"server",display_name:"Server",type:"text",default_value:"meshblu.octoblu.com",description:"your server",required:!0},{name:"port",display_name:"Port",type:"number",default_value:80,description:"server port",required:!0}],newInstance:function(settings,newInstanceCallback,updateCallback){newInstanceCallback(new meshbluSource(settings,updateCallback))}});var meshbluSource=function(settings,updateCallback){function getData(){var conn=skynet.createConnection({uuid:currentSettings.uuid,token:currentSettings.token,server:currentSettings.server,port:currentSettings.port});conn.on("ready",function(){conn.on("message",function(message){var newData=message;updateCallback(newData)})})}var self=this,currentSettings=settings;self.onSettingsChanged=function(newSettings){currentSettings=newSettings
},self.updateNow=function(){getData()},self.onDispose=function(){}}}(),function(){function easeTransitionText(newValue,textElement,duration){var currentValue=$(textElement).text();if(currentValue!=newValue)if($.isNumeric(newValue)&&$.isNumeric(currentValue)){var numParts=newValue.toString().split("."),endingPrecision=0;numParts.length>1&&(endingPrecision=numParts[1].length),numParts=currentValue.toString().split(".");var startingPrecision=0;numParts.length>1&&(startingPrecision=numParts[1].length),jQuery({transitionValue:Number(currentValue),precisionValue:startingPrecision}).animate({transitionValue:Number(newValue),precisionValue:endingPrecision},{duration:duration,step:function(){$(textElement).text(this.transitionValue.toFixed(this.precisionValue))},done:function(){$(textElement).text(newValue)}})}else $(textElement).text(newValue)}function addSparklineLegend(element,legend){for(var legendElt=$("<div class='sparkline-legend'></div>"),i=0;i<legend.length;i++){var color=SPARKLINE_COLORS[i%SPARKLINE_COLORS.length],label=legend[i];legendElt.append("<div class='sparkline-legend-value'><span style='color:"+color+"'>&#9679;</span>"+label+"</div>")}element.empty().append(legendElt),freeboard.addStyle(".sparkline-legend","margin:5px;"),freeboard.addStyle(".sparkline-legend-value","color:white; font:10px arial,san serif; float:left; overflow:hidden; width:50%;"),freeboard.addStyle(".sparkline-legend-value span","font-weight:bold; padding-right:5px;")}function addValueToSparkline(element,value,legend){var values=$(element).data().values,valueMin=$(element).data().valueMin,valueMax=$(element).data().valueMax;values||(values=[],valueMin=void 0,valueMax=void 0);var collateValues=function(val,plotIndex){values[plotIndex]||(values[plotIndex]=[]),values[plotIndex].length>=SPARKLINE_HISTORY_LENGTH&&values[plotIndex].shift(),values[plotIndex].push(Number(val)),(void 0===valueMin||valueMin>val)&&(valueMin=val),(void 0===valueMax||val>valueMax)&&(valueMax=val)};_.isArray(value)?_.each(value,collateValues):collateValues(value,0),$(element).data().values=values,$(element).data().valueMin=valueMin,$(element).data().valueMax=valueMax;var tooltipHTML='<span style="color: {{color}}">&#9679;</span> {{y}}',composite=!1;_.each(values,function(valueArray,valueIndex){$(element).sparkline(valueArray,{type:"line",composite:composite,height:"100%",width:"100%",fillColor:!1,lineColor:SPARKLINE_COLORS[valueIndex%SPARKLINE_COLORS.length],lineWidth:2,spotRadius:3,spotColor:!1,minSpotColor:"#78AB49",maxSpotColor:"#78AB49",highlightSpotColor:"#9D3926",highlightLineColor:"#9D3926",chartRangeMin:valueMin,chartRangeMax:valueMax,tooltipFormat:legend&&legend[valueIndex]?tooltipHTML+" ("+legend[valueIndex]+")":tooltipHTML}),composite=!0})}var SPARKLINE_HISTORY_LENGTH=100,SPARKLINE_COLORS=["#FF9900","#FFFFFF","#B3B4B4","#6B6B6B","#28DE28","#13F7F9","#E6EE18","#C41204","#CA3CB8","#0B1CFB"],valueStyle=freeboard.getStyleString("values");freeboard.addStyle(".widget-big-text",valueStyle+"font-size:75px;"),freeboard.addStyle(".tw-display","width: 100%; height:100%; display:table; table-layout:fixed;"),freeboard.addStyle(".tw-tr","display:table-row;"),freeboard.addStyle(".tw-tg","display:table-row-group;"),freeboard.addStyle(".tw-tc","display:table-caption;"),freeboard.addStyle(".tw-td","display:table-cell;"),freeboard.addStyle(".tw-value",valueStyle+"overflow: hidden;display: inline-block;text-overflow: ellipsis;"),freeboard.addStyle(".tw-unit","display: inline-block;padding-left: 10px;padding-bottom: 1.1em;vertical-align: bottom;"),freeboard.addStyle(".tw-value-wrapper","position: relative;vertical-align: middle;height:100%;"),freeboard.addStyle(".tw-sparkline","height:20px;");var textWidget=function(settings){function updateValueSizing(){_.isUndefined(currentSettings.units)||""==currentSettings.units?valueElement.css("max-width","100%"):valueElement.css("max-width",displayElement.innerWidth()-unitsElement.outerWidth(!0)+"px")}var currentSettings=settings,displayElement=$('<div class="tw-display"></div>'),titleElement=$('<h2 class="section-title tw-title tw-td"></h2>'),valueElement=$('<div class="tw-value"></div>'),unitsElement=$('<div class="tw-unit"></div>'),sparklineElement=$('<div class="tw-sparkline tw-td"></div>');this.render=function(element){$(element).empty(),$(displayElement).append($('<div class="tw-tr"></div>').append(titleElement)).append($('<div class="tw-tr"></div>').append($('<div class="tw-value-wrapper tw-td"></div>').append(valueElement).append(unitsElement))).append($('<div class="tw-tr"></div>').append(sparklineElement)),$(element).append(displayElement),updateValueSizing()},this.onSettingsChanged=function(newSettings){currentSettings=newSettings;var shouldDisplayTitle=!_.isUndefined(newSettings.title)&&""!=newSettings.title,shouldDisplayUnits=!_.isUndefined(newSettings.units)&&""!=newSettings.units;newSettings.sparkline?sparklineElement.attr("style",null):(delete sparklineElement.data().values,sparklineElement.empty(),sparklineElement.hide()),shouldDisplayTitle?(titleElement.html(_.isUndefined(newSettings.title)?"":newSettings.title),titleElement.attr("style",null)):(titleElement.empty(),titleElement.hide()),shouldDisplayUnits?(unitsElement.html(_.isUndefined(newSettings.units)?"":newSettings.units),unitsElement.attr("style",null)):(unitsElement.empty(),unitsElement.hide());var valueFontSize=30;"big"==newSettings.size&&(valueFontSize=75,newSettings.sparkline&&(valueFontSize=60)),valueElement.css({"font-size":valueFontSize+"px"}),updateValueSizing()},this.onSizeChanged=function(){updateValueSizing()},this.onCalculatedValueChanged=function(settingName,newValue){"value"==settingName&&(currentSettings.animate?easeTransitionText(newValue,valueElement,500):valueElement.text(newValue),currentSettings.sparkline&&addValueToSparkline(sparklineElement,newValue))},this.onDispose=function(){},this.getHeight=function(){return"big"==currentSettings.size||currentSettings.sparkline?2:1},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"text_widget",display_name:"Text",external_scripts:["plugins/thirdparty/jquery.sparkline.min.js"],settings:[{name:"title",display_name:"Title",type:"text"},{name:"size",display_name:"Size",type:"option",options:[{name:"Regular",value:"regular"},{name:"Big",value:"big"}]},{name:"value",display_name:"Value",type:"calculated"},{name:"sparkline",display_name:"Include Sparkline",type:"boolean"},{name:"animate",display_name:"Animate Value Changes",type:"boolean",default_value:!0},{name:"units",display_name:"Units",type:"text"}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new textWidget(settings))}});var gaugeID=0;freeboard.addStyle(".gauge-widget-wrapper","width: 100%;text-align: center;"),freeboard.addStyle(".gauge-widget","width:200px;height:160px;display:inline-block;");var gaugeWidget=function(settings){function createGauge(){rendered&&(gaugeElement.empty(),gaugeObject=new JustGage({id:thisGaugeID,value:_.isUndefined(currentSettings.min_value)?0:currentSettings.min_value,min:_.isUndefined(currentSettings.min_value)?0:currentSettings.min_value,max:_.isUndefined(currentSettings.max_value)?0:currentSettings.max_value,label:currentSettings.units,showInnerShadow:!1,valueFontColor:"#d3d4d4"}))}var gaugeObject,thisGaugeID="gauge-"+gaugeID++,titleElement=$('<h2 class="section-title"></h2>'),gaugeElement=$('<div class="gauge-widget" id="'+thisGaugeID+'"></div>'),rendered=!1,currentSettings=settings;this.render=function(element){rendered=!0,$(element).append(titleElement).append($('<div class="gauge-widget-wrapper"></div>').append(gaugeElement)),createGauge()},this.onSettingsChanged=function(newSettings){newSettings.min_value!=currentSettings.min_value||newSettings.max_value!=currentSettings.max_value||newSettings.units!=currentSettings.units?(currentSettings=newSettings,createGauge()):currentSettings=newSettings,titleElement.html(newSettings.title)},this.onCalculatedValueChanged=function(settingName,newValue){_.isUndefined(gaugeObject)||gaugeObject.refresh(Number(newValue))},this.onDispose=function(){},this.getHeight=function(){return 3},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"gauge",display_name:"Gauge",external_scripts:["plugins/thirdparty/raphael.2.1.0.min.js","plugins/thirdparty/justgage.1.0.1.js"],settings:[{name:"title",display_name:"Title",type:"text"},{name:"value",display_name:"Value",type:"calculated"},{name:"units",display_name:"Units",type:"text"},{name:"min_value",display_name:"Minimum",type:"text",default_value:0},{name:"max_value",display_name:"Maximum",type:"text",default_value:100}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new gaugeWidget(settings))}}),freeboard.addStyle(".sparkline","width:100%;height: 75px;");var sparklineWidget=function(settings){var titleElement=$('<h2 class="section-title"></h2>'),sparklineElement=$('<div class="sparkline"></div>'),sparklineLegend=$("<div></div>"),currentSettings=settings;this.render=function(element){$(element).append(titleElement).append(sparklineElement).append(sparklineLegend)},this.onSettingsChanged=function(newSettings){currentSettings=newSettings,titleElement.html(_.isUndefined(newSettings.title)?"":newSettings.title),newSettings.include_legend&&addSparklineLegend(sparklineLegend,newSettings.legend.split(","))},this.onCalculatedValueChanged=function(settingName,newValue){currentSettings.legend?addValueToSparkline(sparklineElement,newValue,currentSettings.legend.split(",")):addValueToSparkline(sparklineElement,newValue)},this.onDispose=function(){},this.getHeight=function(){var legendHeight=0;if(currentSettings.include_legend&&currentSettings.legend){var legendLength=currentSettings.legend.split(",").length;legendLength>4?legendHeight=.5*Math.floor((legendLength-1)/4):legendLength&&(legendHeight=.5)}return 2+legendHeight},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"sparkline",display_name:"Sparkline",external_scripts:["plugins/thirdparty/jquery.sparkline.min.js"],settings:[{name:"title",display_name:"Title",type:"text"},{name:"value",display_name:"Value",type:"calculated",multi_input:"true"},{name:"include_legend",display_name:"Include Legend",type:"boolean"},{name:"legend",display_name:"Legend",type:"text",description:"Comma-separated for multiple sparklines"}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new sparklineWidget(settings))}}),freeboard.addStyle("div.pointer-value","position:absolute;height:95px;margin: auto;top: 0px;bottom: 0px;width: 100%;text-align:center;");var pointerWidget=function(settings){function polygonPath(points){if(!points||points.length<2)return[];var path=[];path.push(["m",points[0],points[1]]);for(var i=2;i<points.length;i+=2)path.push(["l",points[i],points[i+1]]);return path.push(["z"]),path}var paper,triangle,width,height,strokeWidth=3,currentValue=0,valueDiv=$('<div class="widget-big-text"></div>'),unitsDiv=$("<div></div>");this.render=function(element){width=$(element).width(),height=$(element).height();var radius=Math.min(width,height)/2-2*strokeWidth;paper=Raphael($(element).get()[0],width,height);var circle=paper.circle(width/2,height/2,radius);circle.attr("stroke","#FF9900"),circle.attr("stroke-width",strokeWidth),triangle=paper.path(polygonPath([width/2,height/2-radius+strokeWidth,15,20,-30,0])),triangle.attr("stroke-width",0),triangle.attr("fill","#fff"),$(element).append($('<div class="pointer-value"></div>').append(valueDiv).append(unitsDiv))},this.onSettingsChanged=function(newSettings){unitsDiv.html(newSettings.units)},this.onCalculatedValueChanged=function(settingName,newValue){if("direction"==settingName){if(!_.isUndefined(triangle)){triangle.animate({transform:"r"+newValue+","+width/2+","+height/2},250,"bounce")}currentValue=newValue}else"value_text"==settingName&&valueDiv.html(newValue)},this.onDispose=function(){},this.getHeight=function(){return 4},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"pointer",display_name:"Pointer",external_scripts:["plugins/thirdparty/raphael.2.1.0.min.js"],settings:[{name:"direction",display_name:"Direction",type:"calculated",description:"In degrees"},{name:"value_text",display_name:"Value Text",type:"calculated"},{name:"units",display_name:"Units",type:"text"}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new pointerWidget(settings))}});var pictureWidget=function(settings){function stopTimer(){timer&&(clearInterval(timer),timer=null)}function updateImage(){if(widgetElement&&imageURL){var cacheBreakerURL=imageURL+(-1==imageURL.indexOf("?")?"?":"&")+Date.now();$(widgetElement).css({"background-image":"url("+cacheBreakerURL+")"})}}var widgetElement,timer,imageURL;this.render=function(element){$(element).css({width:"100%",height:"100%","background-size":"cover","background-position":"center"}),widgetElement=element},this.onSettingsChanged=function(newSettings){stopTimer(),newSettings.refresh&&newSettings.refresh>0&&(timer=setInterval(updateImage,1e3*Number(newSettings.refresh)))},this.onCalculatedValueChanged=function(settingName,newValue){"src"==settingName&&(imageURL=newValue),updateImage()},this.onDispose=function(){stopTimer()},this.getHeight=function(){return 4},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"picture",display_name:"Picture",fill_size:!0,settings:[{name:"src",display_name:"Image URL",type:"calculated"},{type:"number",display_name:"Refresh every",name:"refresh",suffix:"seconds",description:"Leave blank if the image doesn't need to be refreshed"}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new pictureWidget(settings))}}),freeboard.addStyle(".indicator-light","border-radius:50%;width:22px;height:22px;border:2px solid #3d3d3d;margin-top:5px;float:left;background-color:#222;margin-right:10px;"),freeboard.addStyle(".indicator-light.on","background-color:#FFC773;box-shadow: 0px 0px 15px #FF9900;border-color:#FDF1DF;"),freeboard.addStyle(".indicator-text","margin-top:10px;");var indicatorWidget=function(settings){function updateState(){indicatorElement.toggleClass("on",isOn),stateElement.text(isOn?_.isUndefined(onText)?_.isUndefined(currentSettings.on_text)?"":currentSettings.on_text:onText:_.isUndefined(offText)?_.isUndefined(currentSettings.off_text)?"":currentSettings.off_text:offText)}var onText,offText,titleElement=$('<h2 class="section-title"></h2>'),stateElement=$('<div class="indicator-text"></div>'),indicatorElement=$('<div class="indicator-light"></div>'),currentSettings=settings,isOn=!1;this.render=function(element){$(element).append(titleElement).append(indicatorElement).append(stateElement)},this.onSettingsChanged=function(newSettings){currentSettings=newSettings,titleElement.html(_.isUndefined(newSettings.title)?"":newSettings.title),updateState()},this.onCalculatedValueChanged=function(settingName,newValue){"value"==settingName&&(isOn=Boolean(newValue)),"on_text"==settingName&&(onText=newValue),"off_text"==settingName&&(offText=newValue),updateState()},this.onDispose=function(){},this.getHeight=function(){return 1},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"indicator",display_name:"Indicator Light",settings:[{name:"title",display_name:"Title",type:"text"},{name:"value",display_name:"Value",type:"calculated"},{name:"on_text",display_name:"On Text",type:"calculated"},{name:"off_text",display_name:"Off Text",type:"calculated"}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new indicatorWidget(settings))}}),freeboard.addStyle(".gm-style-cc a","text-shadow:none;");var googleMapWidget=function(settings){function updatePosition(){if(map&&marker&&currentPosition.lat&&currentPosition.lon){var newLatLon=new google.maps.LatLng(currentPosition.lat,currentPosition.lon);marker.setPosition(newLatLon),map.panTo(newLatLon)}}var map,marker,currentSettings=settings,currentPosition={};this.render=function(element){function initializeMap(){var mapOptions={zoom:13,center:new google.maps.LatLng(37.235,-115.811111),disableDefaultUI:!0,draggable:!1,styles:[{featureType:"water",elementType:"geometry",stylers:[{color:"#2a2a2a"}]},{featureType:"landscape",elementType:"geometry",stylers:[{color:"#000000"},{lightness:20}]},{featureType:"road.highway",elementType:"geometry.fill",stylers:[{color:"#000000"},{lightness:17}]},{featureType:"road.highway",elementType:"geometry.stroke",stylers:[{color:"#000000"},{lightness:29},{weight:.2}]},{featureType:"road.arterial",elementType:"geometry",stylers:[{color:"#000000"},{lightness:18}]},{featureType:"road.local",elementType:"geometry",stylers:[{color:"#000000"},{lightness:16}]},{featureType:"poi",elementType:"geometry",stylers:[{color:"#000000"},{lightness:21}]},{elementType:"labels.text.stroke",stylers:[{visibility:"on"},{color:"#000000"},{lightness:16}]},{elementType:"labels.text.fill",stylers:[{saturation:36},{color:"#000000"},{lightness:40}]},{elementType:"labels.icon",stylers:[{visibility:"off"}]},{featureType:"transit",elementType:"geometry",stylers:[{color:"#000000"},{lightness:19}]},{featureType:"administrative",elementType:"geometry.fill",stylers:[{color:"#000000"},{lightness:20}]},{featureType:"administrative",elementType:"geometry.stroke",stylers:[{color:"#000000"},{lightness:17},{weight:1.2}]}]};map=new google.maps.Map(element,mapOptions),google.maps.event.addDomListener(element,"mouseenter",function(e){e.cancelBubble=!0,map.hover||(map.hover=!0,map.setOptions({zoomControl:!0}))}),google.maps.event.addDomListener(element,"mouseleave",function(){map.hover&&(map.setOptions({zoomControl:!1}),map.hover=!1)}),marker=new google.maps.Marker({map:map}),updatePosition()}window.google&&window.google.maps?initializeMap():(window.gmap_initialize=initializeMap,head.js("https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false&callback=gmap_initialize"))},this.onSettingsChanged=function(newSettings){currentSettings=newSettings},this.onCalculatedValueChanged=function(settingName,newValue){"lat"==settingName?currentPosition.lat=newValue:"lon"==settingName&&(currentPosition.lon=newValue),updatePosition()},this.onDispose=function(){},this.getHeight=function(){return 4},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"google_map",display_name:"Google Map",fill_size:!0,settings:[{name:"lat",display_name:"Latitude",type:"calculated"},{name:"lon",display_name:"Longitude",type:"calculated"}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new googleMapWidget(settings))}}),freeboard.addStyle(".html-widget","white-space:normal;width:100%;height:100%");var htmlWidget=function(settings){var htmlElement=$('<div class="html-widget"></div>'),currentSettings=settings;this.render=function(element){$(element).append(htmlElement)},this.onSettingsChanged=function(newSettings){currentSettings=newSettings},this.onCalculatedValueChanged=function(settingName,newValue){"html"==settingName&&htmlElement.html(newValue)},this.onDispose=function(){},this.getHeight=function(){return Number(currentSettings.height)},this.onSettingsChanged(settings)};freeboard.loadWidgetPlugin({type_name:"html",display_name:"HTML",fill_size:!0,settings:[{name:"html",display_name:"HTML",type:"calculated",description:"Can be literal HTML, or javascript that outputs HTML."},{name:"height",display_name:"Height Blocks",type:"number",default_value:4,description:"A height block is around 60 pixels"}],newInstance:function(settings,newInstanceCallback){newInstanceCallback(new htmlWidget(settings))}})}();