# vim: ts=2 sw=2

jQuery ->

  L = (str)->
    l18n(str, "signin.js")

  class SigninView extends Backbone.View
    el: '#signinForm'
    events:
      "click #signinBtn": "login"

    initialize: ->
      @template = _.template($('#signinFormContent').html())
      @render()

    render: ->
      @$el.html(@template())
      @
      
    userName: ->
      @$el.find('#username').val()
      
    password: ->
      @$el.find('#password').val()

    validate: ->
      username = @userName()
      if _.str.isBlank(username)
        $('.alert').addClass('alert-error').text(L("user name is invalid")).show()
        return false

      password = @password()
      if _.str.isBlank(password)
        $('.alert').addClass('alert-error').text(L("password is invalid")).show()
        return false

      return true
    
    fetchAuthenToken: (url)->
      $.ajax
        url: url
        type: 'GET'
        dataType: 'json'
        data:
          'user[name]' : @userName()
        success: (data)->
          if data.error
            $('.alert').addClass('alert-error').text(data.error.text).show()
        error: (jqXHR, status, error)->
          $('.alert').addClass('alert-error').text(L("Failed to signin")).show()
          
    login: (e)->
      e.preventDefault()
      $('.alert').hide()
      
      if not @validate()
        return

      url = "signin.php"
      console.info "Signing in ..."

      formValues =
        'user[name]': @userName()
      
      @fetchAuthenToken(url).done (data)=>
        return if data.error
        authToken = data.authToken
        [token1, token2] = _.str.words(authToken, '_')
        shaObj1 = new jsSHA(@password() + token1, 'TEXT')
        shaObj2 = new jsSHA(shaObj1.getHash('SHA-1', 'HEX') + token2, 'TEXT')
        formValues['user[authHash]'] = shaObj2.getHash('SHA-1', 'HEX')
        formValues['remember_me'] = @$el.find('input[name="remember_me"]').is(':checked')

        $.ajax
          url: url
          type: 'POST'
          dataType: 'json'
          data: formValues
          success: (data)->
            if data.error
              $('.alert').addClass('alert-error').text(data.error.text).show()
            else
              console.info "sign in successfully"
              window.location.href = data.redirectUrl
          error: (jqXHR, status, error)->
            $('.alert').addClass('alert-error').text(L("Failed to signin")).show()

  window.signinView = new SigninView

  $("#languages > select").change ->
    newLang = $("#languages > select").val()
    window.location.href = "?lang="+newLang

