<?php
//vim: ts=2 sw=2

include_once "base_controller.php";

class ServiceConfigController extends BaseController {
  private $defaultFtpPort = 21;
  private $defaultHttpPort = 80;
  private $default1stFtpDataPort = 40000;
  private $default2ndFtpDataPort = 50000;

  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }
  
  protected function configFilePath() {
    $doc_root_path = $_SERVER['DOCUMENT_ROOT'];
    return build_file_path($doc_root_path, 'ports.cfg');
  }

  protected function configs() {
    $configs = array();
    $file_path = $this->configFilePath();
    if (file_exists($file_path)) {
      $lines = file($file_path, FILE_SKIP_EMPTY_LINES|FILE_IGNORE_NEW_LINES);
      foreach($lines as $line_num => $line) {
        list($name, $value) = explode("=", $line);
        $configs[trim($name)] = trim($value);
      }
    }
    return $configs;
  }
  
  protected function isPortValid($port) {
    return isset($port) && ($port > 0 && $port < 65535);
  }

  protected function doAjaxGet() {
    $response = $this->configs();
    if (!$response) {
      $response["ftp_port"] = $this->defaultFtpPort;
      $response["http_port"] = $this->defaultHttpPort;
      $response["1st_ftp_data_port"] = $this->default1stFtpDataPort;
      $response["2nd_ftp_data_port"] = $this->default2ndFtpDataPort;
    }
    $this->renderAjaxSuccess($response);
  }

  protected function doAjaxPost() {
    $configs = $this->configs();

    $configs['ftp_port'] = intval($_POST['ftp_port']);
    if (!$this->isPortValid($configs['ftp_port']))
      $configs['ftp_port'] = $this->defaultFtpPort;
    
    $configs['1st_ftp_data_port'] = intval($_POST['1st_ftp_data_port']);
    if (!$this->isPortValid($configs['1st_ftp_data_port']))
      $configs['1st_ftp_data_port'] = $this->default1stFtpDataPort;

    $configs['2nd_ftp_data_port'] = intval($_POST['2nd_ftp_data_port']);
    if (!$this->isPortValid($configs['2nd_ftp_data_port']))
      $configs['2nd_ftp_data_port'] = $this->default2ndFtpDataPort;
    
    if ($configs['2nd_ftp_data_port'] < $configs['1st_ftp_data_port'])
      $this->renderAjaxError(array(), "FtpDataPort range is invalid.");

    $configs['http_port'] = intval($_POST['http_port']);
    if (!$this->isPortValid($configs['http_port']))
      $configs['http_port'] = $this->defaultHttpPort;
    
    $buffer = array();
    foreach($configs as $key => $value) {
      $buffer[] = "$key=$value";
    }

    $file_path = $this->configFilePath();
    file_put_contents($file_path, implode("\n", $buffer));

    doReboot();
    $this->renderAjaxSuccess(array('resultCode' => 0));
  }
}

$controller = new ServiceConfigController();
$controller->run();

?>
