<?php
// vim: ts=2 sw=2 expandtab

include_once "db.php";
include_once "base_controller.php";

class ProfileController extends BaseController {
  protected function signinRequired() {
    return true;
  }
  
  protected function doAuth($u) {
    $password = $_POST['user']['old_password'];
    $authHash = $_POST['user']['old_auth_hash'];
    if (isset($password)) {
      return $u->authenticate($password);
    } else if (isset($authHash)) {
      $authRand = $_SESSION['authTokenRand'];
      unset($_SESSION['authRand']);
      return $u->authenticate2($authHash, $authRand);
    } else {
      return false;
    }
  }
  
  protected function doChangePassword($u) {
    if (!$u->isPasswordChangeEnabled())
      return false;

    $password = $_POST['user']['new_password'];
    $authHash = $_POST['user']['new_auth_hash'];
    if (isset($password)) {
      return $u->changePassword($password);
    } else if (isset($authHash)) {
      return $u->changePassword2($authHash);
    } else {
      return false;
    }
  }

  protected function doAjaxPost() {
    $response = array();
    $u = $this->curUser();
    if (!$this->doAuth($u)) {
      $this->renderAjaxError($response, L('The password you give is not correct'));
    }

    if ($this->doChangePassword($u))
      $this->renderAjaxSuccess($response);
    else
      $this->renderAjaxError($response, L('failed to update password'));
  }
}

$controller = new ProfileController();
$controller->run();

?>

