<?php
//vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class PermissionController extends BaseController {

  protected function signinRequired() {
    return true;
  }

  protected function doAjaxGet() {
    $u = $this->curUser();
    $user_id = null;
    if (isset($_GET['user_id']))
      $user_id = $_GET['user_id'];
    if (isset($user_id)) {
      $response = array();
      if ($user_id != $u->attr("id"))
        $this->renderAjaxError($response, L("permission denied"));
    } else {
      $response = array();
      if (!$u->isAccountManagementEnabled())
        $this->renderAjaxError($response, L("permission denied"));
      $user_id = null;
    }

    $model = new Permission();
    $perms = $model->permissions($user_id);
    
    $rows = array();
    foreach($perms as $perm) {
      $parts = array();
      foreach($perm as $key => $value) {
          $parts[] = "\"$key\": \"$value\""; 
      }
      $rows[] = "{" . implode(',', $parts) . "}";
    }
    $response = "{\"data\":  [" . implode(',', $rows) . "] }";
    die($response);
  }

  protected function doAjaxPost() {
    $response = array();
    if (!$this->curUser()->isAccountManagementEnabled())
      $this->renderAjaxError($response, L("permission denied"));

    $user_id = $_POST['user_id'];
    if (!isset($user_id)) {
      $this->renderAjaxError($response, sprintf(L("invalid %s"), "user_id"));
    }

    $u = new User();
    $u->findById($user_id);
    $error = $u->updatePermissions($_POST['perms'], $_POST['dev_readable'], $_POST['dev_writable']);
    if (!empty($error))
      $this->renderAjaxError($response, $error);
    
    $u->changeHomePage($_POST['home_page']);
    $this->renderAjaxSuccess($response);
  }
}

$controller = new PermissionController();
$controller->run();

?>
