<?php
// vim: ts=2 sw=2

include_once "db.php";
include_once "settings.php";
include_once "feature_control.php";
include_once "base_controller.php";

class GraphicController extends BaseController {
  protected function signinRequired() {
    return true;
  }
  
  public function cptToolsBackupUrl() {
    return $this->makeUrl("../CPT-Tools.zip");
  }
  
  protected function doGet() {
    if (FeatureControl::instance()->isEnabled("Graphic"))
      return;

    $u = $this->curUser();
    if (FeatureControl::instance()->isEnabled("Dashboard")
      && isset($u) && $u->isDashboardEnabled() && $u->isDashboardLanding())
      $this->redirect($this->makeUrl("dashboard/index.php"));
    else
      $this->redirect($this->makeUrl("app/landing_page.php"));
  }

  public function plugins() {
    $plugins = collectPlugins();
    foreach($plugins as &$plugin) { 
      if (!isset($plugin['indexFile']))
        continue;

      $plugin['url'] = $this->makeUrl($plugin['indexFile']);
    }
    return $plugins;
  }

}

$controller = new GraphicController();
$controller->run();
$u = $controller->curUser();

?>

<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php echo Config::$webPageTitle ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="../css/bootstrap.min.css" media="screen" />
    <!-- <link rel="stylesheet" href="../css/slider.css" /> -->
    <link rel="stylesheet" href="../css/bootstrap-datetimepicker.min.css" />
    <link rel="stylesheet" href="../css/graphics.css" />
    <link rel="stylesheet" href="../css/d3-gauge_simple.css" />
    <link rel="stylesheet" href="../css/daterangepicker-bs2.css" />

    <link rel="stylesheet" href="../js/jstree/themes/default/style.min.css" />

    <script language="javascript" type="text/javascript">
      window.cur_account_info = {
        'name': '<?php echo htmlspecialchars($u->attr('name'), ENT_QUOTES|ENT_HTML401) ?>',
        'is_admin': <?php echo $u->isAdmin() ? 1 : 0 ?>, 
      };

      function is_admin() {
        return cur_account_info && ('is_admin' in cur_account_info) && cur_account_info['is_admin'];
      }
      
      window.platformName = '<?php echo platformName() ?>';
      window.firmwareFileName = '<?php echo firmwareFileName() ?>';
      window.firmwareVersion = '<?php echo firmwareVersion() ?>';
      window.firmwarePatchLevel = '<?php echo firmwarePatchLevel() ?>';
      window.sdcardExisted = <?php echo does_sdcard_exist() ? 'true' : 'false'; ?>;
    </script>

    <script type="text/javascript" src="../js/l18n.js"></script>

<?php
  if (isset($_GET["dev"])) {
?>
    <script type="text/javascript" src="../js/json2.js"></script>
    <script type="text/javascript" src="../js/jquery-1.10.0.js"></script>
    <script type="text/javascript" src="../js/bootstrap.js"></script>
    <script type="text/javascript" src="../js/bootstrap-contextmenu.js"></script>
    <script type="text/javascript" src="../js/underscore.js"></script>
    <script type="text/javascript" src="../js/underscore.string.js"></script>
    <script type="text/javascript" src="../js/backbone.js"></script>
    <script type="text/javascript" src="../js/spin.min.js"></script>
    <script type="text/javascript" src="../js/jstree/jstree.min.js"></script>
    <script type="text/javascript" src="../js/jquery.form.min.js"></script>
    <script type="text/javascript" src="../js/graphic.js"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="../js/json2.min.js"></script>
    <script type="text/javascript" src="../js/jquery-1.10.0.min.js"></script>
    <script type="text/javascript" src="../js/bootstrap.min.js"></script>
    <script type="text/javascript" src="../js/bootstrap-contextmenu.min.js"></script>
    <script type="text/javascript" src="../js/underscore-min.js"></script>
    <script type="text/javascript" src="../js/underscore.string.min.js"></script>
    <script type="text/javascript" src="../js/backbone-min.js"></script>
    <script type="text/javascript" src="../js/spin.min.js"></script>
    <script type="text/javascript" src="../js/jstree/jstree.min.js"></script>
    <script type="text/javascript" src="../js/jquery.form.min.js"></script>
    <script type="text/javascript" src="../js/graphic.min.js"></script>
<?php
  }
?>
  </head>
  <body>
    <div class="container">
      <div class="row">
        <div id="navSideBarControlBtn" class="unhighlight">
          <a href="#">-</a>
        </div>
        <div id="leftSideBar" style="display: none;" >
          <div id="grNav">
          </div>

          <div class="btn-group" id="userBtn">
            <a class="btn btn-inverse" data-toggle="dropdown" href="#">
              <i class="icon-user icon-white"></i> <?php echo htmlspecialchars($_SESSION['user_name'], ENT_QUOTES|ENT_HTML401) ?>
            </a>
            <a class="btn btn-inverse dropdown-toggle" data-toggle="dropdown" href="#"><span class="caret"></span></a>
            <ul class="dropdown-menu">
<?php 
  $accountMenuItem = 0;
  if ($u->isPasswordChangeEnabled()) {
    $accountMenuItem = $accountMenuItem + 1;
?>
  <li><a href="#" id="userProfile" data-username="<?php echo htmlspecialchars($_SESSION['user_name'], ENT_QUOTES|ENT_HTML401) ?>" data-userid="<?php echo $_SESSION['user_id'] ?>"><i class="icon-pencil"></i> <?php echo L('Change Password...') ?></a></li>
<?php } ?>
<?php 
  if (isset($u) && $u->isAccountManagementEnabled()) {
    $accountMenuItem = $accountMenuItem + 1;
    $manageStr = L('Manage...');
    echo <<<EOS
              <li><a href="#" id="userManagement"><i class="icon-th-list"></i> $manageStr</a></li>
EOS
    ;
  }
?>
<?php if ($accountMenuItem > 0) { ?>
              <li class="divider"></li>
<?php } ?>
              <li><a href="signout.php"><i class="i"></i> <?php echo L('Signout') ?></a></li>
            </ul>
          </div>
            
<?php
  if (isset($u) && $u->isUtilityEnabled()) {
      $utilityBtn = L('Utilities');
      echo <<<EOS
          <div class="btn-group" id="utilityTools">
            <a class="btn btn-info" data-toggle="dropdown" href="#"><i class="icon-wrench icon-white"></i> {$utilityBtn}</a>
            <a class="btn btn-info dropdown-toggle" data-toggle="dropdown" href="#"><span class="caret"></span></a>
            <ul class="dropdown-menu">
EOS;
      if ($u->isSystemEnabled()) {
        $backupStr = L('Backup...');
        $restoreStr = L('Restore...');
        $restartStr = L('Restart...');
        $rebootStr = L('Reboot...');
        $upgradeFWStr = L('Upgrade Firmware...');
        echo <<<EOI
              <li><a id="utilityBackup" href="#">$backupStr</a></li>
              <li><a id="utilityRestore" href="#">$restoreStr</a></li>
              <li class="divider"></li>
              <li><a id="utilityRestart" href="#">$restartStr</a></li>
              <li><a id="utilityReboot" href="#">$rebootStr</a></li>
              <li class="divider"></li>
EOI;
        if (FeatureControl::instance()->isEnabled("FirmwareUpgrade")) {
          echo <<<EOI
              <li><a id="utilityUpgradeFirmware" href="#">$upgradeFWStr</a></li>
              <li class="divider"></li>
EOI;
        }
      }

      if (FeatureControl::instance()->isEnabled("PortConfig")) {
        $configPortsStr = L('Config Ports...');
        echo <<<EOP
            <li><a id="utilityServicePort" href="#">$configPortsStr</a></li>
EOP;
      }
      $changeDateTimeStr = L('Change DateTime...');
      echo <<<EOS
              <li><a id="utilityDateTime" href="#">$changeDateTimeStr</a></li>
EOS;
      if (FeatureControl::instance()->isEnabled("ChangeSysPassword"))
      {
        echo '<li class="divider"></li>';
        echo '<li><a id="utilityChangeSysPassword" href="#">'.L('Change OS Account Password...').'</a></li>';
      }

      $phpLiteAdminStr = L('DB Manager...');
      echo <<<EOS
              <li class="divider"></li>
              <li><a href="utility.php?action=run_phpliteadmin" target="_blank">$phpLiteAdminStr</a></li>
EOS;

      $cptToolsPath = cptToolsPath();
      if (file_exists($cptToolsPath)) {
        echo '<li class="divider"></li>';
        echo '<li><a href="' . $controller->cptToolsBackupUrl() . '">'.L('Download CPT Tools').'</a></li>';
      }

      echo <<< EOS
            </ul>
          </div>
EOS;
}
?>

          <?php if (FeatureControl::instance()->isEnabled("Dashboard")) { ?>
          <div id="utilityDashboard" style="<?php echo isset($u) && $u->isDashboardEnabled()  ? '' : 'display: none;' ?>">
          <a href="../dashboard/index.php" class="btn btn-info" type="button" target="_blank"><i class="icon-th icon-white"></i> <?php echo L('Dashboard') ?></a>
          </div>
          <?php } ?>

<?php 
  //Plugin buttons
  if (isset($u) && FeatureControl::instance()->isEnabled("Plugin")) {
    $pluginsBtn = L('Plugins');
    $plugins = $controller->plugins();
    if (!empty($plugins)) {
      echo <<<EOS
        <div class="btn-group" id="pluginsBtn">
          <a class="btn btn-info" data-toggle="dropdown" href="#"><i class="icon-gift icon-white"></i> {$pluginsBtn}</a>
          <a class="btn btn-info dropdown-toggle" data-toggle="dropdown" href="#"><span class="caret"></span></a>
          <ul class="dropdown-menu">
EOS;
      foreach($plugins as $plugin) {
        if (!$plugin['show'])
          continue;

        if ($plugin['openNewPage'])
          echo "<li><a href='". $plugin['url'] . "' target='_blank' >" . $plugin['name'] ."</a></li>";
        else
          echo "<li><a href='". $plugin['url'] . "' >" . $plugin['name'] ."</a></li>";
      }
      echo <<< EOS
            </ul>
          </div>
EOS;
  }
  }
?>

        </div>

        <div id="grCanvas" class="span10">
        </div>
      </div>
    </div>

    <div id="grObjectMenu">
    </div>

    <div id="askParamModal" class="modal hide fade">
    </div>

    <div id="modalDialog" class="modal hide fade" data-backdrop="static">
    </div>

    <div id="invokeActionModal" class="modal hide fade">
    </div>

    <div id="writePropertyModal" class="modal hide fade">
    </div>

    <div id="alertMessage" class="modal hide fade">
    </div>

    <div id="changePasswordModal" class="modal hide fade">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><?php echo L('Change Password') ?></h3>
      </div>

      <div class="modal-body">
        <div class="alert hide">
        </div>

        <form class='form-horizontal' autocomplete="nope">
          <div class="control-group">
          <label class="control-label" for="inputOldPassword"><?php echo L('Password') ?></label>
            <div class="controls">
              <input type="password"  id="inputOldPassword" placeholder="<?php echo L('Password') ?>" autofocus>
              <span class='help-inline hide'></span>
            </div>
          </div>

          <div class="control-group">
          <label class="control-label" for="inputNewPassword"><?php echo L('New Password') ?></label>
            <div class="controls">
            <input type="password" id="inputNewPassword" placeholder="<?php echo L('New Password') ?>">
              <span class='help-inline hide'></span>
            </div>
          </div>

          <div class="control-group">
          <label class="control-label" for="inputConfirmPassword"><?php echo L('Confirm New Password') ?></label>
            <div class="controls">
              <input type="password" id="inputConfirmPassword" placeholder="<?php echo L('Confirm New Password') ?>">
              <span class='help-inline hide'></span>
            </div>
          </div>
        </form>

      </div>

      <div class="modal-footer">
        <a href="#" class="btn btn-primary"><?php echo L('Save') ?></a>
      </div>
    </div>

    <!--  Account Management -->
    <div id="accountManagementModal" class="modal hide fade" style="width: 700px;">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><?php echo L('Manage') ?></h3>
      </div>

      <div class="modal-body">
        <div class="tabbable">
          <ul class="nav nav-tabs">
            <li class="active"><a href="#permissionsPanel" data-toggle="tab"><?php echo L('Permissions') ?></a></li>
            <li><a href="#accountsPanel" data-toggle="tab"><?php echo L('Accounts') ?></a></li>
            <li><a href="#newAccountPanel" data-toggle="tab"><?php echo L('Create') ?></a></li>
            <li><a href="#sessionTTLPanel" data-toggle="tab"><?php echo L('Session') ?></a></li>

<?php
  if (isset($u) && $u->isAdmin()) {
?>
            <li><a href="#authKeyPanel" data-toggle="tab"><?php echo L('AuthKey') ?></a></li>
<?php } ?>
          </ul>
          <div class="tab-content">
            <div class="tab-pane active" id="permissionsPanel"></div>
            <div class="tab-pane" id="accountsPanel"></div>
            <div class="tab-pane" id="newAccountPanel"></div>
            <div class="tab-pane" id="sessionTTLPanel"></div>
<?php
  if (isset($u) && $u->isAdmin()) {
?>
            <div class="tab-pane" id="authKeyPanel"></div>
<?php } ?>
          </div>
        </div>
      </div>
    </div>

    <script type="text/template" id="new_account_tpl">
      <div class="alert hide"> </div>
      <form class="form-horizontal" autocomplete="nope">
        <div class="control-group">
          <label class="control-label" for="inputName"><?php echo L('Name') ?></label>
          <div class="controls">
            <input type="text" id="inputName" placeholder="<?php echo L('Name') ?>" autofocus>
            <span class='help-inline hide'></span>
          </div>
        </div>
        <div class="control-group">
          <label class="control-label" for="inputPassword"><?php echo L('Password') ?></label>
          <div class="controls">
            <input type="password" id="inputPassword" placeholder="<?php echo L('Password') ?>">
            <span class='help-inline hide'></span>
          </div>
        </div>
        <div class="control-group">
          <div class="controls">
            <label >
              <input class="inputEnableUtility" type="checkbox"> <?php echo L('Enable Utility Tools') ?>
            </label>
            <label>
              <input class="inputEnableSystem" type="checkbox"> <?php echo L('Enable System Tools') ?>
            </label>
            <label>
              <input class="inputEnableAccountManagement" type="checkbox"> <?php echo L('Enable Account Management') ?>
            </label>
            <label>
              <input class="inputEnablePasswordChange" type="checkbox"> <?php echo L('Enable Password Change') ?>
            </label>
            <?php if (FeatureControl::instance()->isEnabled("UIControl") && isDashboardExisted()) { ?>
            <label>
              <input class="inputEnableDashboard" type="checkbox"> <?php echo L('Enable Dashboard') ?>
            </label>
            <label>
              <input class="inputDashboardAsLandingPage" type="checkbox"> <?php echo L('Dashboard As Landing Page') ?>
            </label>
            <?php } ?>
          </div>
        </div>
        <div class="control-group">
          <div class="controls">
            <button id="create_account_btn" type="submit" class="btn btn-primary"><?php echo L('Create') ?></button>
          </div>
        </div>
      </form>
    </script>

    <script type="text/template" id="user_name_tpl">
      <li <% if (index == 0) print('class="active"'); %> >
        <a href="#user_<%= user.get('user_id') %>" data-user_id="<%= user.get('user_id') %>" data-toggle="tab"><%- user.get('name') %></a>
      </li>
    </script>

    <script type="text/template" id="user_permissions_tpl">
      <div id="user_<%= user.get('user_id') %>" class="tab-pane <% if (index == 0) print("active"); %>">
        <div class="alert hide"></div>
        <table class="table table-striped table-hover">
          <thead>
            <tr>
              <th><?php echo L('Path') ?></th>
              <th><?php echo L('NoAccess') ?></th>
              <th><?php echo L('ReadOnly') ?></th>
              <th><?php echo L('ReadWrite') ?></th>
              <th><?php echo L('Home') ?></th>
            </tr>
          </thead>
          <tbody> 
          <% _.each(user.permissions(), function(perm) { %>
            <tr data-grpath='<%= perm.path %>'> 
              <td style="padding-left:<%= perm.indent %>px">
                <i class='<%= user.iconFor(perm) %>'></i> <%= perm.name %>
              </td>
              <td>
                <label class="radio">
                  <input class="perm-radio" type="radio" name="perm_<%= user.get('user_id') %>_<%= perm.path %>" value="noaccess" <% if (user.isNoAccess(perm)) print('checked'); %> />
                </label>
              </td>
              <td>
                <label class="radio">
                  <input class="perm-radio" type="radio" name="perm_<%= user.get('user_id') %>_<%= perm.path %>" value="readonly" <% if (user.isReadOnly(perm)) print('checked'); %> />
                </label>
              </td>
              <td>
                <label class="radio">
                  <input class="perm-radio" type="radio" name="perm_<%= user.get('user_id') %>_<%= perm.path %>" value="readwrite"  <% if (user.isReadWrite(perm)) print('checked'); %> />
                </label>
              </td>
              <td>
                <% if (!perm.isGroup) {%>
                <label class="radio">
                  <input type="radio" name="home_page-<%= user.get('user_id') %>" class="home_page-radio" value="<%= perm.path %>" <% if (user.home_page() == perm.path) print('checked'); %> >
                </label>
                <%}%>
              </td>
            </tr>
          <% }); %>
          </tbody>
        </table> 

        <div class="control-group" >
          <div class="controls controls-row">
            <button class="dev-perm-toggle btn btn-link pull-left" type="button"><?php echo L('Developer Permission') ?></button>
          </div>
          <div class="controls controls-row dev-perm-config" style="display:none;">
            <label class="alert" style="margin-top: 6px; margin-bottom: 4px;"><?php echo L("Following settings will enable 3rd party service to Read/Write sedona app's data through the Data API provided by CPT Graphic web service , don't change it if you aren't sure what it is. Refer CPT Web Data API document for more details.") ?></label>
            <label class="checkbox span3">
              <input class="dev-readable-checkbox" type="checkbox" <% if (user.isDevReadable()) print("checked='checked'"); %> > <?php echo L('Read Data') ?>
            </label>
            <label class="checkbox span3">
              <input class="dev-writable-checkbox" type="checkbox" <% if (user.isDevWritable()) print("checked='checked'"); %> > <?php echo L('Write Data') ?>
            </label>
          </div>
        </div>

        <div class="pull-right">
          <button class="btn btn-primary permission-save-btn" type="button"><?php echo L('Save') ?></button>
        </div>
      </div>
    </script>

    <script type="text/template" id="account_name_tpl">
      <li <% if (index == 0) print('class="active"'); %> >
        <a href="#account_<%= account.get('user_id') %>" data-user_id="<%= account.get('user_id') %>" data-toggle="tab"><%= account.get('name') %></a>
      </li>
    </script>

    <script type="text/template" id="account_details_tpl">
      <div id="account_<%= account.get('user_id') %>" class="tab-pane <% if (index == 0) print("active"); %>">
        <div class="alert hide"></div>

        <form class="form-horizontal" autocomplete="nope">
          <div class="control-group">
            <label class="control-label" for="inputPasswordUpdate"><?php echo L('New Password') ?></label>
            <div class="controls">
              <input type="password" id="inputPasswordUpdate" placeholder="<?php echo L('Leave blank to not change') ?>">
              <span class='help-inline hide'></span>
            </div>
          </div>
          <div class="control-group">
            <div class="controls">
              <label>
                <input class="inputEnableUtility" type="checkbox" <% if (account.get('utility_enabled') == 't') print("checked='checked'"); %> > <?php echo L('Enable Utility Tools') ?>
              </label>
              <label>
                <input class="inputEnableSystem" type="checkbox" <% if (account.get('system_enabled') == 't') print("checked='checked'"); %> > <?php echo L('Enable System Tools') ?>
              </label>
              <label>
                <input class="inputEnableAccountManagement" type="checkbox" <% if (account.get('account_management_enabled') == 't') print("checked='checked'"); %> > <?php echo L('Enable Account Management') ?>
              </label>
              <label>
                <input class="inputEnablePasswordChange" type="checkbox" <% if (account.get('password_change_enabled') == 't') print("checked='checked'"); %> > <?php echo L('Enable Password Change') ?>
              </label>
              <?php if (FeatureControl::instance()->isEnabled("UIControl") && isDashboardExisted()) { ?>
              <label>
                <input class="inputEnableDashboard" type="checkbox" <% if (account.get('dashboard_enabled') == 't') print("checked='checked'"); %> > <?php echo L('Enable Dashboard') ?>
              </label>
              <label>
                <input class="inputDashboardAsLandingPage" type="checkbox" <% if (account.get('dashboard_as_landing_page') == 't') print("checked='checked'"); %> > <?php echo L('Dashboard As Landing Page') ?>
              </label>
              <?php } ?>
            </div>
          </div>

<?php
  if (isset($u) && $u->isAdmin()) {
    $deleteBtnStr = L('Delete');
    echo <<<EOS
          <% if (account.get('name') != "{$u->attr('name')}") { %>
          <div class='pull-left'>
            <button class="btn btn-danger delete-account-btn" type="button">$deleteBtnStr</button>
          </div>
          <% } %>
EOS;
  }
?>

          <div class="control-group">
            <div class="controls">
              <button id="update_account_btn" type="submit" class="btn btn-primary"><?php echo L('Update') ?></button>
            </div>
          </div>
        </form>
      </div>
    </script>

    <script type="text/template" id="session_ttl_tpl">
      <div class="alert hide"> </div>
      <form class="form-horizontal">
        <div class="control-group">
          <div class="controls">
            <label class="checkbox">
              <input class="inputEnableSessionTTL" type="checkbox"> <?php echo L('Enable Session Control') ?>
            </label>
          </div>
        </div>
        <div class="control-group">
          <label class="control-label" for="inputSessionTTL"><?php echo L('Max Time Length:') ?></label>
          <div class="controls">
            <input type="text" id="inputSessionTTL" placeholder="<?php echo L('Session life in minutes') ?>">
            <span class='help-inline hide'></span>
          </div>
        </div>
        <div class="control-group">
          <div class="controls">
            <button id="save_session_ttl_btn" type="submit" class="btn btn-primary"><?php echo L('Save') ?></button>
          </div>
        </div>
      </form>
    </script>

    <script type="text/template" id="auth_key_entry_tpl">
      <tr data-auth_key='<%= key %>' class="hidden <%= expired_cls %>"> 
        <td>
          <i class='icon-certificate'></i> <%= key %>
        </td>
        <td>
          <%= expired_at %>
        </td>
        <td>
          <%= note %>
        </td>
        <td>
          <button class="btn btn-mini edit-auth-key"><?php echo L('Edit') ?></button>
          <button class="btn btn-mini btn-danger del-auth-key"><?php echo L('Delete') ?></button>
        </td>
      </tr>
    </script>

    <script type="text/template" id="auth_key_edit_entry_tpl">
      <tr data-auth_key='<%= key %>' style="display: none;">
        <td colspan="4">
          <form class="edit-auth-key-form form-inline">
            <div class="expiry-date-edit-container input-append" style="display: inline;">
            <input type="text" class="expiry-date-edit" placeholder="Expiry Date" value="<%= expired_at %>" readonly></input> <span class="add-on"> <i class="icon-calendar"></i> </span>
            </div>
            <input type="text" class="note-edit" placeholder="Note" value="<%= note %>" style="margin-left:10px; margin-right: 10px;"></input>
            <button type="submit" class="btn btn-mini btn-primary"><?php echo L('Save') ?></button>
            <button class="btn btn-mini cancel-btn"><?php echo L('Cancel') ?></button>
          </form>
        </td>
      </tr>
    </script>

    <script type="text/template" id="auth_keys_tpl">
      <div class="alert hide"></div>
      <form class="new-auth-key-form form-horizontal">
        <div class="control-group">
          <label class="control-label" for="inputAuthKeyExpiration"><?php echo L('Expiry Date') ?></label>
          <div class="controls input-append" id="authKeyExpiration" style="display: block;">
            <input type='text' id="inputAuthKeyExpiration" readonly></input>
            <span class="add-on">
              <i class="icon-calendar"></i>
            </span>
          </div>
        </div>
        <div class="control-group">
          <label class="control-label" for="inputAuthKeyNote"><?php echo L('Note') ?></label>
          <div class="controls">
            <input id="inputAuthKeyNote" type="text" placeholder="<?php echo L('Note for this AuthKey') ?>">
          </div>
        </div>
        <div class="control-group">
          <div class="controls">
            <button id="save_auth_key_btn" type="submit" class="btn btn-primary"><?php echo L('Create') ?></button>
          </div>
        </div>
      </form>
      <hr/>
      <table class="table table-striped table-hover">
        <thead>
          <tr>
            <th><?php echo L('Key') ?></th>
            <th><?php echo L('Expiry Date') ?></th>
            <th><?php echo L('Note') ?></th>
            <th></th>
          </tr>
        </thead>
        <tbody> 
        </tbody>
      </table> 
    </script>

    <script type="text/template" id="modal_tpl">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h3><%= title %></h3>
      </div>
      <div class="modal-body">
        <div class="alert hide"></div>
        <%= message %>
      </div>
      <div class="modal-footer">
        <% if (!_.str.isBlank(btnHtml)) { %><%= btnHtml %><% } %>
        <a href="#" class="btn" data-dismiss="modal"><?php echo L('Close') ?></a>
      </div>
    </script>

    <script type="text/template" id="table_view_tpl">
      <table class="table table-striped table-bordered">
        <thead>
          <tr>
            <th><?php echo L('Time') ?></th>
            <% _.each(columns, function(col) { %>
              <th><%= col.get('label') %></th>
            <% }); %>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </script>

    <script type="text/template" id="backup_upload_tpl">
      <div id="backup_alert_panel" class="alert hide"></div>
      <div id='backup_upload_panel'>
        <?php echo L('Drop backup folder/file here to upload') ?>
      </div>

      <div id='backup_file_list' class='dropzone-previews' >
        <h5 style="margin-top:0;margin-bottom:0;"><?php echo L('Selected Files:') ?></h5>
      </div>
      <div class="row">
        <?php if (does_sdcard_exist()) { ?>
        <div class="pull-left" style="margin-left:20px;">
          <label style="display: inline;" ><?php echo L('Storage Type:') ?></label>
          <select id="storage_type" name="data[type]" style="width: 90px;">
          <option value="flash"><?php echo L("Flash") ?></option>
          <option value="sdcard"><?php echo L("SDCard") ?></option>
          </select>
        </div>
        <?php } ?>
        <div class="controls pull-right"><button class="btn btn-primary disabled" disabled="disabled" data-loading-text="<?php echo L("Upload") ?>..." data-compressing-text="<?php echo L("Compressing") ?>..."><?php echo L('Upload') ?></button></div>
      </div>
      <div id="backup_upload_progress" class="progress progress-info progress-striped">
        <div class="bar" style="width: 0%"></div>
      </div>
    </script>

    <script type="text/template" id="backup_entry_preview_tpl">
      <div class="dz-preview dz-file-preview">
        <div class="dz-filename"><span data-dz-name></span> (<span data-dz-size></span>)</div>
      </div>
    </script>

    <?php frontendLangJson() ?>
    <?php include ("check_browser.php"); ?>

<?php
  if (isset($_GET["dev"])) {
?>
    <!--  Charts -->
    <!-- <script type="text/javascript" src="../js/jquery.flot.js"></script> -->
    <script type="text/javascript" src="../js/jquery.flot.min.js"></script>
    <!-- <script type="text/javascript" src="../js/jquery.flot.time.js"></script> -->
    <script type="text/javascript" src="../js/jquery.flot.time.min.js"></script>
    <script type="text/javascript" src="../js/jquery.flot.selection.min.js"></script>

    <!-- <script type="text/javascript" src="../js/d3.v3.js"></script> -->
    <script type="text/javascript" src="../js/d3.v3.min.js"></script>
    <script type="text/javascript" src="../js/d3-gauge.js"></script>

    <script type="text/javascript" src="../js/RGraph/RGraph.common.core.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.common.effects.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.common.dynamic.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.thermometer.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.vprogress.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.hprogress.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.meter.js"></script>
    <!-- <script type="text/javascript" src="../js/moment.js"></script> -->
    <script type="text/javascript" src="../js/moment.min.js"></script>
    <script type="text/javascript" src="../js/daterangepicker.js"></script>
    <script type="text/javascript" src="../js/jstz.min.js"></script>

    <!-- <script type="text/javascript" src="../js/bootstrap&#45;slider.js"></script> -->
    <script type="text/javascript" src="../js/date.js"></script>
    <!-- <script type="text/javascript" src="../js/bootstrap&#45;datetimepicker.js"></script> -->
    <script type="text/javascript" src="../js/bootstrap-datetimepicker.min.js"></script>
    <script type="text/javascript" src="../js/sha1.js"></script>
    <script type="text/javascript" src="../js/dropzone.js"></script>
    <script type="text/javascript" src="../js/jszip.js"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="../js/jquery.flot.min.js"></script>
    <!-- <script type="text/javascript" src="../js/jquery.flot.time.js"></script> -->
    <script type="text/javascript" src="../js/jquery.flot.time.min.js"></script>
    <script type="text/javascript" src="../js/jquery.flot.selection.min.js"></script>

    <!-- <script type="text/javascript" src="../js/d3.v3.js"></script> -->
    <script type="text/javascript" src="../js/d3.v3.min.js"></script>
    <script type="text/javascript" src="../js/d3-gauge.min.js"></script>

    <script type="text/javascript" src="../js/RGraph/RGraph.common.core.min.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.common.effects.min.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.common.dynamic.min.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.thermometer.min.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.vprogress.min.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.hprogress.min.js"></script>
    <script type="text/javascript" src="../js/RGraph/RGraph.meter.min.js"></script>
    <!-- <script type="text/javascript" src="../js/moment.js"></script> -->
    <script type="text/javascript" src="../js/moment.min.js"></script>
    <script type="text/javascript" src="../js/daterangepicker.min.js"></script>
    <script type="text/javascript" src="../js/jstz.min.js"></script>

    <!-- <script type="text/javascript" src="../js/bootstrap&#45;slider.min.js"></script> -->
    <script type="text/javascript" src="../js/date.min.js"></script>
    <!-- <script type="text/javascript" src="../js/bootstrap&#45;datetimepicker.js"></script> -->
    <script type="text/javascript" src="../js/bootstrap-datetimepicker.min.js"></script>
    <script type="text/javascript" src="../js/sha1.js"></script>
    <script type="text/javascript" src="../js/dropzone.min.js"></script>
    <script type="text/javascript" src="../js/jszip.min.js"></script>
<?php
  }
?>
  </body>
</html>
