<?php
//vim: ts=2 sw=2

include_once "base_controller.php";
//include "HttpClient.class.php";
include_once "UDPClient.class.php";

class DataAPIController extends BaseController { 
  public $host, $port;
  private $client;

  function __construct() {
    $this->host = "127.0.0.1";
    //$this->port = "88"; // for weblet
    $this->port = "1001"; // for udp service

    $this->client = NULL;
  }

  function forwardHostName() {
    return $this->host . ":" . $this->port;
  }

  function getClient() {
    if (is_null($this->client))
    {
      $this->client = new UDPClient($this->host, $this->port);
      //$this->client = new HttpClient($this->forwardHostName());
      $this->client->setDebug(false);
    }
    return $this->client;
  }

  protected function sameHostAuthFree() {
    return true;
  }

  protected function signinRequired() {
    return true;
  }
  protected function authKeyRequired() {
    return true;
  }

  public function doAjaxGet() {
    if (!$this->sameHostAuthFree() && !$this->isReadable()) {
      $this->renderAjaxError($response, L("permission denied"));
    }

    $newUrl = $this->forwardURL();
    $client = $this->getClient();
    if ($client->get($newUrl)) {
      $content = $client->getContent();
      if (empty($content))
          die('{"response": ""}');
      else
          die('{"response": ' . $content . '}');
    }
    else
    {
      // die('An error occurred: ' . $client->getError());
      die('{"error": {"text": "' . L('failed to get data: ') . $client->getError() . '"}}');
    }
  }

  public function doAjaxPost() {
    $response = array();
    if (!$this->sameHostAuthFree() && !$this->isWritable()) {
      $this->renderAjaxError($response, L("permission denied"));
    }

    $client = $this->getClient();
    if (isset($_POST['reqs']) && is_array($_POST['reqs'])) {
      if (count($_POST['reqs']) > 255)
        $this->renderAjaxError($response, L("at most 255 requests at one time."));

      $is_action = isset($_POST['is_action']) && boolval($_POST['is_action']);
      $client->doMultiRequest($is_action, $_POST['reqs']);
    } else {
      if ($_POST['slotType'] == 'action')
        $client->invokeAction($_POST['path'], $_POST['type'], $_POST['value']);
      elseif ($_POST['slotType'] == 'property')
        $client->writeProperty($_POST['path'], $_POST['type'], $_POST['value']);
      else {
        if (isset($_POST['slotType']))
          $this->renderAjaxError($response, "invalid 'slotType' value: " . $_POST['slotType']);
        else
          $this->renderAjaxError($response, "'slotType' parameter is missing");
      }
    }
    $content = $client->getContent();
    if (empty($content))
      die('{"response": ""}');
    else
      die('{"response": ' . $content . '}');
  }

  function forwardURL() {
    if (function_exists("filter_var"))
        return filter_var($_GET['url'], FILTER_SANITIZE_URL);
    else
        return $_GET['url'];
    //if($_SERVER['QUERY_STRING']=="")
    //return $path;
    //else
    //return $path. "?" . $_SERVER['QUERY_STRING'];
  }
}

$controller = new DataAPIController();
$controller->run();

?>
