<?php 

function applyPatch() {
  //*** REMEMBER To change minVersion and patchLevel 
  $minVersion = "V3.0b51a";
  $patchLevel = "1";
  //*** 

  $platform = platformName();
  if ($platform != "FS")
    return;

  $curPatchLevel = firmwarePatchLevel();
  if (intval($patchLevel) <= intval($curPatchLevel)) {
    error_log("patch had been applied already (current patch level: $curPatchLevel)");
    return;
  }
  
  //NOTE: only apply patch if firmware is older than $minVersion(inclusive)
  $curVersion = firmwareVersion();
  if (isFirmwareGreaterThan($minVersion) || $curVersion != $minVersion)
  {
    error_log("skip this patch (current version: $curVersion)");
    return;
  }

  //appy patch, it may be different for different patch 
  $patchesPath = __DIR__;
  error_log("start to apply patch ...");
  $cmd = "(cd $patchesPath && cp -rp root/* / && echo SUCCESS) || echo ERROR";
  $output = rtrim(`$cmd`);
  if (!endsWith($output, 'SUCCESS')) {
    error_log("failed to apply firmware patches: " . $output);
  } else {
    $patchLevelFile = "/mnt/sedona/patch_level";
    file_put_contents($patchLevelFile, $patchLevel);
    error_log("patch is applied successfully.");
  }
}

applyPatch();
