(function() {
  var spinner = null;
  
  jQuery(function() {
    var setMsg = function(msg, isError) {
      var elem = $("#msgDiv");
      if (msg.length == 0) {
        elem.hide();
        return;
      }

      elem.html("<h5>"+msg+"</h5>");
      if (isError)
        elem.addClass("error");
      else
        elem.addClass("success");
      elem.show();
    };

    // set up restore logics
    var doRestore = function (e) {
      var btnElem = $(e.target);
      var table = btnElem.parents('table');
      var elem = table.parent("div");
      var name = btnElem.parent("td").siblings('td.backup-name').text();
      var type = table.data("type");
      var withNetworkConf = btnElem.parent("td").parent("tr").find('input.with-network-conf').is(":checked");
      
      var confirmed = confirm("Are you sure to restore to '" + name + "' ?");
      if (!confirmed)
        return;
      
      $.ajax({
        type: "POST", 
        url: "utility.php",
        data: {action: 'restore', 'data[name]': name, 
               'data[type]': type, 'data[withNetworkConf]': withNetworkConf},
        dataType: 'json', 
        beforeSend: function() {
          setMsg('');
          if (!spinner)
            spinner = new Spinner();
          spinner.spin(elem[0]);
        },
        success: function(data) {
          if (data.error) {
            setMsg(data.error.text, true);
            spinner.stop();
          }
          else if (data.redirect)
            window.localtion.href = data.redirect;
          else {
            setTimeout(function() { window.location.assign(window.location.origin); }, 35000);
            setMsg("Backup " + name + " is restored. Reloading ...", false);
          }
        },
        error: function(data, status) {
          spinner.stop();
          setMsg("error: " + status, true);
        },
        complete: function(data, status) {
          //spinner.stop();
        },
      });
    };

    $(".backupList button").bind("click", doRestore);
    
    //server state checker 
    ServerStateCheckerSingleton = (function() {
      var ServerStateChecker, instance;

      function ServerStateCheckerSingleton() {}

      instance = null;

      ServerStateCheckerSingleton.instance = function() {
        return instance != null ? instance : instance = new ServerStateChecker;
      };

      ServerStateChecker = (function() {
        function ServerStateChecker() {
          this.doCheck = _.bind(this.doCheck, this);
        }

        ServerStateChecker.prototype.check = function(timeout, delay) {
          if (timeout == null) {
            timeout = 3000;
          }
          if (delay == null) {
            delay = 45000;
          }
          this.retryTimes = 100;
          this.timeout = timeout;
          console.debug("wait for " + delay/1000 + " seconds before checking ...");
          return _.delay(this.doCheck, delay);
        };

        ServerStateChecker.prototype.doCheck = function() {
          var _this = this;

          console.info("do server check " + this.retryTimes + " ...");
          --this.retryTimes;
          return $.ajax({
            url: "./ping.php",
            timeout: this.timeout,
            beforeSend: function() {
              return _this.queryTime = Date.now();
            },
            error: function(jq, status) {
              var delay;

              console.debug("request error: " + status);
              if (jq.status === 404) {
                return $(window).trigger("serverReady");
              } else {
                if (_this.retryTimes > 0) {
                  delay = _this.timeout - (Date.now() - _this.queryTime);
                  if (delay > 500) {
                    return _.delay(_this.doCheck, delay);
                  } else {
                    return _this.doCheck();
                  }
                } else {
                  return $(window).trigger("serverTimeout");
                }
              }
            },
            success: function() {
              return $(window).trigger("serverReady");
            }
          });
        };

        return ServerStateChecker;

      })();

      return ServerStateCheckerSingleton;

    }).call(this);
    
    // set up firmware upgrade logics
    window.upgradeView = (function(elem) {
      var self = {'elem': elem};

      var removeErrors = function() {
        self.elem.find('.alert').removeClass('alert-error').hide()
      };
      
      var onFileSelected = function() {
        removeErrors();
        if (validateFileInput())
          enableUpgradeBtn(true);
        else
          enableUpgradeBtn(false);
      };
      
      var enableUpgradeBtn = function(enable) { 
        if (enable)
          self.elem.find('.upgrade-button').removeAttr("disabled")
        else
          self.elem.find('.upgrade-button').attr("disabled", "disabled")
      };
      
      var validateFileInput = function() {
        var filePath = userSelectedFile();

        if (_.str.isBlank(filePath)) {
          self.elem.find('.alert').removeClass('alert-success').addClass('alert-error').html("Firmware file is not specified.").show();
          return false;
        }

        if (!_.str.endsWith(filePath, window.firmwareFileName)) {
          self.elem.find('.alert').removeClass('alert-success').addClass('alert-error').html("Firmware file name must be '" + window.firmwareFileName + "'.").show();
          return false;
        }

        return true;
      };
      
      var userSelectedFile = function() {
        return self.elem.find('#inputFirmwareFile').val()
      };

      var resetUpgradeState = function() {
        var primaryBtn = self.elem.find('.upgrade-button');
        primaryBtn.removeClass("disabled").removeAttr("disabled");
        
        var btnText = primaryBtn.html()
        if (_.str.endsWith(btnText, '...'))
          primaryBtn.html(_.str.rtrim(btnText, '.'))

        if (spinner)
          spinner.stop();
      };
      
      var onServerReady = function() {
        self.elem.find('.alert').removeClass('alert-error').addClass('alert-success').html("Controller is rebooted, reload page now ...").show();
        _.delay(function() {
          resetUpgradeState();
          location.reload();
        }, 750);
      };
      
      var onServerTimeout = function() {
        self.elem.find('.alert').removeClass('alert-success').addClass('alert-error').html("Controller timeout.").show()
        resetUpgradeState()
      };
      
      var onRebootSuccess = function() {
        self.elem.find('.alert').removeClass('alert-error').addClass('alert-success').html("Rebooting controller ...").show()
        $(window).on('serverReady', onServerReady)
        $(window).on('serverTimeout', onServerTimeout)
        var checker = ServerStateCheckerSingleton.instance()
        checker.check()
      }; 
      
      var onRebootFailure = function() {
        resetUpgradeState()
        self.elem.find('.alert').removeClass('alert-success').addClass('alert-error').html("Failed to reboot controller.").show()
      };
      
      var doReboot = function() { 
        self.elem.find('.alert').removeClass('alert-error').addClass('alert-success').html("Start to reboot controller ...").show();
        
        $.ajax({
          'type': 'POST',
          'url': 'utility.php',
          'data': {'action': 'reboot'},
          'dataType': 'json',
          'success': onRebootSuccess,
          'error': onRebootFailure
        });
      }

      self.elem.find("input:file").change(onFileSelected);
      self.elem.find('form').ajaxForm({
        beforeSubmit: function(){
          removeErrors();

          var primaryBtn = self.elem.find('.upgrade-button');

          if (validateFileInput()) {
            self.elem.find('#firmware-upgrade-progress').show().find('.bar').width("0%")
            self.elem.find('.alert').addClass('alert-success').removeClass('alert-error').text('Start to upload firmware file ...').show()

            primaryBtn.attr("disabled", "disabled");

            btnText = primaryBtn.html();
            if(!_.str.endsWith(btnText, '...'))
              primaryBtn.html(btnText+"...");
            
            if (!spinner)
              spinner = new Spinner();
            spinner.spin(self.elem[0]);

            return true;
          }
          else
            return false;
        },
        uploadProgress: function(event, pos, total, percentComplete) {
          self.elem.find('#firmware-upgrade-progress .bar').width(percentComplete+"%");
        },
        success: function(responseText, statusText, xhr, form) {
          self.elem.find('#firmware-upgrade-progress .bar').width("100%")
          var uploadSuccess = _.str.startsWith(responseText, "SUCCESS:")
          if (uploadSuccess) {
            self.elem.find('.alert').removeClass('alert-error').addClass('alert-success').html(responseText).show();
            _.delay(doReboot, 750);
          }
          else {
            self.elem.find('.alert').removeClass('alert-success').addClass('alert-error').html(responseText).show();
            resetUpgradeState();
          }
        },
        complete: function() {
          self.elem.find('#firmware-upgrade-progress').hide();
        }
      });

      return self;

    })($("#firmware_upgrade_panel"));

  });
}).call(this);
