#! /usr/bin/env python

import os
import re
import json
import codecs
import xml.etree.ElementTree as ET

tools_path = os.path.dirname(os.path.realpath(__file__))
base_path = os.path.realpath(os.path.join(tools_path, ".."))
langs_path = os.path.realpath(os.path.join(base_path, 'public', 'langs'))

def doWork(file_type, ts_list):
    for ts_file in ts_list:
        ts_dict = {}
        ts_path = os.path.join(langs_path, ts_file)
        ts_node = ET.parse(ts_path)
        root = ts_node.getroot()
        for context_node in root.iter('context'):
            name_node = context_node.find('name')
            tr_dict = {}
            for msg_node in context_node.iter('message'):
                src_node = msg_node.find('source')
                tr_node = msg_node.find('translation')
                if src_node is None or tr_node is None:
                    continue
                if tr_node.get('type') is not None:
                    continue

                tr_dict[src_node.text] = tr_node.text

            ts_dict[name_node.text] = tr_dict
        root, ext = os.path.splitext(ts_path)
        output_path = root + '.json'
        with codecs.open(output_path, 'w', encoding='utf-8') as f:
            f.write(json.dumps(ts_dict, ensure_ascii=False))


if __name__ == '__main__':
    lang_codes = ('zh_CN', 'ko', 'nl', 'es', 'fr')
    for file_type in ('backend', 'frontend'):
        ts_list = ['cpt-web_'+file_type+'_'+code+'.ts' for code in lang_codes]
        doWork(file_type, ts_list)

