function loadL18nDict() {
  if (!window.l18nJsonData) {
    var elem = document.getElementById('l18nJson');
    if (elem)
      window.l18nJsonData = JSON.parse(elem.innerHTML);  
  }
}

function l18n(str, context) {
  loadL18nDict();

  if (context == null)
    context = '';

  if (typeof(l18nJsonData) !== "undefined" && l18nJsonData !== null)
  {
    if ((context in l18nJsonData) && (str in l18nJsonData[context]))
      return l18nJsonData[context][str];
    else
      return str;
  }
  else
    return str;
}

String.prototype.supplant = function (o) {
  return this.replace(/{([^{}]*)}/g,
      function (a, b) {
        var r = o[b];
        return typeof r === 'string' || typeof r === 'number' ? r : a;
      });
}
